#--------------------------
# plip connectivity 
#--------------------------

default()
{
ACTION=ask_the_user
RESOURCE="PLIP support"
VAR_LIST="INTERFACE IP REMOTE  DEFAULTROUTE NETMASK MASQ"
HIDDEN_LIST=""
MOD_LIST="plip"
INTERFACE='plip1'
IP='192.168.1.1'
REMOTE='192.168.1.2'
DEFAULTROUTE='n'
NETMASK='255.255.255.0'
MASQ='n'
}

info()
{
cat <<END
	                - PLIP setup -

PLIP (Parallel Line Internet Protocol) is used to create a mini
network by connecting the parallel ports of two local machines.

  You'll need a 12-conductor cable to make one yourself. The wiring is:
    SLCTIN      17 - 17
    GROUND      25 - 25
    D0->ERROR   2 - 15          15 - 2
    D1->SLCT    3 - 13          13 - 3
    D2->PAPOUT  4 - 12          12 - 4
    D3->ACK     5 - 10          10 - 5
    D4->BUSY    6 - 11          11 - 6
  Do not connect the other pins. NO WARRANTY! 

N.B.: standard lp.o lineprinter driver is incompatible with
plip.o driver and will be automatically removed.

END

}

stop()
{
ifconfig | rgrep $INTERFACE > /dev/null || return 
ifconfig $INTERFACE down
(cat /proc/modules | rgrep plip >/dev/null) && rmmod plip
echo "$INTERFACE down."
}

status()
{
ifconfig | rgrep $INTERFACE > /dev/null
if [ $? -eq 0 ] ; then
	echo "up"
else
	echo "down"
fi

}

prepare()
{
resource=$1

        rmmod lp 2>/dev/null
        load_module net/plip

# determine interface number

        save=$IFS; IFS=:
        set -- `cat /proc/net/dev| rgrep plip`
        INTERFACE=$1; IFS=$save
        save -n plip configure

prompt INTERFACE "$INTERFACE"
prompt IP   "$IP"   "Enter IP address of this side"
prompt REMOTE "$REMOTE" "Enter IP address of the other side"
prompt DEFAULTROUTE "$DEFAULTROUTE" "Is it $REMOTE your defaultroute (y/n)?"
prompt NETMASK "$NETMASK" "Enter NETMASK or \"\" "

cat <<END

        Enable masquerading (NAT) for IP packets coming from the
        network?

END

prompt MASQ "$MASQ"



save -n $resource configure
}

acoustic_log()
{
wave -c 440 2 ; wave -c 880 4
}

configure()
{
	
	rmmod lp 2>/dev/null
	cat /proc/modules | rgrep plip >/dev/null
	[ $? -ne 0 ] && load_module net/plip

# netmask?

        if [ "$NETMASK" != "" ] ; then
        network_default $IP $NETMASK
        fi

# config plip

	opt="${BROADCAST:+broadcast $BROADCAST}"
	opt="$opt ${NETMASK:+netmask $NETMASK}"

	ifconfig ${INTERFACE} down
	ifconfig ${INTERFACE} ${IP} pointopoint ${REMOTE} $opt up 
	route add ${REMOTE} ${INTERFACE}


	[ "$NETWORK" ] && route add -net $NETWORK $INTERFACE 

# default route?

        if [ "$DEFAULTROUTE" = y ] ; then
                route add default gw ${REMOTE} ${INTERFACE}
        fi


# and now put it in as masquerade

	if [ "$MASQ" = y ] ; then
	ipfwadm -F -a m -S ${REMOTE}
	fi

# acoustic log

	rustic_ping ${REMOTE} 
	if [ $? -eq 0 ] ; then 
		echo "PLIP [$INTERFACE] parallel link to host ${REMOTE} is OK."
	fi
}
