#--------------------------
# nokia cell phone support 
#--------------------------
#set -x

default()
{
ACTION=ask_the_user
RESOURCE="Nokia 51xx 61xx support"
VAR_LIST="DEVICE MODEL"
HIDDEN_LIST=""
MOD_LIST=""
DEVICE='/dev/ttyS0'
MODEL='6150'
}

info()
{
cat <<END
		-- Nokia 61xx (serial cable) support --

This utility allow you to use a Nokia 61xx cell phone, connected
via serial port, as modem. It is based on the GNOKII package, 
(C) 1999, 2000 Hugh Blemings & Pavel Jank ml.

When the support is up, you can use the special device /dev/gnokii
as your device modem. You can use to dial out, either with "pppd",
either with "miterm".
 
	-- The Nokia support use libc6 and libthread. PERL
	   addon is required.
END
}

check_libc6()
{
ldconfig -v 2>/dev/null| rgrep libc.so.6 > /dev/null
}

requirement()
{
if [ "`which gnokiid`" ] && check_libc6 ; then
	return 0
else
	echo "(VNC & PERL addon required)"
	return 1
fi
}


down()
{
  echo "Disabling Nokia virtual modem"
  update_inittab
  rm -f /var/run/$resource 2>/dev/null
  rm -f /var/log/gnokiid.log
}

up()
{
   > /var/log/gnokiid.log
  ID=NM
  echo "Enabling Nokia virtual modem"; sleep 1
  update_inittab $ID
  echo `pidof mgetty` > /var/run/$resource
}

update_inittab()
{
  repl="s/^NM/#NM/g"
  [ "$1" ] && repl="$repl; s/^#$1/$1/g"

  cat /etc/inittab | sed "$repl" > /tmp/inittab
  cp /tmp/inittab  /etc/inittab
  rm /tmp/inittab
  init q
}



stop()
{
down
stop-daemon gnokiid >/dev/null
}


prepare()
{
resource=$1

prompt MODEL "$MODEL" "Nokia model (6150/6110/5110)"
prompt DEVICE "$DEVICE" "Device where your Nokia is attached"

save -n $resource configure
}

wait_for_link()
{
while [ 1 ] ; do
[ -L /dev/gnokii ]  && break
done

# wait to link become up (10s) 
timeout 10 'while [ "`cat /var/log/gnokiid.log 2>/dev/log`" ]; do : ; done'
}

status()
{
pid=`pidof gnokiid`

#chat -t 3 '' AT OK < /dev/gnokii > /dev/gnokii 2>/dev/null
rc=$?

if [ "$pid" ]; then
     	echo up
else
	echo down 
fi
}


configure()
{

  supported device ttyS 
  if [ $? -ne 0 ] ; then
	setup -f port
  fi


# create the gnokii config file 

cmd=`which gnokiid`
bindir=`dirname $cmd`

cat > /etc/gnokiirc <<END
[global]
port = $DEVICE 
model = $MODEL
initlength = default
connection = serial
bindir = $bindir 
END

up

echo -n "Checking Nokia ... "
wait_for_link
status
}
