#-------------------------
# NFS configuration
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="NFS (Network File System) client support"
VAR_LIST="NFS_SERVER NFS_ROOT NFS_REMOTE_DIR NFS_LOCAL_DIR AUTO_MOUNT"
HIDDEN_LIST=""
MOD_LIST=""
NFS_SERVER=''
NFS_ROOT=''
NFS_REMOTE_DIR=''
NFS_LOCAL_DIR='/nfs'
AUTO_MOUNT='n'
}

info()
{

tell <<END
		- Network File System (NFS) support -

If You want to use this system as diskless client (as an X-terminal,
for example) you can mount your root file system (NFS_ROOT)
from a NFS_SERVER. For this, save this configuration and reboot. When the
system comes up again, your / is mounted via NFS from NFS_SERVER. 
		 
With this setup You can also/however mount via NFS a single 
NFS_REMOTE_DIR to your NFS_LOCAL_DIR mounting point. 

More info:

	-- nfsroot.txt (kernel's docs)
	-- NFS-root mini Howto
	-- man exports(5)
END

}

prepare()
{
resource=$1

	prompt NFS_SERVER ${NFS_SERVER:-$GATEWAY} 

tell << END

	If you want nfsroot service You must provide a NFS_ROOT: 
	this directory will be mounted as your root partition.
	On the NFS server, the /etc/exports must contains something like:

		NFS_ROOT	client-ipaddr(rw,no_root_squash)

	(To activate nfsroot, you must save the profile and reboot
	with this floppy-disk)

END

prompt want_nfsroot n "Do You want nfsroot service(y/n)?"

if [ "$want_nfsroot" = y ]; then
	prompt NFS_ROOT $NFS_ROOT
fi

tell << END

        If your server can export to You some NFS_REMOTE_DIR, You
	cat mount it to some NFS_LOCAL_DIR.
	Leave blank or set it to "" if this is undesidered. 

END

prompt NFS_REMOTE_DIR $NFS_REMOTE_DIR
prompt NFS_LOCAL_DIR  $NFS_LOCAL_DIR

if [ "$NFS_REMOTE_DIR" ] ; then
	prompt AUTO_MOUNT $AUTO_MOUNT "Automatic mount on boot?(y/n)"
else
	AUTO_MOUNT=n
fi

save -n $resource configure
}



configure()
{
load_module ${MOD_LIST} 

[ -z "$NFS_REMOTE_DIR" ] && return

if [ -z "`cat /etc/fstab | rgrep ${NFS_LOCAL_DIR}`" ]; then
cat >> /etc/fstab << END

# NFS partition $NFS_LOCAL_DIR

${NFS_SERVER}:${NFS_REMOTE_DIR} ${NFS_LOCAL_DIR} nfs defaults,rw

END
fi

if [ "$AUTO_MOUNT" = y ] ; then
tell "Mounting remote file systems (if any)"
mkdir -p $NFS_LOCAL_DIR
mount -v -t nfs -a
fi
}
