#--------------------------------------
# Config. networking 
#--------------------------------------

default()
{
ACTION=configure
RESOURCE="to configure networking"
VAR_LIST="HOSTNAME INTERFACES DOMAIN GATEWAY NAMESERVER"
HIDDEN_LIST=""
MOD_LIST=""
HOSTNAME='mulinux'
INTERFACES='eth0 eth1 plip ppp0 ppp1 lo'
DOMAIN='sanvittore.it'
GATEWAY=''
NAMESERVER=''
}

info()
{
tell <<END
			-  Networking Info -

This Setup collects global info about this host (DNS nameserver,
default gateway, hostname, etc) using, eventually, the DHCP cache. 

You can specify a list of network interfaces that should be
scanned; the first right IP address found will be dynamically assigned
to the hostname, at run-time.

END

}

requirement()
{
if [ -r /usr/bin/ifconfig ] ; then
	return 0
else
	return 1
fi
}


sanitize()
{
HOSTNAME=mulinux
NAMESERVER=
save -n $1 ask_the_user
}


# Setup network files in /etc 

network_files()
{

echo "`tell Updating` /etc/hosts,/etc/resolv.conf, /etc/networks ..."

if [ "$HOSTNAME" ] ; then
	hostname $HOSTNAME
	echo $HOSTNAME > /etc/hostname
fi

FULL=
if [ "$DOMAIN" ] ; then
domainname $DOMAIN
echo > /etc/domainname
add_entry file=/etc/resolv.conf key=domain table="domain,$DOMAIN"
FULL="$HOSTNAME.$DOMAIN"
fi



if [ "$HOSTNAME" ] && [ "$IP" ] ; then
add_entry file=/etc/hosts key=$HOSTNAME table="$IP,$HOSTNAME"
[ "$FULL" ] && add_entry file=/etc/hosts key=$FULL table="$IP,$FULL"
fi

# /etc/resolv.conf

if [ "$NAMESERVER" ] ; then
add_entry file=/etc/resolv.conf key=$NAMESERVER table="nameserver,$NAMESERVER"
else
#> /etc/resolv.conf
#add_entry file=/etc/resolv.conf key=nameserver table=""
ne=$(cat /etc/resolv.conf | sed -n /^nameserver/P)
	if [ "$ne" ] ; then
	echo "Warning: NAMESERVER is blank but you have"
	echo "a spurious 'nameserver' entry in /etc/resolv.conf."
	fi
fi

# /etc/networks

if [ "$NETWORK" ] ; then
name="${INTERFACE}_net"
add_entry file=/etc/networks key=$name table="$name,$NETWORK"
fi
}

# local network networking

local_network()
{
kernel=`uname -r`
hostname ${HOSTNAME}
ifconfig lo 127.0.0.1

case ${kernel} in
2.0.*)
        route add -net 127.0.0.0
        ;;
esac
}

network_check()
{
        set -- `ifconfig $INTERFACE | rgrep "inet addr" | tr : ' '`
        ip=$3
        if [ "$ip" != 0.0.0.0 ] && [ "$ip" ] ; then
                return 0
        else
                return 1
        fi
}


status()
{
dev=$(
ifconfig | rgrep eth; 
ifconfig | rgrep ppp; 
ifconfig | rgrep plip; 
)

if [ "$dev" ] ; then
	echo up
else
	echo down
fi
}

store()
{
echo "`tell Storing` /etc/hosts, /etc/resolv.conf, /etc/networks ..."
cp /etc/hosts /setup/cnf/store
cp /etc/resolv.conf /setup/cnf/store
cp /etc/networks /setup/cnf/store
}


load_dhcp()
{
f="/etc/dhcpc/hostinfo-$INTERFACE"
if [ -f $f ] ; then
        . $f
else
      	return 1 
fi
rm $f  # remove the DHCP cache (?)
IP=$IPADDR
tell "Found DHCP info for %s. Please, confirm." | printf -r "$INTERFACE"
eval `cat /etc/dhcpc/resolv.conf |
while read x y
do
case $x in
domain)     echo DOMAIN=$y;;
nameserver) echo NAMESERVER=$y;;
esac
done`

}

get_interfaces()
{
local ip_list=
for i in $@
do
ip_list="$ip_list $i:`get_ip $i`"
done
echo ${ip_list}
}

prepare()
{
resource=$1

# load DHCP info, if any

for INTERFACE in eth0 eth1
do
	load_dhcp
done

prompt HOSTNAME "$HOSTNAME" 
prompt DOMAIN "$DOMAIN" 

# what is the IP to be assigned to HOSTNAME?
# this is usefull in assigning the right /etc/hosts entry

ip_list=`get_interfaces eth0 eth1 plip ppp0 ppp1 lo`

(
tell <<END
		    - assign an IP addr to %s -	

	Currently, this is the list of active network interfaces
	and theyr IP address:

			  %s	

	You can choice a list of network interface to be dynamically 
	scanned, in order: the first IP found will be assigned in
	/etc/hosts as ip_addr for %s.

END
) | printf -r "$HOSTNAME" "${ip_list}" "$HOSTNAME"

	prompt INTERFACES "$INTERFACES"

tell <<END

	WORKSTATION system can specify a default gateway.
	This is useful if this gateway can forward your packets 
	outsides, i.e. to Internet.

	Enter "" if you don't want set  this default route.

END

prompt GATEWAY "$GATEWAY"

tell <<END

	Internet address (in dot notation) of a name server
	that should query for host name resolution.
	Enter ""  if You don't want a DNS.

END

prompt NAMESERVER "${NAMESERVER:-${GATEWAY}}"
save -n $resource configure

}


stop()
{
ethconfig stop
}


configure()
{
# define IP

for i in $INTERFACES
do
IP=`get_ip $i`
[ "$IP" ] && [ "$IP" != '0.0.0.0' ] && break
done
tell "My name is [%s], my IP is [%s]." | printf -r "$HOSTNAME" "$IP"

local_network
network_files

# default route

if [ "$GATEWAY" ] ; then
	route add default gw $GATEWAY
fi
}
