#-------------------------
# netled 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="the netled resource monitor"
VAR_LIST="INTERFACE REFRESH"
HIDDEN_LIST=""
MOD_LIST=""
INTERFACE='ppp0'
REFRESH=1000
}


info()
{
tell <<END
	         - NETLED interface monitor -

netled is a device monitoring utility designed to help a system 
administrator monitor the transmission and  receiving of 
data over a loopback, ppp connection, or ethernet connection.

The CAPS-LOCK led is used for send-data and the SCROLL-LOCK
led for the received-data.

Special useful for PPP.

		- Author Matthew Bevan <mbevan@mars.ark.com>

END
}

requirement()
{
if [ "`which netled`" ]; then
        return 0
else
        echo "(SRV addon required)"
        return 1
fi
}


prepare()
{
resource=$1
prompt INTERFACE "$INTERFACE" \
"Enter the interface to listen on (ppp0,ppp1,eth0,lo,..."

prompt REFRESH "$REFRESH"
save -n $resource configure
}

status()
{
pid=`pidof netled`
if [ "$pid" ] ; then
        echo up
else
        echo down
fi
}

stop()
{
stop-daemon netled
}


configure()
{
netled tty1 $INTERFACE $REFRESH 2>/dev/null & 
}
