#-------------------------
#  named 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to configure a DomainNameServer (named)"
VAR_LIST="HOSTNAME DOMAIN NETWORK NAMESERVER MODE"
HIDDEN_LIST=""
MOD_LIST=""
HOSTNAME='server'
DOMAIN='sanvittore.it'
NETWORK='192.168.1.0'
NAMESERVER='212.216.112.222'
MODE='dynamic'
}

info()
{
tell <<END
	        	- named (nameserver) setup -

A DNS converts machine names to the IP numbers, and viceversa.
Enabling this Setup, this machine can acts as "name resolver"
for all hosts in your internal LAN. If you have a more
authoritative nameserver that I should contacts for addresses
outside of your LAN (e.g. in Internet), I can forward my
requests to it.  

	-- test with "setup named test"  
END
}



requirement()
{
if [ "`which named`" ]; then
        return 0
else
	echo "(SRV addon required)"
        return 1
fi

}


status()
{
if [ "`pidof named`" ] ; then
	echo up
else
	echo down
fi
}

store()
{
if [ -f /etc/named/named-hosts ] ; then
echo "`tell Storing` /etc/named/named-hosts ..."
cp /etc/named/named-hosts /setup/cnf/store 2>/dev/null
fi
}

restore()
{
if [ ! -f /etc/named/named-hosts ] ; then
	cp /setup/cnf/store/named-hosts /etc/named
fi
}

stop()
{
tell "Shutting down DNS daemon: named ..."
resolv_down
stop-daemon named
}

prepare()
{
resource=$1
set -- `( include network.cnf;
echo $HOSTNAME; echo $DOMAIN; echo $NAMESERVER )` 
HOSTNAME=${HOSTNAME:-$1}
DOMAIN=${DOMAIN:-$2}
NAMESERVER=${NAMESERVER:-$3}

set -- $(route -n | rgrep " U ")
NETWORK=${NETWORK:-$1}

cat <<END
======================================================================
My hostname is $(em [$HOSTNAME]). I will becomes the DNS master
for the domain $(em [$DOMAIN]), corresponding to network $(em [$NETWORK]).
This means: I can answer with authority for address in the 
form $(em \*.$DOMAIN), but I will forward every unresolved
query to $(em [$NAMESERVER]).
If you specify a blank '' NAMESERVER, forwarding will be disabled.
======================================================================
Please, correct if required.

END

prompt HOSTNAME "$HOSTNAME"
prompt DOMAIN "$DOMAIN"
prompt NETWORK "$NETWORK"
prompt NAMESERVER "$NAMESERVER"

tell <<END
======================================================================
I can operate in 3 different modes:

stand-alone	(I never contact the external DNS; I will use my DB)
forward-only	(I *only* contact the external DNS; my DB is ignored)
dynamic		(I contact the external DNS only if connected)
======================================================================
END

prompt MODE "$MODE"

echo -e "$BRIGHT"
tell <<END
	Please Note! You *must* add the entry "nameserver 127.0.0.1"
	at the top of the file /etc/resolv.conf, otherwise the
	clients can send your queries to me, and I, simply, will
	remain idle forever! 
END
echo -e "$NORMAL"


restore
if create_hosts
then
	store > /dev/null
fi
save -n $resource configure
}

reverse_network()
{
save=$IFS; IFS="."
set -- $NETWORK
IFS=$save
echo "$3.$2.$1"
}

get_last()
{
save=$IFS; IFS="."
set -- $1
IFS=$save
echo "$4"
}

chop()
{
echo $@ | tr -d ' '
}

ag()
{
echo "; Automatically generated - DO NOT EDIT"
echo "; `date`"
}

create_root()
{
[ -z "$NAMESERVER" ] && return 
echo "`tell named: enabling forwarding to DNS` $NAMESERVER" 1>&2
cat <<END
.       6D      IN NS   bogus.root.org
bogus.root.org.   5w6d16h IN A $NAMESERVER 
END
}

create_options()
{
ag > /etc/named/options
for o in $@
do
	echo "options $o" >> /etc/named/options
done
}

create_forwarder()
{
local yes=$1
ag > /etc/named/forwarders
ag > /etc/named/root
if [ $NAMESERVER ] && [ "$yes" = y ] ; then
	echo "forwarders $NAMESERVER" >> /etc/named/forwarders
	create_root >> /etc/named/root	
fi
}

create_primary()
{
ag > /etc/named/localnet
rev=`reverse_network`
cat >> /etc/named/localnet <<END
primary $DOMAIN           zone/localnet
primary $rev.in-addr.arpa  rev/localnet
END
}

create_SOA()
{
cat <<END
@       IN      SOA     $DOMAIN. postmaster.$DOMAIN. (
                            `random`   ; Serial
                         604800         ; Refresh
                          86400         ; Retry
                        2419200         ; Expire
                         604800 )       ; Default TTL

END
}

create_zone()
{
tell "named: Building zone info ..."
(ag; create_SOA) > /etc/named/zone/localnet
my_ip=`get_my_ip`
[ -z "$my_ip" ] && abort "$HOSTNAME is not in the /etc/named/hosts"

cat >>/etc/named/zone/localnet <<END
        IN      NS      dns
dns     IN      CNAME   $HOSTNAME 
END

cat /etc/named/named-hosts |
while read ip hosts
do
	for host in ${hosts}; do
	echo "$host  IN      A       $ip" >> /etc/named/zone/localnet 
	done
done
}

create_rev()
{
tell "named: Building rev info ..."
(ag; create_SOA) > /etc/named/rev/localnet
my_ip=`get_my_ip`
[ -z "$my_ip" ] && abort "$HOSTNAME is not in the /etc/named/hosts"

cat >>/etc/named/rev/localnet <<END
@ IN    NS      dns.$(chop $DOMAIN).
END

cat /etc/named/named-hosts |
while read ip hosts
do
	for host in $hosts; do
	last=`get_last $ip`
	host=$(chop $host)
        echo "$last  IN  PTR   $host.$DOMAIN." >> /etc/named/rev/localnet
	done
done
}

get_my_ip()
{
set -- `cat /etc/named/named-hosts | sed -n "/$HOSTNAME/P"`
echo $1 
}

create_hosts()
{
tell <<END
Ok, the real stuff, now.
This setup utility mantains a database in the file /etc/named/named-hosts.
This files looks strictly as the standard UNIX file /etc/hosts, i.e.
the entry' syntax is "x.y.z.t hostname hostname ..."
[Note: only pure hostnames, without the domain part]

You can edit this file now, or in a second stage. If you answer "n" 
you can edit this file later, re-running this utility with "setup named".

END

prompt edit "y" "Do you wish to edit now the internal DB (y/n)?"
[ $edit = n ] && echo "Excellent!" && sleep 1 && return 1

vi /etc/named/named-hosts
return 0
}

test()
{
echo "-- DNS answer for this domain ------------------------------"
echo "ls $DOMAIN" | nslookup -timeout=2 - 
echo "-----------------------------------------------------------"
}

# ping the DNS with netcat

dns_ping()
{
local host=$1
nc -zu -w 2 $host 53 
return $?
}

resolv_up()
{
add_entry file=/etc/resolv.conf \
        key=127.0.0.1 top table="nameserver,127.0.0.1"
add_entry file=/etc/resolv.conf \
        key=domain top table="domain,$DOMAIN"
add_entry file=/etc/resolv.conf \
        key=search top table="search,$DOMAIN"

}

resolv_down()
{
add_entry file=/etc/resolv.conf \
        key=127.0.0.1 top table="#nameserver,127.0.0.1"
}

configure()
{
restore
tell "named: working in the %s mode." | printf -r "$MODE"
create_primary
create_zone
create_rev

case $MODE in
dynamic)
	echo -n "`tell Pinging` $NAMESERVER ..."
	if dns_ping $NAMESERVER; then
		tell "answer got, forward enabled."
		create_forwarder y 
		create_options query-log
	else
		tell "do not responds, forward disabled."
		create_forwarder n 
		create_options
	fi
	;; 
stand-alone)
	create_forwarder n
	create_options
	;;
forward-only)
	create_forwarder y
	create_options query-log forward-only
	;;
*)
	tell "error" ; exit 1
esac

if [ "`pidof named`" ] ; then
	kill -1 `pidof named` && \
	tell "named: server restarted"
else
	named
fi

# put the right entry in /etc/resolv.conf
resolv_up
}
