#--------------------------
#  MUTT configuration 
#--------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to configure Mail User Agent Mutt"
VAR_LIST="ORGANIZATION PREFERRED_EDITOR ATTRIBUTION SORT_METHOD ALWAYS_SIGN ALWAYS_ENCRYPT"
HIDDEN_LIST=""
MOD_LIST=""
ORGANIZATION='Rustic Software Foundation'
PREFERRED_EDITOR='e3pi'
ATTRIBUTION='On %d, %n wrote:'
SORT_METHOD='date'
ALWAYS_SIGN='unset'
ALWAYS_ENCRYPT='unset'
}

info()
{

tell <<END
		        - Mutt Mail User Agent -

Mutt is a small but very powerful text based program for
reading electronic mail under UNIX operating systems,
including support for color terminals, MIME and a threaded
sorting mode.

Mutt support also mail retrieving from a POP3 host:
please, use the "G" key in the main panel. A complete set of
macros for public-key RSA encryption using PGP is also
provided. Please, use the "k" key on the various Mutt panels. 

END

}

requirement()
{
if [ "`which mutt`" ]; then
	return 0
else
	echo "(WKS addon required)"
	return 1
fi
}

sanitize()
{
> /etc/mutt/pop3
save -n $1 ask_the_user
}


pgp_setup()
{
echo -e "${BRIGHT} `tell PGP options in Mutt` ${NORMAL}"
prompt ALWAYS_SIGN "$ALWAYS_SIGN" \
"Always PGP-sign your outgoing messages (set/unset)?"
prompt ALWAYS_ENCRYPT "$ALWAYS_ENCRYPT" \
"Always PGP-encrypt your outgoing messages (set/unset)?"

}


prepare()
{
resource=$1
echo
tell "- Preferred Editor for your editing -"
. /setup/lib/editors
echo
while [ 1 ]; do
prompt  PREFERRED_EDITOR "$PREFERRED_EDITOR"

([ -x "$PREFERRED_EDITOR" ] || [ "`which $PREFERRED_EDITOR`" ]) && break 
echo "please, retry."
done
echo "`tell Well, I will use` $PREFERRED_EDITOR."

prompt ORGANIZATION "$ORGANIZATION"
prompt ATTRIBUTION "$ATTRIBUTION"

tell <<END

	This specifies how to sort messages in the [index] menu.
	Valid values are:
	date,date-sent,date-received,from,to,size and threads

END

prompt SORT_METHOD "$SORT_METHOD"

pgp_setup

# warn the user: its mutt setup will take place!

if [ $HOME/.muttrc ] ; then
echo -e "$BRIGHT"
tell <<END
Warning! Alert!
You have a own .muttrc stored in your home directory: current questions
about Mutt setup concern only to centralized setup in /etc/mutt.
Please, remove the file ".muttrc" and, under Mutt, use the macro ALT-c,
and your .muttrc will reflects the current settings.
END
echo -e "$NORMAL"
fi
save -n $resource config
}

status()
{
	echo up
}


mutt_setup()
{
#-------------------------
# create /etc/mutt/custom
#-------------------------
save=$IFS
IFS="@"
set -- $EMAIL
visible_hostname=$2
IFS=$save
echo ${visible_hostname} > /etc/mailname

editor=`which $PREFERRED_EDITOR`
editor=${editor:-/usr/bin/vi}

cat > /etc/mutt/custom <<END
#/etc/mutt.conf for muLinux
# DO NOT EDIT! automatically generated
# `date`

set editor="$editor"
my_hdr From: $FULL_NAME <$EMAIL>
my_hdr Organization: $ORGANIZATION 

set signature="~/.signature"
set attribution="$ATTRIBUTION"
set move=ask-no
set mbox=~/Mail/historic
set mbox_type=mbox

set sort = $SORT_METHOD 
set sort_aux = date-sent

END

#-------------------------
# create /etc/mutt/pop3
#-------------------------

if [ "$REMOVE_MESSAGES" = y ] ; then
        op="set"
else
        op="unset"
fi

cat > /etc/mutt/pop3 <<END
#/etc/mutt/pop3 for muLinux
# DO NOT EDIT - automatically generated
# `date`
# POP3 support

$op pop_delete
set pop_host="$HOST"
set pop_port="$POP_PORT"
set pop_user="$USER"
set pop_pass="$PASSWORD"

END

#-------------------------
# create /etc/mutt/pgp
#-------------------------

cat > /etc/mutt/pgp <<END
#/etc/mutt/pgp for muLinux
#`date`
set pgp_replyencrypt
set pgp_replysign
set pgp_verify_sig=yes

${ALWAYS_ENCRYPT} pgp_autoencrypt
${ALWAYS_SIGN} pgp_autosign

END

# create the personal $HOME/Mail dir

case "Z$HOME" in
Z/root|Z/home*)
	mkdir -p $HOME/Mail
	;;
*)	
	mkdir -p /root/Mail
	;;
esac

}


check_pop3()
{
status=$(include pop3; echo $ACTION)
[ "$status" = configure ] && return 0
return 1
}

check_sendmail()
{
status=$(include sendmail; echo $ACTION)
[ "$status" = configure ] && return 0
return 1
}

abort_with()
{
tell "[%s] support is not configured. Do setup -f %s and retry." |\
	printf -r $1 $1
exit 1
}


configure()
{

check_pop3 || abort_with pop3 
check_sendmail || abort_with sendmail 

(
include pop3
include sendmail
mutt_setup
)
}
