#-------------------------
# Configurazione MISC
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="some miscellaneous settings"
VAR_LIST="MY_BOOKMARKS LISTING LYNX_LISTING SIGNATURE SHELL_HISTORY PUSH_POP TIMEZONE EDITOR HAS_COLOR"
HIDDEN_LIST=""
MOD_LIST=""
MY_BOOKMARKS='/startup/init/bookmarks.html'
LISTING='multi-column'
LYNX_LISTING='short'
SIGNATURE='Parva saepe scintilla magnum excitat incendium -- Curzio Rufo'
SHELL_HISTORY='y'
PUSH_POP='y'
TIMEZONE='+0'
EDITOR='elvis'
HAS_COLOR='TRUE'
}

info()
{
cat <<END

  	 		- Miscellaneous settings -

Some global settings, common to whole muLinux setup. NOT required.
You can select your default text-editor here

END
}

prepare()
{
resource=$1

prompt MY_BOOKMARKS $MY_BOOKMARKS 

cat <<END

This is for UNIX ls listing format:
	"normal", "colored", "multi-column" 

END
prompt LISTING $LISTING 

cat <<END

This is for LYNX file-manager listing format:
        	"short", "long"

END
prompt LYNX_LISTING $LYNX_LISTING 


cat <<END

This provides an history mechanism analog to bash,
but with some problem with CONTROL-C interrupt.

END

prompt SHELL_HISTORY $SHELL_HISTORY "Do you want a SHELL_HISTORY (y/n)?"

cat <<END

Support for pushd(), popd(), and dirs() commands for Bourne-like
shells without built-in versions, by Ed. Hynan <ehy@delphi.com>. 
With this command (which are 'cd' replacement) you can keep 
track of your location in the filesystem tree.

	Usage:		push /new/dir, pushd ...
			popd, popd, ...

END

prompt PUSH_POP $PUSH_POP "Do you want push/pop support in the shell (y/n)?"


echo 0 >/etc/time.conf
echo
echo "Your hardware (CMOS) time is:" 
echo
echo -e "\t\t\t $BRIGHT$CYAN `date` $NORMAL"
cat <<END

TIMEZONE value ( ex:  "-1" or "+0" ) set a fixed displacement 
for the system time ("date" command).

END
prompt TIMEZONE "$TIMEZONE"

cat <<END

This is your signature. See /etc/signature for manual tuning.

END
prompt SIGNATURE "$SIGNATURE"


# default editor
. /setup/lib/editors
echo
prompt EDITOR "$EDITOR"

# wm
cat <<END

If You plan to run XWindow, You can set a default "Window Manager".

		Available WM: fvwm95, afterstep, wm2.

Any way, you can select a WM a run-time, with "startx wm".

END

prompt HAS_COLOR $HAS_COLOR "This terminal support colors (TRUE/FALSE)?" 

save -n $resource configure
}

store()
{
echo "Storing /etc/signature ... "
if [ -r /etc/signature ] ; then
	cp /etc/signature /setup/cnf/store
fi
}



configure()
{
#set -x

for m in ${MOD_LIST}
do
load_module $m
done

# bookmarks

if [ "${MY_BOOKMARKS}" ]; then
	rm -f /etc/bookmarks.html 
        ln -s ${MY_BOOKMARKS} /etc/bookmarks.html
fi


# ls alias

case $LISTING in
normal)		echo "" > /etc/ls.conf ;;
colored)	echo "-s --color=tty" > /etc/ls.conf ;;
multi-column)	echo "-F" > /etc/ls.conf;;
esac


# timezone

echo "$TIMEZONE" > /etc/time.conf

# signature

if [ ! -r /etc/signature ] ; then
echo -e "$SIGNATURE" > /etc/signature
fi

if [  -r /setup/cnf/store/signature ] ; then
cp /setup/cnf/store/signature  /etc/signature
fi


# lynx listing

case ${LYNX_LISTING} in
short)
	cat /etc/lynx.cfg |\
	sed "s/^LIST_FORMAT:.*/LIST_FORMAT: %7s %-12.12d %a/g" >/tmp/lynx.cfg
	;;
long)
	cat /etc/lynx.cfg |\
	sed "s/^LIST_FORMAT:.*/LIST_FORMAT: %p %4l %-8.8o %-8.8g %7s %-12.12d %a/g" >/tmp/lynx.cfg
	;;
esac

cp /tmp/lynx.cfg /etc/lynx.cfg
rm -f /tmp/lynx.cfg	

# shell prompt

echo "$SHELL_PROMPT" > /etc/prompt.conf

# shell history

if [ "$SHELL_HISTORY" = y ] ; then
	> /etc/history.conf
else
	rm -f /etc/history.conf
fi

# push/pop in the shell 

if [ "$PUSH_POP" = y ] ; then
        > /etc/push_pop.conf
else
        rm -f /etc/push_pop.conf
fi


# colors support
echo "$HAS_COLOR" > /etc/colors.conf
export HAS_COLOR=$HAS_COLOR

}
