#-------------------------
# Config.  lpd 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="an lpd-like print server support"
VAR_LIST="LPD_NETWORK METHOD PRINT_CMD SLEEP_TIME ACOUSTIC_LOG_QUEUED ACOUSTIC_LOG_PRINTED"
HIDDEN_LIST="PORT"
MOD_LIST=""
LPD_NETWORK='192.168.1.0'
METHOD='spooler'
PRINT_CMD='/usr/lpr/loc/lpr'
SLEEP_TIME='2'
ACOUSTIC_LOG_QUEUED='wave -c 880 1; wave -c 440 2'
ACOUSTIC_LOG_PRINTED='wave -c 220 4'
# hidden
PORT='515'
}

info()
{
cat <<END

  	 	  -  the Rustic UNIX Printer server -

This is a Non Spooling compatible LPD server, contributed by 
Steve Flynn (smflynn@ozemail.com.au): a little C program which
understand the traditional BSD printer protocol (RFC1179).

Spooler capabilities are implemented by me in usual way,
i.e.  with rustic scripts.

Enabling this setup, this host may act as a simple Print Server 
or Print Sharer for UNIX machines, for WinNT ( using "Microsoft
TCP/IP Printing" driver) or for Windows 95/98 (using a FREE program, 
called ACITS LPR )

    - Alert! Enable "setup printer", for the attached printer
    - Logs in /var/log/lpd.log.

END
}

status()
{
if [ "`pidof lpdsrv`" ] ; then
	echo up
else
	echo down
fi

}



prepare()
{
resource=$1

prompt LPD_NETWORK "${LPD_NETWORK}" "Enter network for job acceptance"

cat << END
	
	muLinux support two method:
	
	direct	- send the RAW file directly to /dev/lp port
	spooler - queue the job, filtering with local printer setup

END

prompt METHOD "$METHOD"

if [ $METHOD = spooler ] ; then
prompt PRINT_CMD "${PRINT_CMD}" "Enter PRINT_CMD or \"\" "
prompt SLEEP_TIME ${SLEEP_TIME}

cat <<END

	At the job entry and at the job printing, muLinux can
	execute two different commands (a little sound as default).
	Disable this feature putting "".	

END

prompt ACOUSTIC_LOG_QUEUED "$ACOUSTIC_LOG_QUEUED"
prompt ACOUSTIC_LOG_PRINTED "$ACOUSTIC_LOG_PRINTED"
fi
 
save -n $resource configure
}

stop()
{
stop-daemon lpdsrv lpd.spooler lpd.queuer
}

configure()
{
#set -x
	mkdir -p /var/spool/printer 
	output="/dev/lp"

	if [ $METHOD = spooler ] ; then
	 /usr/lpr/lpd/lpd.queuer &
	/usr/lpr/lpd/lpd.spooler &
	output=/var/spool/printer/job
	fi

	# restart
	/usr/lpr/lpd/lpdsrv -n ${LPD_NETWORK} -p ${PORT} \
	-o ${output} 2>/var/log/lpd.log &

	echo "lpd (rustic) daemons started." 
}
