#-------------------------
# Config keymap 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="National Language support"
VAR_LIST="LANG MAP CODEPAGES CONSOLE_FONTS"
HIDDEN_LIST=""
MOD_LIST=" fs/nls_cp850"
MAP='it'
CODEPAGES='850'
CONSOLE_FONTS="default"
LANG="en"
}

info()
{
tell <<END
		    - National Language support -

Now you will be asked for keymaps, codepages, and national
language to be used in each dialog (EXPERIMENTAL).
Please, look in the directory /etc/lang in order to know the
author's name of each translation.

If you want, you can add any new key redefinitions (compositions,
new Fx functions, etc) by hand, using the file /etc/keys.conf.

If available in the system, console fonts support is provided.

NOTES:
	-- Multilanguage is available via WKS add-on. Without 
           this disk, muLinux still speak fractured english. 

END
}

prepare()
{
res=$1


tell "Available language support: "
echo
echo "--------------------------------------"
cat /etc/lang/availables 2>/dev/null
echo "--------------------------------------"
echo

prompt LANG $LANG "Select preferred language" 

tell "Please select one of the following keyboard maps:"
echo
/bin/ls /usr/lib/kbd/keytables 
echo
prompt MAP "$MAP"
tell "Please select a list of codepages:"
echo
cat <<END
437 (US, Canada)
850 (Europe)
END
echo
prompt CODEPAGES "$CODEPAGES"

if [ "`which setfont`" ] ; then
tell <<END

			== National font support ==

You can choice from this set of build-in rules:

		default, default8x16, default8x9
		slavic, cyrillic, greek, arabic

As alternative, if you know what you are doing, you can specify
the complete syntax for the Linux 'setfont' command.
Console fonts are in /usr/lib/kbd/consolefonts.

END
	prompt CONSOLE_FONTS "$CONSOLE_FONTS"
fi

save -n $res configure
}

store()
{
echo "Storing /etc/keys.conf ..."
if [ -r /etc/keys.conf ] ; then
	cp /etc/keys.conf /setup/cnf/store
fi

}



configure()
{

mkdir -p /etc/lang
ln -s -f /dev/null /etc/lang/en.db 2>/dev/null

if [ -f /etc/lang/$LANG.db ] || [ -L /etc/lang/$LANG.db ]; then
		tell -lang $LANG
else
	echo "Selected language [$LANG] not found: will use 'en'"
		tell -lang en	
fi


for c in ${CODEPAGES}
do
load_module "fs/nls_cp${c}" 
done

check loadkeys

loadkeys ${MAP}

if [ -r /setup/cnf/store/keys.conf ] ; then
	cp /setup/cnf/store/keys.conf /etc/keys.conf
	cat /etc/keys.conf| loadkeys
fi

if [ "$(which setfont)" ] && [ "$CONSOLE_FONTS" ]; then
case $CONSOLE_FONTS in
default)	setfont;;
cyrillic)	setfont koi8-8x16;;
slavic)		setfont koi8c-8x16;;
greek)		setfont 737.cp -16;;
arabic)		setfont 165.cp -16;;
*)
		setfont $CONSOLE_FONTS
esac
fi

}
