#-------------------------
# Config keymap 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="National Language support"
VAR_LIST="MAP CODEPAGES CONSOLE_FONTS"
HIDDEN_LIST=""
MOD_LIST=" fs/nls_cp850"
MAP='it'
CODEPAGES='850'
CONSOLE_FONTS="default"
}

info()
{
cat <<END
		    - National Language support -

Now you will be asked for  keymaps and codepages.
See muLinux documentation if you want to add unsupported 
national keymap.

If you want, you can add any new key redefinitions (compositions,
new Fx functions, etc) by hand, using the file /etc/keys.conf.

If available in the system, console fonts support is provided.

END
}

prepare()
{
res=$1

echo "Please select one of the following keyboard maps:"
echo
/bin/ls /usr/lib/kbd/keytables 
echo
prompt MAP "$MAP"
echo "Please select a list of codepages:"
echo
cat <<END
437 (US, Canada)
850 (Europe)
END
echo
prompt CODEPAGES "$CODEPAGES"

if [ "`which setfont`" ] ; then
cat <<END

			== National font support ==

You can choice from this set of build-in rules:

		default, default8x16, default8x9
		slavic, cyrillic, greek, arabic

As alternative, if you know what you are doing, you can specify
the complete syntax for the Linux 'setfont' command.
Console fonts are in /usr/lib/kbd/consolefonts.

END
	prompt CONSOLE_FONTS "$CONSOLE_FONTS"
fi

save -n $res configure
}

store()
{
echo "Storing /etc/keys.conf ..."
if [ -r /etc/keys.conf ] ; then
	cp /etc/keys.conf /setup/cnf/store
fi

}



configure()
{
for c in ${CODEPAGES}
do
load_module "fs/nls_cp${c}" 
done

check loadkeys

loadkeys ${MAP}

if [ -r /setup/cnf/store/keys.conf ] ; then
	cp /setup/cnf/store/keys.conf /etc/keys.conf
	cat /etc/keys.conf| loadkeys
fi

if [ "$(which setfont)" ] && [ "$CONSOLE_FONTS" ]; then
case $CONSOLE_FONTS in
default)	setfont;;
cyrillic)	setfont koi8-8x16;;
slavic)		setfont koi8c-8x16;;
greek)		setfont 737.cp -16;;
arabic)		setfont 165.cp -16;;
*)
		setfont $CONSOLE_FONTS
esac
fi

}
