#-------------------------
# Internet PPP connection 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="Internet PPP protocol support"
VAR_LIST="METHOD TELEPHONE INIT_STRING DIALING_MODE MODEM_DEVICE SPEED LOGIN PASSWORD LOGIN_PROMPT PASSWORD_PROMPT FINAL_EXPECT_SEND_PAIR IP DEFAULTROUTE OTHER_OPTIONS PPP_LINK NAMESERVER"
HIDDEN_LIST=""
MOD_LIST="net/slhc net/ppp"
METHOD='pap'
TELEPHONE='0587270012'
INIT_STRING='ATL1'
DIALING_MODE='tone'
MODEM_DEVICE='/dev/ttyS1'
SPEED='115200'
LOGIN='craxi'
PASSWORD='bettino'
LOGIN_PROMPT='ogin%--ogin%'
PASSWORD_PROMPT='ssword%'
FINAL_EXPECT_SEND_PAIR=''
IP='noipdefault'
DEFAULTROUTE='y'
OTHER_OPTIONS='proxyarp'
PPP_LINK='down'
NAMESERVER='212.216.112.222'
}

info()
{

tell <<END

		   - PPP Internet Connections -

This is the muLinux PPP configuration utility.

PPP (the Point to Point Protocol) is a mechanism for creating 
and running IP  (the Internet Protocol) and other network protocols 
over a link made using modems and telephone lines. 

 -- See PPP-HOWTO
 -- Link enable/disable with: ppp-on/ppp-off

END

}

sanitize()
{
LOGIN=craxi
PASSWORD=conto-protezione

> /etc/pap-secrets
> /etc/chap-secrets

save -n $1 ask_the_user
}


. /setup/lib/ppp

stop()
{
pid=`pppd_pid $MODEM_DEVICE`
[ "$pid" ] && kill -1 $pid && kill -9 $pid
stop-daemon chat >/dev/null
}

# the device_status() function is in ppp.lib

status()
{
device_status $MODEM_DEVICE
}


prepare()
{

resource=$1

prompt MODEM_DEVICE "$MODEM_DEVICE" "Enter serial device"
prompt SPEED "$SPEED" "Enter serial speed (19200,38400,115200,...)"


ISP_config()
{
tell << END

Please select the authentication method for your connection.
PAP is the method most often used in WIN95, so try PAP first.

	 PAP 	Password Auth. Protocol
	 CHAT	Traditional chat login/passwd auth.
	 CHAP	Challenge Handshake Auth. Protocol

END

prompt METHOD "$METHOD" "Enter method"
prompt TELEPHONE "$TELEPHONE" "Enter telephone number"
prompt DIALING_MODE "$DIALING_MODE" "Enter dialing mode"
prompt INIT_STRING "$INIT_STRING" "Additional modem initialization"
prompt LOGIN "$LOGIN" "Enter your username"
prompt PASSWORD "$PASSWORD" "Enter your password"
IP=noipdefault
prompt IP "$IP" \
"Enter IP local_ip:remote_ip or 'noipdefault'"
prompt OTHER_OPTIONS "$OTHER_OPTIONS" "[expert] Other options"

tell <<END

	Do you wish to setup the PPP link as your "defaultroute"
	(any unresolved packet is forwarded using your peer
	as gateway)? Select "yes" if this link is your only
	gate to outside.

END

prompt DEFAULTROUTE "y" "Set defaultroute (y/n)"

tell <<END

        Internet address (in dot notation) of a name server
        that should query for host name resolution.
        Enter ""  if You don't want a DNS.

END

prompt NAMESERVER "${NAMESERVER}"


case "$METHOD" in
*pap*|*PAP*)
;;
*chap*|*CHAP*)
;; 
*chat*|*CHAT*)

prompt LOGIN_PROMPT "$LOGIN_PROMPT" "Enter ISP login prompt"
prompt PASSWORD_PROMPT "$PASSWORD_PROMPT" "Enter ISP password prompt"

sleep 1
tell << EOF

Enter any addictional input your ISP requires.  This may be a program name 
like 'ppp' as a response to a menu prompt. If you need to make an entry, 
make the first entry the prompt you expect and the second the 
required response. Example:

If the ISP prompt is "regina-coeli%" and your ISP require a string
like "ppp" to enter in PPP-MODE, enter this PAIR:                         

		regina-coeli% ppp                                           
                                                                                
Otherwise, leave blank. 

EOF

prompt FINAL_EXPECT_SEND_PAIR "$FINAL_EXPECT_SEND_PAIR" \
"Enter final expect-send-pair"

;;
esac
}

# MAIN

while [ 1 ]; do

ISP_config
echo
prompt PPP_LINK "$PPP_LINK" "Start PPP now (up/down)?"
AreYouHappy && break
done

save -n $resource configure
}

configure()
{

supported device ttyS 
if [ $? -ne 0 ] ; then
	setup -f port
fi

for m in ${MOD_LIST}
do
load_module ${m} 2>/dev/null 
done

case "$DIALING_MODE" in
pulse) ATDT=ATDP;;
tone)  ATDT=ATDT;;
esac	

# Create /etc/ppp/chatscript

echo "/usr/bin/chat -f /etc/ppp/chat-ppp0" > /etc/ppp/chatscript 

# Create /etc/ppp/chat-ppp0 base

cat <<END > /etc/ppp/chat-ppp0
ABORT	BUSY
ABORT	ERROR
ABORT	VOICE
ABORT	'NO DIALTONE'
ABORT	'NO ANSWER'
''       'ATZ'
OK     	${INIT_STRING} 
OK       ${ATDT}${TELEPHONE}
CONNECT  \\d\\c 
END

# Create /etc/ppp/options base

case $DEFAULTROUTE in
yes|y) DR="defaultroute";;
no|n)  DR="-defaultroute";;
esac


cat > /etc/ppp/options <<END
modem crtscts
$MODEM_DEVICE ${SPEED}
lock 
connect /etc/ppp/chatscript
debug
$IP
$DR
$OTHER_OPTIONS
END

# authentication type 

case "$METHOD" in
*pap*|*PAP*)

echo "user ${LOGIN}" >> /etc/ppp/options

cat <<END > /etc/ppp/pap-secrets
${LOGIN}	*	${PASSWORD}
END

;;
*chap*|*CHAP*)
                                                                 
echo "user ${LOGIN}" >> /etc/ppp/options                                       
cat > /etc/ppp/chap-secrets <<END
${LOGIN}        *       ${PASSWORD}
END
;; 

*chat*|*CHAT*)

cat <<END >> /etc/ppp/chat-ppp0
${LOGIN_PROMPT}	\\d\\q${LOGIN} 
${PASSWORD_PROMPT} \\q${PASSWORD} 
${FINAL_EXPECT_SEND_PAIR}
END

;;
esac

# DNS settings

if [ "${NAMESERVER}" ] ; then
add_entry file=/etc/resolv.conf key=$NAMESERVER table="nameserver,$NAMESERVER"
#echo "search" > /etc/resolv.conf
#echo "nameserver ${NAMESERVER}" >>/etc/resolv.conf
fi

# start ppp?

if [ "$PPP_LINK" = up ] ; then
	tell "Hope your modem is on!"
	pppd	
else
	stop
fi

}

