#-------------------------
# isapnp configuration 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to configure PNP boards"
VAR_LIST="PNP_SCHEME"
HIDDEN_LIST=""
MOD_LIST=""
PNP_SCHEME='extensa'
}

info()
{
cat <<END
			- ISA pnp card setup -

Configure ISA Plug-and-Play devices, for example: sound subsystem
in some laptop.

muLinux setup use a "scheme" concept. You have to edit a own file

	        	/etc/isapnp/SCHEME.conf

Standard muLinux only support a so called "extensa" scheme.

END
}



requirement()
{
if [ "`which isapnp`" ]; then
	return 0
else
	echo "(SRV addon required)"
	return 1
fi
}

store()
{
f=/etc/isapnp/$PNP_SCHEME.conf
if [ -r "$f" ] ; then
echo "Storing $f ..."
cp $f /setup/cnf/store
fi
}


configure()
{
if [ -f /setup/cnf/store/$PNP_SCHEME.conf ]; then
	cp /setup/cnf/store/$PNP_SCHEME.conf /etc/isapnp
fi
isapnp /etc/isapnp/$PNP_SCHEME.conf >/dev/null
}
