#--------------------------
# ipfwadm policy 
#--------------------------

default()
{
ACTION=ask_the_user
RESOURCE="ipfwadm (forwarding, masquerading, firewall) support"
VAR_LIST=""
HIDDEN_LIST=""
MOD_LIST=""
}

info()
{
cat <<END
	   - FORWARDING, MASQUERANDING & FIREWALL policy -

______________________________
 __|__                  ___|___
|     | local network  |       |   ______  PPP-link to provider
| PC  |  192.168.1.0   | Linux |--|modem |------------------>
|     |                | Router|  |______|      x.x.x.x
|_____|                |_______|          (dynamic IP-address)
                         pppd

IP filtering firewall is designed to control the flow of packets
based the source, destination, port and packet type. This setup 
enable IP masquerade feature and IP generic protection
on a Linux server, allowing connected computers (running TCP/IP, 
but without registered Internet address) to connect to the Internet 
through your Linux box.

See IP-Masquerade and IP-Firewall mini Howto for more details.

	-- In recent MuLinux releases, forwarding and masquerading
	   is automatic

END
}

status()
{
rules=`ipfwadm -F -l | rgrep -v "IP firewall"`

if [ -z "$rules" ] ; then
	echo down
else
	echo up
fi

}

store()
{
cd /etc/ipfw || return 1
if [ "`/bin/ls`" ] ; then
echo "Storing IP-filtering rules (/etc/ipfw) ... "
tar -cf /setup/cnf/store/ipfw.tar *
fi
}

restore()
{
a=/setup/cnf/store/ipfw.tar
if [ -f $a ] ; then
	mkdir -p /etc/ipfw
	cd /etc/ipfw
	rm -r m/* b/* 2>/dev/null
	tar -xf $a
fi 
}

stop()
{
echo "Stopping firewalling ..."
ipf stop
}

start()
{
stop >/dev/null
ipf start
}

prepare()
{
resource=$1
restore; start

echo
echo "Current filter rules actives:"
echo -e "$BRIGHT" 
ipfwadm -n -F -l
echo -e "$NORMAL" 

cat <<END

	muLinux configure IP-filtering using a front-end to ipfwadm 
	command  (/bin/ipfw). It allows you to setup masquerading or
	blocking rules between two distinct network addresses.

	All actives network destinations are numbered 1,2,3, ....
	(You will see all network/host active at *this* moment)
	The network number '0' mean ALL destinations.

	Ex 1: if you want masquerade the network 1 and you act as 
	Internet gateway to him, please specify 1-0.
	Ex 2: if you want block "telnet" connections from 1 to 3,
	please specify "1-3,23" or "1-3,telnet". 
	Ex 3: to block all forwading, specify 0-0.

END

prompt ans "y" "Would you like to activate this script? (y/n)"

if [ "$ans" = y ] ; then
	ipf configure
	store
fi

save -n $resource configure
}

configure()
{
[ -d /etc/ipfw ] || restore
ipf start
}
