#--------------------------------------
# Traditional Internet Daemons 
#--------------------------------------

default()
{
ACTION=ask_the_user
RESOURCE="a running inetd super-daemon"
VAR_LIST=""
HIDDEN_LIST=""
MOD_LIST=""
}

info()
{
tell <<END
		- Traditional Internet Services -

This setup start the "inetd" daemon, the Internet Super-server.
A lot of traditional UNIX services, managed via /etc/inetd.conf,
will becomes active. They are:

		 in.telnetd, in.ftpd, in.rshd, etc.

The fingerd (rustic) daemon is provided by Joshua Hudson.

	-- SRV addon required

END

}

requirement()
{
if [  "`which inetd`" ] ; then
	return 0
else
	echo "(SRV `tell addon required`)"
	return 1
fi
}

status()
{

if [ "`pidof inetd`" ] ; then
	echo up
else
	echo down
fi

}


store()
{
echo "Storing /etc/inetd.conf ..."
cp /etc/inetd.conf /setup/cnf/store
}

stop()
{
tell "Disabling Internet services ..."
stop-daemon inetd
}

# this is for anonymous ftp login

chroot_feature()
{
mkdir -p lib
mkdir -p bin
mkdir -p etc
chmod 111 lib bin

ln -f /lib/ld-linux.so.1 lib
ln -f /lib/libc.so.5.4.* lib/libc.so.5
ln -f /bin/ls bin
ln -f /etc/ld.so.cache etc
ln -f /etc/passwd etc
ln -f /etc/group etc
}

# fingerd server

fingerd_setup()
{
# create /etc/finger

(
echo "-------------------------------------"
echo "Fingerd daemon at [`hostname`], Linux `uname -r`"
echo "-------------------------------------"
) > /etc/finger
}


# ftpd server

ftp_setup()
{

echo -n "`tell Setting up Washington University FTP server`: "

mkdir -p /home/ftp 
chmod 5555 /home/ftp 
chown ftp.ftp /home/ftp

cd /home/ftp

# enable anonymous ONLY if in HD
if [ -z "`df / | rgrep ram`" ] ; then
	tell "Anonymous FTP login enabled."
	chroot_feature
else
	tell "Anonymous FTP login disabled."
fi

mkdir -p pub 
mkdir -p pub/incoming 
chmod 777 pub pub/incoming

cd /home/ftp/pub
(
cat <<END
`uname` FTP server, host `hostname`.
`tell This is the public area`.
`tell Today` `date`.
`cal`
-muLinux
END
) | unix2dos > welcome.txt
}


configure()
{

# restore inetd.conf

if [ -f /setup/cnf/store/inetd.conf ] ; then
	echo "Restoring /etc/inetd.conf ..."
	cp /setup/cnf/store/inetd.conf /etc
fi


# start inetd

pid=`pidof inetd`
if [ "$pid" ] ; then
	tell "Restart inetd ..."
	kill -1 $pid
else
	if [ "`which inetd`" ]; then
	tell "Starting inetd super-daemon ..."
	inetd
	fi
fi


# disable fake telnetd

tell "Substituting fake telnetd daemon with real one ..."

repl="$repl; s/^T\([0-9]\)/#T\1/g"
cat /etc/inittab | sed "$repl" > /tmp/inittab
cp /tmp/inittab  /etc/inittab
rm /tmp/inittab
#init q

# anonymous ftp setting

ftp_setup
load_module ipv4/ip_masq_ftp 2>/dev/null

# fingerd setup

fingerd_setup

# test

#nmap localhost | sed "s/^/    /g"

sleep 1
}
