#-------------------------
#  httpd 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="a running httpd web server"
VAR_LIST="REMOTE_CONTROL_PANEL AUTH BANNED_NETWORK"
HIDDEN_LIST="W3_PORT RCP_PORT"
MOD_LIST=""
REMOTE_CONTROL_PANEL='y'
W3_PORT='80'
RCP_PORT='81'
AUTH=y
}

info()
{
tell <<END
		    - Internal Web Server -

Depending of what addons are mounted, muLinux support
some httpd daemon, running on port 80:

	- Pygmy: the rustic script-based web-server
	- thttpd: the fast web-server, developed by Jef Poskanzer


END
}

requirement()
{
        return 0
}

status()
{
if nc -z localhost 80 
then
	echo up
else
	echo down
fi
}

get_pids()
{
pidof thttpd
ps | rgrep pygmy |
while read pid rest
do
echo $pid
done
}

stop()
{
echo -n "`tell Shutting down web-server`: "
PID=`get_pids`

kill -9 $PID 2>/dev/null
kill -9 `pidof pygmy` 2>/dev/null

if  [ "$PID" ] ; then 
	echo $PID
else
	tell "not running."
fi
ipfwadm -I -a accept 
}

get_instdir()
{
bd=`dirname $(which thttpd)`
dirname $bd
}

get_logfile()
{
if df / | rgrep ram > /dev/null
then
	echo "/dev/null"
else
case $1 in
public)
	echo "/var/log/thttpd.log";;
rcp)
	echo "/var/log/rcp.log";;
esac
fi
}


start_public_www()
{
        echo -n "`tell Starting public thttpd web-server on port` $W3_PORT ..."
        thttpd -l `get_logfile public` -d `get_instdir`/thttpd \
         -c '*.cgi' -p $W3_PORT 
        sleep 1; tell " done."
}

start_rcp()
{
        echo -n "`tell Starting RemoteControlPanel on port` $RCP_PORT ..."
        thttpd -l `get_logfile rcp` -d `get_instdir`/thttpd/murcp \
         -c 'cgi-bin/*' -p $RCP_PORT -u root 
        sleep 1 ; tell " done."
}

admin_password()
{
PW=/usr/srv/thttpd/murcp/cgi-bin/.htpasswd
while [ 1 ] ; do
htpasswd -c $PW admin && return
done
}


prepare()
{
resource=$1

if [ "`which thttpd`" ] ; then

#tell <<END| printf -r $RCP_PORT "`fqn`" $RCP_PORT
(
tell <<END
		
	REMOTE_CONTROL_PANEL RCP is a CGI front-end to muLinux Setup.
	It can accept request on the port %s. Using RCP and
	a browser, you can configure muLinux remotely, pointing the
	browser to this URL:

			http://%s:%s/

END
) | printf -r $RCP_PORT "`fqn`" $RCP_PORT


	prompt REMOTE_CONTROL_PANEL $REMOTE_CONTROL_PANEL "Start RCP (y/n)"
fi

# RCP authentication 

if [ "$REMOTE_CONTROL_PANEL" = y ] ; then
	prompt AUTH $AUTH "Authentication is required for RCP? (y/n)"
fi	 

if [ "$AUTH" = y ] ; then
	admin_password
fi


# banned network

tell <<END

	I can block the access to my internal Web services to some
	specific ipaddr/netmask. Please, specify a list in the form

			ip/mask	ip/mask .... 

	or put blank '' in this field.
	Examples:  192.168.2.1/24, 0/0  .... 

END

prompt BANNED_NETWORK "$BANNED_NETWORK"


# finish
save -n $resource configure
}

# check if loopback networking is up (thttpd crash, if doesn't)

check_loopback()
{
(ifconfig | rgrep lo > /dev/null) || ifconfig lo 127.0.0.1 up
(route -n | rgrep lo > /dev/null) || route add -net 127.0.0.0 lo 
}

ban_network()
{
local port=$1
[ "$BANNED_NETWORK" ] || return 1
echo "Banning $BANNED_NETWORK from $port/tcp..."
for x in $BANNED_NETWORK; do
ipfwadm -I -f
done
}

configure()
{

# search for thttpd

check_loopback
if [ "`which thttpd`" ] ; then
	start_public_www
	[ $REMOTE_CONTROL_PANEL = y ] && start_rcp
else
        pygmy >/dev/null &
        echo -n "`tell Starting PYGMY, the (rustic) web-server` ..."
	echo " (pid `pidof pygmy`)"
fi
ban_network 80
ban_network 81
# remove .htpasswd if AUTH=n

case $AUTH in
n|N)
	PW=/usr/srv/thttpd/murcp/cgi-bin/.htpasswd
	if [ -f $PW ] ; then 
	echo "`tell RCP authentication disabled`."
	rm -f $PW 
	fi
	;;
esac
}
