#-------------------------
# serial/parallel/mouse port 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="a running gpm mouse server"
VAR_LIST="GPM_PROTOCOL GPM_RESPONSIVENESS GPM_OPTIONS"
HIDDEN_LIST=""
MOD_LIST=""
GPM_PROTOCOL='ps2'
GPM_RESPONSIVENESS='10'
GPM_OPTIONS=''
}

info()
{

tell <<END
		       - gpm mouse server -

gpm is a cut and paste utility and mouse server for
virtual consoles. Kill the server with "gpm -k", or "setup gpm stop"

  -- NOTE: gpm setup depend of port's setup

END
}

status()
{
if [ "`pidof gpm`" ] ; then
	echo up
else
	echo down
fi

}


requirement()
{
[ "`which gpm`" ] && return 0 
echo "(SRV `tell addon required`)" 
return 1
}

stop()
{
stop-daemon gpm
gpm -k 2>/dev/null
}


prepare()
{
resource=$1

# include port's config
MOUSE_PROTOCOL=$(include port; echo $MOUSE_PROTOCOL)

echo "`tell Mouse protocol is`: $MOUSE_PROTOCOL"
case $MOUSE_PROTOCOL in
Microsoft) GPM_PROTOCOL=ms;;
*PS*) GPM_PROTOCOL=ps2;;
*Logi*) GPM_PROTOCOL=logi;;
*Mousman*) GPM_PROTOCOL=mman;;
esac

prompt GPM_PROTOCOL "${GPM_PROTOCOL}" 

tell <<END

	Set  the responsiveness. A higher responsiveness is
	used for a faster cursor motion.

END
prompt GPM_RESPONSIVENESS "${GPM_RESPONSIVENESS}" 
prompt GPM_OPTIONS "${GPM_OPTIONS}" 

save -n $resource configure
}



configure()
{
start_gpm="gpm -m /dev/mouse \
-t $GPM_PROTOCOL -r ${GPM_RESPONSIVENESS} ${GPM_OPTIONS}"
echo "Starting gpm server: ${start_gpm}"
gpm -k 2>/dev/null
eval ${start_gpm} > /dev/null
}
