#-------------------------
# Config. fax
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="fax support"
VAR_LIST="DEVICE CLASS CAPABILITY VERBOSITY RINGS ADAPTATIVE INIT"
HIDDEN_LIST=""
MOD_LIST=""
DEVICE='/dev/modem'
CLASS='1'
CAPABILITY='5'
VERBOSITY='high'
RINGS='2'
ADAPTATIVE='n'
INIT=''
}

info()
{

cat <<END

		             - FAX system  -

This is the muLinux fax support, based on EFAX (C) Ed. Casas and
test by myself with USR Sporster 33.6 modems.
 
You can to postpone this setup answering "n" now and issuing a
"setup -f fax" later but, sorry: no email support for problems
with your modem :)

The "/usr/bin/fax" script provide an user-friendly front-end
to muLinux fax system. See also "help fax". 

 - Log file is /var/log/fax.log.

END

}

stop()
{
stop-daemon efax
}

prepare()
{

resource=$1

while [ 1 ] ; do
#------------------------
echo
prompt DEVICE $DEVICE "Device to which modem is connected"
prompt CLASS $CLASS "Class of your modem (1/2/2.0)"
prompt CAPABILITY $CAPABILITY "Fax capabilies (3/5)"
prompt VERBOSITY $VERBOSITY "Verbosity (low/medium/high)"
prompt RINGS $RINGS "Number of rings to wait before answering"
prompt INIT "$INIT" 

cat << END

	Many modems have an adaptative data/fax mode. If a data
	call is detected, the agetty program will be run on the
	port. USR modems do not support this feature in Class 1. 

	Note: the adapative answer  will not work for all callers.
	For data-caller, use DIALIN_SERVER, if you have problem.
	
	THIS FEATURE INTERFER WITH OUTGOING CALL - do not use.

END

prompt ADAPTATIVE $ADAPTATIVE "Do you want adaptative answer(y/n)?"



#------------------------
echo
prompt correct "n" "Are you happy with this configuration (y/n)?"
[ "$correct" = y ]  && break
done
save -n $resource configure
echo "Done."

}

configure()
{

[ -z "$INIT" ] && INIT='-iZ -i&F1&D2S7=120 -i&C0 -iL1M1'

# class 

case $CLASS in
        2.0)    CLASS_OPT="-o0" ;;     # Class 2.0
        2)      CLASS_OPT=""  ;;     # Class 2
        1)      CLASS_OPT="-o1"  ;;     # Class 1
        *)      CLASS_OPT="" ;;
esac

# log level 
case $VERBOSITY in
        low)  	VERB_OPT="-vew";; 
        medium)	VERB_OPT="-vewin";;     
        high)   VERB_OPT="-vewchinrxtf" ;; 
        *)      VERB_OPT="" ;;
esac

# adaptative answer

case $CLASS in
        2.0)  	DATAINIT="-j&C1 -j+FAA=1";;  
        1)  	DATAINIT="-j&C1 -j+FCLASS=0 -oa";;  
        2)  	DATAINIT="-j&C1 -j+FAA=0 -j+FCLASS=0 -oa";;  
        *)    	DATAINIT=;; 
esac

DEV=`basename $DEVICE`

if [ "$ADAPTATIVE" = y ] ; then
	ADAPT_OPT="$DATAINIT -g \"exec /bin/agetty -h \
-f /etc/issue.net $DEV %d\" "
else
	ADAPT_OPT=
fi


# Generic

FROM_OPT="-l $FROM"
RINGS_OPT="-jS0=$RINGS"
CAP_OPT="-c 1,$CAPABILITY,0,0,0,0,0,0"
LOCK_OPT="-x /var/lock/LCK..$DEV"
RESET_OPT="-kZ"

# Ok. This is the common part (TX/RX)

cat > /etc/fax.conf <<END
-d $DEVICE
$VERB_OPT
$INIT
$CLASS_OPT
$CAP_OPT
$LOCK_OPT
$RESET_OPT
$ADAPT_OPT
${RINGS_OPT}
END

}
