
#--------------------------------------
# Ethernet cards 
#--------------------------------------

if [ "$resource" = eth ] ; then
	tell "Called incorrectly: please use eth0, eth1"
	exit 1
fi

eth_n=$(echo $resource | sed s/eth//g)

default()
{
default_eth${eth_n}
}

default_eth()
{
#called incorrectly
}

default_eth0()
{
ACTION=ask_the_user
RESOURCE="to configure the first ethernet card"
VAR_LIST="CARD IRQ IO IP NETMASK DHCP MASQ"
HIDDEN_LIST=""
MOD_LIST=""
CARD='3c90x'
IRQ=''
IO=''
IP='192.168.1.1'
NETMASK='255.255.255.0'
DHCP='n'
MASQ='y'
}

default_eth1()
{
ACTION=ask_the_user
RESOURCE="to configure a second ethernet card"
VAR_LIST="CARD IRQ IO IP NETMASK DHCP MASQ"
HIDDEN_LIST=""
MOD_LIST=""
CARD='3c90x'
IRQ=''
IO=''
IP='192.168.2.1'
NETMASK='255.255.255.0'
DHCP='n'
MASQ='n'
}

info()
{
tell <<END | printf -r $eth_n
		- Ethernet card #%s Setup -

You can choice between two method ('pcmcia' or 'eth_card') and
you can use a DHCP server, if available. 

 -- PCMCIA support works only if SRV addon is mounted

END

}

requirement()
{
return 0
}


status()
{
ifconfig | rgrep $resource >/dev/null

if [ $? -eq 0 ] ; then
	tell up
else
	tell down
fi

}

store()
{
}


# manual configuration

manual_config()
{


prompt IP "$IP" "Enter IP address of this card"

tell <<END

	NETMASK is a bit-mask for network portion of your
	IP block. For a Class C network, NETMASK=255.255.255.0

END

prompt NETMASK "$NETMASK"

#network_default $IP $NETMASK

NETWORK=$(ip_network $IP $NETMASK)

tell <<END | printf -r $NETWORK

	Enable masquerading (NAT) for IP packets coming from the
	network %s?

END

prompt MASQ "$MASQ"


}


probe_card()
{
entry=`/bin/scan | rgrep Ethernet`

# this must be completed!
case $entry in
*3C905B*)
	echo 3c90x
	;;
*)
	echo
	;;
esac
}


prepare()
{
resource=$1
tell << END

	What kind of network device do you have installed?

		[1] pcmcia	[2] ISA/PCI NIC card


END

prompt M 1 "Your choice?"

case $M in
1)	METHOD='pcmcia';;
2)	METHOD='eth_card';;
esac


# select the eth card

case $METHOD in
eth*)
clear
tell "Supported cards:"
echo
cat /etc/eth.cards
echo

while [ 1 ] ; do
prompt CARD $CARD "Enter card name or 'probe'"

case $CARD in
*probe*)
	tell "Probing PCI cards ..."
	echo -e "$BRIGHT$GREEN"
	/bin/scan pci | rgrep Ethernet
	echo -e "$NORMAL"
	card=`probe_card`
	[ "$card" ] && CARD=$card
	;;
*)
	done=yes
esac
	[ "$done" ] && break
done

tell <<END

	Some NIC ISA card requires IRQ and IO specifications
	(PCI card and 3COM, notably, do not).

	Smples for IO are:

		 0x300, 0x280, 0x320, 0x340, 0x360

	Samples IRQ are: 5,7,9,11 ...

	If your card autoprobe IRQ, reset to blank putting ''

END

prompt IO $IO
prompt IRQ $IRQ
	;;
*)
	CARD='pcmcia'
	;;
esac



tell << END

	If you have a DHCP server, muLinux can use a DHCP (dhcpcd) 
	client, getting the host information (IP address, netmask, 
	broadcast address, etc.) from this card.  

END

prompt DHCP "${DHCP}" "Use DHCP (yes/no)?"


case $DHCP in
n|no)	manual_config
	;;
y|yes)
	IP="0.0.0.0"
	;;
esac

save -n $resource configure
}


stop()
{

if [ -z "`ifconfig | rgrep $resource`" ] ; then
	return
fi

tell "Disabling ethernet interface %s ..." | printf -r "$resource"
ifconfig $resource down

# remove drivers

case $CARD in
pcmcia)
	pcmcia stop
	;;
*)
	rmmod $CARD
	;;
esac
}


load_driver()
{

# setup drivers

case $CARD in
pcmcia)
	mount_startup
	load_module pcmcia/dummy_cs 2>/dev/null	# only for unpack modules :(
	echo
	tell "Now you will see a lot of messages, normally"
	tell "directed to kernellog. Do not worry ..."

	pcmcia start
	echo
	sleep 1 
	;;
*)

        mount_startup
        case ${CARD} in
        ne|ne*|smc-ultra|wd)
                supported driver 8390 || load_module net/8390
                ;;
        *)
        esac

	opt="${IO:+io=$IO} ${IRQ:+irq=$IRQ}"
	supported driver $CARD || load_module net/${CARD} $opt
	;;
esac
}

configure()
{
load_driver
cat /proc/net/dev | rgrep $resource >/dev/null
if [ $? -ne 0 ] ; then
	tell "Sorry: card %s is not well configured." | printf -r $CARD
	exit 1
fi 

# Ok, configure interface or use DHCP

ethconfig $resource 

}
