#--------------------------
# mu-RAS, Samba via phone line 
#--------------------------
#set -x

default()
{
ACTION=ask_the_user
RESOURCE="mu-RAS, the dialin Samba PPP server"
VAR_LIST="DEVICE RING AUTH IDLE LOGIN PASSWORD IP"
HIDDEN_LIST=""
MOD_LIST="net/slhc net/ppp"
DEVICE='/dev/ttyS1'
RING='y'
AUTH='+pap'
IDLE='600'
LOGIN='craxi'
PASSWORD='bettino'
IP='192.168.10.1:192.168.10.2'
}


. /setup/lib/ppp

v=`pppd_version`

info()
{
tell <<END | printf -r "$v"

		   - mu-RAS : The Dialin Samba PPP Server -

This is the muLinux Dialin configuration utility, based on the
rustic "mugetty" program and pppd (v%s).

It set this PC as a modem gateway to the LAN, offering to the remote
user all the possibilities he would have as if he were directly connected
to the LAN: httpd, ftp, telnet, Samba shares, etc.

It is useful also for stand-alone home computers: you have only to call
your home from outside, using the PPP Windows dial-up utility, specifying 
your home phone number. When connection is up, you can access remotely
your disks and programs, using the "Network Resources" folder in M$.

	-- This setup lock the device; outgoing calls are
	   not possible anymore.

END
}

case "$v" in
2.2)
        set_idle=
        ;;
2.*)
        set_idle=y
        ;;
esac


requirement()
{
	return 0
}

check_modem()
{
chat -t 1 '' AT OK < $DEVICE > $DEVICE
}

stop()
{
down

pid=`pppd_pid /dev/dialin`
interface=`pppd_interface /dev/dialin`

if [  -z "$pid" ] ; then
        # no pid entry. pppd is negoziating?
        set -- `ps | rgrep pppd | rgrep /dev/dialin`
        pid=$1
fi
if [ "$pid" ] ; then
kill -1 $pid && kill -9 $pid && echo "$interface (pid $pid) stopped"
ifconfig $interface down 2>/dev/null
fi

# kill mugetty, if any
stop-daemon mugetty > /dev/null

[ "$ACTION" != configure ] && return

# reset modem, silenty (in the case mugetty is crashed)

(
chat -t 1 '' '+++ATH0' < $DEVICE > $DEVICE
chat -t 1 '' '+++ATH0' < $DEVICE > $DEVICE
) 2>/dev/null
}

down()
{
  tell "Disabling mu-RAS, the Dialin PPP Server"
  update_inittab down
  rm -f /var/run/$resource 2>/dev/null
}

up()
{
  echo "`tell Enabling mu-RAS, the Dialin PPP Server` (auth $AUTH)"; sleep 1
  update_inittab up 
  echo `pidof mugetty` > /var/run/$resource
}

update_inittab()
{
repl="s/^RR/#RR/g; s/^RA/#RA/g"

case $RING in
y|Y|yes)
	ID=RR;;
*)
	ID=RA;;
esac

case $1 in
up)
	repl="$repl; s/^#$ID/$ID/g"
	;;
esac

  cat /etc/inittab | sed "$repl" > /tmp/inittab
  cp /tmp/inittab  /etc/inittab
  rm /tmp/inittab
  init q
}


prepare()
{
resource=$1

prompt DEVICE "$DEVICE" "Device where your modem is attached"

tell <<END

	Should I requires the remote peer to authenticate itself
	using PAP, or I've to disable any authentication?

END

prompt AUTH "$AUTH" "Enter -pap or +pap "
case $AUTH in 
+pap)
	prompt LOGIN "$LOGIN" "Enter remote username"
	prompt PASSWORD "$PASSWORD" "Enter remote password"
	;;
esac
tell <<END

Enter the IPs addresses to be assigned to 'local' side
and to 'remote' side, in the form local:remote

END
prompt IP "$IP"

if [ "$set_idle" = y ] ; then
tell <<END

	IDLE limit specifies that pppd should disconnect if  the  link
        is idle for n seconds. The link is idle when no data 
	packets (i.e. IP packets) are  being  sent or received. 

END

	prompt IDLE $IDLE "Enter idle limit in secs (0=no limit)"
else
	IDLE=
fi

tell <<END

	Now, a silly question: must I wait for a ring-ring or
	must I pick-up the phone periodically?
	(adopt the 2th solution if you plan to use two modems
	on your desktop, without a central tone)
 
END

prompt RING "$RING" "Wait for a ring (y/n)?"

save -n $resource configure
}

status()
{
pid=`pppd_pid /dev/dialin`
interface=`pppd_interface /dev/dialin`

if [ "$pid" ]; then
	echo up
else
	echo down
fi
}


configure()
{

  supported device ttyS 
  if [ $? -ne 0 ] ; then
	setup -f port
  fi

  for m in ${MOD_LIST}
  do
    load_module ${m} 2>/dev/null >/dev/null
  done

# create symlinks

( cd /dev; rm dialin; ln -s $DEVICE dialin )

# idle limit

idle_spec=
if [ "$IDLE" ] && [ "$IDLE" -ne 0 ] && [ "$set_idle" = y ]; then
	idle_spec="idle $IDLE"
fi	 

# Create /etc/ppp/dialin.opt for pppd

cat > /etc/ppp/dialin.opt <<END
/dev/dialin
local
-detach
crtscts
lock
debug
proxyarp
asyncmap 0
${idle_spec}
-chap
${AUTH}
${IP}
END


# PAP authentication 

if [ "$AUTH" = "+pap" ] ; then
cat /etc/ppp/pap-secrets | rgrep -v ${LOGIN} > /tmp/pap-secrets
( cat /tmp/pap-secrets;
cat <<END
${LOGIN}		*		${PASSWORD}
END
) > /etc/ppp/pap-secrets
fi

# Ok, start the server
up
}
