#-------------------------
# diald configuration
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="diald (Dial-On-Demand) support"
VAR_LIST="NAMESERVER NETWORK NETMASK SLEEP_TIME IDLE_LIMIT TEST_COMMAND START_COMMAND STOP_COMMAND ACOUSTIC_LOG"
HIDDEN_LIST=""
MOD_LIST=""
NAMESERVER='195.223.180.8'
NETWORK='192.168.1.0'
NETMASK='255.255.255.0'
SLEEP_TIME='1'
IDLE_LIMIT='120'
TEST_COMMAND='ifconfig|rgrep ppp0'
START_COMMAND='pppd'
STOP_COMMAND='ppp-off'
ACOUSTIC_LOG='TRUE'
}

info()
{

tell <<END
		 - Dial-On-Demand (diald) support -

	This is the hyper-rustic diald support for muLinux, a daemon
	based on an IP accounting's hack.
	Enabling diald, muLinux can detected outgoing DNS request
	to some remote NAMESERVER (port 53) and start PPP (or
	what you want, of course).

	-- diald is experimental, so don't expect too much.
	-- start manually with "diald -t", tuning /etc/diald.conf, 
	   if something goes wrong. 

END

}

status()
{
if [ "`pidof diald`" ] ; then
	echo up
else
	echo down
fi

}

prepare()
{
resource=$1

tell << END

	muLinux (rustic) diald work intercepting DNS request to
	a remote NAMESERVER from a NETWORK. Any SLEEP_TIME, diald
	check the the kernel IP accounting, and use TEST_COMMAND, 
	START_COMMAND and STOP_COMMAND for managing the ppp link.
	IDLE_LIMIT set the maximum idle intervall, before 
	to shutdown with STOP_COMMAND.

        You must setup the correct routing in yours clients
        (gateway and *this* NAMESERVER) and correct IP forwarding
        on the server (this host) (using setup ipfwadm).

END

	prompt NAMESERVER ${NAMESERVER} 
	prompt NETWORK ${NETWORK} 

tell <<END

	NETMASK - Enter your subnet mask bit value here.
	If your subnet is 255.255.0.0 this value should be 16;
	if it is 255.255.255.0 this value should be 24 etc

END

	prompt NETMASK ${NETMASK} 
	prompt SLEEP_TIME ${SLEEP_TIME} 
	prompt IDLE_LIMIT ${IDLE_LIMIT} 
	prompt TEST_COMMAND "${TEST_COMMAND}" 
	prompt START_COMMAND "${START_COMMAND}" 
	prompt STOP_COMMAND "${STOP_COMMAND}" 
	prompt ACOUSTIC_LOG ${ACOUSTIC_LOG} 

tell <<END | printf -r "$NAMESERVER"

	If you wish to do some test using a Linux/Unix client,
	put in the client's /etc/resolv.conf this line:

			nameserver %s 

	the try to reach some external URL, for example:

			# nc www.linux.org

	and activate "trafshow" on this machine.

END
sleep 2


save -n $resource configure

}

unwanted()
{
pid=`pidof diald`
if [ "$pid" ] ; then
	kill -9 $pid 2>/dev/null
	echo "`tell diald stopped:` pid $pid"
fi
}


stop()
{
stop-daemon diald
}

configure()
{
cat <<END > /etc/diald.conf
NAMESERVER=$NAMESERVER
NETWORK=$NETWORK
SLEEP_TIME=$SLEEP_TIME
IDLE_LIMIT=$IDLE_LIMIT
TEST_COMMAND="$TEST_COMMAND"
START_COMMAND="$START_COMMAND"
STOP_COMMAND="$STOP_COMMAND"
ACOUSTIC_LOG=$ACOUSTIC_LOG
END

diald &
echo "`tell diald started:` pid $!"
}
