#-------------------------
# crond configuration 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="a running cron daemon"
VAR_LIST=""
HIDDEN_LIST=""
MOD_LIST=""
}


info()
{
tell <<END
		- Periodic Command schedulers -

The "cron" daemon wakes up  every  minute,  examining  all  stored
crontabs (/etc/crontab), checking each command to see if it should be 
run in the current minute.

The "anac(h)ron" daemon wakes up every hour, examining jobs stored in
/etc/cron.daily, /etc/cron.weekly, /etc/cron.monthly. 
Unlike "cron", it does not assume that the machine is running 24h/24h, 
but use a kind of timestamp mechanism, with a delay of 3 min (anacron -h). 

	- "cron" it the true Vixie cron daemon
	- "anacron" is a (rustic) AWK program

END
}

status()
{

if [ "`pidof cron`" ] ; then
	echo up
else
	echo down
fi

}


store()
{
if [ -r /etc/crontab ] ; then
echo "`tell Storing` /etc/crontab, /etc/anacron.conf ..."
cp /etc/crontab /setup/cnf/store
cp /etc/anacron.conf /setup/cnf/store 2>/dev/null
fi
}

stop()
{
stop-daemon cron
}

prepare()
{
resource=$1

tell << END
------------------------------------------------------------------------------
Any entry in /etc/crontab has this syntax:

                min h dom month dow  user command

where min=minute, h=hour, dom=day_of_month, month=1-12, dok=day_of_week,
user=the user, etc.

Examples:

run five min after midnight, every day:

   5 0 * * * root wave -c 440 1           

annoy x@y.it at any xy:15, from 12:00 to 18:00 every two hour, any day:

   15 12-18/2 * * * root  echo ciao| sendmail x@y.it
------------------------------------------------------------------------------

END

prompt edit n "Do you want to edit /etc/crontab now? (no, sure) (y/n)"

if [ "$edit" = y ] ; then
read -p "Exit from  'vi' with  ESC:wq    -- press ENTER --" dummy
vi /etc/crontab
fi

save -n $resource configure
}

configure()
{

if [ -r /setup/cnf/store/crontab ] ; then
cp /setup/cnf/store/crontab /etc
fi

if [ -r /setup/cnf/store/anacron.conf ] ; then
cp /setup/cnf/store/anacron.conf /etc
fi

# create spool dirs

mkdir -p /var/spool/cron
mkdir -p /var/spool/cron/crontabs

chmod 700 /var/spool/cron /var/spool/cron/crontabs
# start cron
cron > /dev/null
# start anacron
anacron -report
anacron
}
