#-------------------------
# Config. CDROM
#-------------------------


default()
{
ACTION=ask_the_user
RESOURCE="CDROM ISO9660 support"
VAR_LIST="CDROM_DEVICE"
HIDDEN_LIST=""
MOD_LIST="fs/isofs"
CDROM_DEVICE='probe'
}


info()
{
tell <<END

			 - CDROM setup -

Now you will be asked for cdrom device.
Examples: if cdrom is master(slave) on ide2 enter /dev/hdc(/dev/hdd).

You can mount(unmount) the cdrom with : mount(umount) /cdrom 

END
}

sanitize()
{
CDROM_DEVICE=probe
save -n $1 ask_the_user
}


prepare()
{
resource=$1

supported device 22 ide1 || \
tell "This Kernel doesn't recognize secondary IDE! "
echo
#save=$IFS; IFS=":"
#set -- `dmesg| sed -n /CD.*ROM/P`
#dev=$1
#IFS=$save

tell "Detecting cdrom ...."; sleep 1
CDROM_DEVICE=`scan ide-cdrom`

if [ "CDROM_DEVICE" ];  then
	printf "`tell Detected [%s]. Please, confirm.`" $CDROM_DEVICE; echo
else
	tell "Probe failed, sorry."
fi
prompt CDROM_DEVICE "$CDROM_DEVICE" 

save -n $resource configure
}

configure()
{
supported device 22 ide1 || echo "Warning: found only an IDE0 interface."
supported filesystem iso9660 || load_module ${MOD_LIST} 

umount /cdrom 2>/dev/null
rm /dev/cdrom 2>/dev/null

if [ -z "${CDROM_DEVICE}" ] || [ "${CDROM_DEVICE}" = probe ] ; then
	tell "Detecting CDROM ... " | tr -d '\012' 
	CDROM_DEVICE=`scan ide-cdrom`
	echo " $CDROM_DEVICE."
	save -n cdrom configure
fi

printf "`tell 'Creating /dev/cdrom->%s link ...'`" $CDROM_DEVICE
echo
ln -s ${CDROM_DEVICE} /dev/cdrom 2>/dev/null

}
