/*
 * Decompiled with CFR 0.152.
 */
package de.mud.terminal;

import de.mud.terminal.VDU;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;

public abstract class vt320
extends VDU
implements KeyListener {
    public static final String ID = "$Id: vt320.java,v 2.9 1999/10/09 11:26:48 marcus Exp $";
    private static final int debug = 0;
    private boolean localecho = false;
    private int pressedKey = 32;
    private String terminalID = "vt320";
    int R;
    int C;
    int Sc;
    int Sr;
    int Sa;
    int attributes = 0;
    int insertmode = 0;
    int statusmode = 0;
    int vt52mode = 0;
    int normalcursor = 0;
    boolean moveoutsidemargins = true;
    boolean sendcrlf = false;
    boolean capslock = false;
    boolean numlock = false;
    private boolean useibmcharset = false;
    private static int lastwaslf = 0;
    private static int i;
    private static final char ESC = '\u001b';
    private static final char IND = '\u0084';
    private static final char NEL = '\u0085';
    private static final char RI = '\u008d';
    private static final char HTS = '\u0088';
    private static final char DCS = '\u0090';
    private static final char CSI = '\u009b';
    private static final char OSC = '\u009d';
    private static final int TSTATE_DATA = 0;
    private static final int TSTATE_ESC = 1;
    private static final int TSTATE_CSI = 2;
    private static final int TSTATE_DCS = 3;
    private static final int TSTATE_DCEQ = 4;
    private static final int TSTATE_ESCSQUARE = 5;
    private static final int TSTATE_OSC = 6;
    private static final int TSTATE_SETG0 = 7;
    private static final int TSTATE_SETG1 = 8;
    private static final int TSTATE_SETG2 = 9;
    private static final int TSTATE_SETG3 = 10;
    private static final int TSTATE_CSI_DOLLAR = 11;
    private static char[] gx;
    private static char gr;
    private static char gl;
    private static char[] DECSPECIAL;
    private String[] FunctionKey;
    private String[] FunctionKeyShift;
    private String[] FunctionKeyCtrl;
    private String[] FunctionKeyAlt;
    private String KeyUp;
    private String KeyDown;
    private String KeyLeft;
    private String KeyRight;
    private String KeyTab;
    private String KeyBacktab;
    private String KP0;
    private String KP1;
    private String KP2;
    private String KP3;
    private String KP4;
    private String KP5;
    private String KP6;
    private String KP7;
    private String KP8;
    private String KP9;
    private String KPMinus;
    private String KPComma;
    private String KPPeriod;
    private String KPEnter;
    private String PF1;
    private String PF2;
    private String PF3;
    private String PF4;
    private String Help;
    private String Do;
    private String Find;
    private String Select;
    private String[] KeyHome;
    private String[] KeyEnd;
    private String[] Insert;
    private String[] Remove;
    private String[] PrevScn;
    private String[] NextScn;
    private String osc;
    private String dcs;
    private int term_state = 0;
    private boolean vms = false;
    private byte[] Tabs;
    private int[] DCEvars = new int[10];
    private int DCEvar;
    private static final char[] unimap;

    static {
        gx = new char[]{'B', '0', 'A', '<'};
        gr = '\u0001';
        gl = '\u0000';
        DECSPECIAL = new char[]{'@', '\u2666', '\u2592', '\u2409', '\u240c', '\u240d', '\u240a', '\u00ba', '\u00b1', '\u2424', '\u240b', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '\u2594', '\u2580', '\u2500', '\u25ac', '_', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265', '\u00b6', '\u2260', '\u00a3', '\u00b7'};
        char[] cArray = new char[256];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 3;
        cArray[4] = 4;
        cArray[5] = 5;
        cArray[6] = 6;
        cArray[7] = 7;
        cArray[8] = 8;
        cArray[9] = 9;
        cArray[10] = 10;
        cArray[11] = 11;
        cArray[12] = 12;
        cArray[13] = 13;
        cArray[14] = 14;
        cArray[15] = 15;
        cArray[16] = 16;
        cArray[17] = 17;
        cArray[18] = 18;
        cArray[19] = 19;
        cArray[20] = 20;
        cArray[21] = 21;
        cArray[22] = 22;
        cArray[23] = 23;
        cArray[24] = 24;
        cArray[25] = 25;
        cArray[26] = 26;
        cArray[27] = 27;
        cArray[28] = 28;
        cArray[29] = 29;
        cArray[30] = 30;
        cArray[31] = 31;
        cArray[32] = 32;
        cArray[33] = 33;
        cArray[34] = 34;
        cArray[35] = 35;
        cArray[36] = 36;
        cArray[37] = 37;
        cArray[38] = 38;
        cArray[39] = 39;
        cArray[40] = 40;
        cArray[41] = 41;
        cArray[42] = 42;
        cArray[43] = 43;
        cArray[44] = 44;
        cArray[45] = 45;
        cArray[46] = 46;
        cArray[47] = 47;
        cArray[48] = 48;
        cArray[49] = 49;
        cArray[50] = 50;
        cArray[51] = 51;
        cArray[52] = 52;
        cArray[53] = 53;
        cArray[54] = 54;
        cArray[55] = 55;
        cArray[56] = 56;
        cArray[57] = 57;
        cArray[58] = 58;
        cArray[59] = 59;
        cArray[60] = 60;
        cArray[61] = 61;
        cArray[62] = 62;
        cArray[63] = 63;
        cArray[64] = 64;
        cArray[65] = 65;
        cArray[66] = 66;
        cArray[67] = 67;
        cArray[68] = 68;
        cArray[69] = 69;
        cArray[70] = 70;
        cArray[71] = 71;
        cArray[72] = 72;
        cArray[73] = 73;
        cArray[74] = 74;
        cArray[75] = 75;
        cArray[76] = 76;
        cArray[77] = 77;
        cArray[78] = 78;
        cArray[79] = 79;
        cArray[80] = 80;
        cArray[81] = 81;
        cArray[82] = 82;
        cArray[83] = 83;
        cArray[84] = 84;
        cArray[85] = 85;
        cArray[86] = 86;
        cArray[87] = 87;
        cArray[88] = 88;
        cArray[89] = 89;
        cArray[90] = 90;
        cArray[91] = 91;
        cArray[92] = 92;
        cArray[93] = 93;
        cArray[94] = 94;
        cArray[95] = 95;
        cArray[96] = 96;
        cArray[97] = 97;
        cArray[98] = 98;
        cArray[99] = 99;
        cArray[100] = 100;
        cArray[101] = 101;
        cArray[102] = 102;
        cArray[103] = 103;
        cArray[104] = 104;
        cArray[105] = 105;
        cArray[106] = 106;
        cArray[107] = 107;
        cArray[108] = 108;
        cArray[109] = 109;
        cArray[110] = 110;
        cArray[111] = 111;
        cArray[112] = 112;
        cArray[113] = 113;
        cArray[114] = 114;
        cArray[115] = 115;
        cArray[116] = 116;
        cArray[117] = 117;
        cArray[118] = 118;
        cArray[119] = 119;
        cArray[120] = 120;
        cArray[121] = 121;
        cArray[122] = 122;
        cArray[123] = 123;
        cArray[124] = 124;
        cArray[125] = 125;
        cArray[126] = 126;
        cArray[127] = 127;
        cArray[128] = 199;
        cArray[129] = 252;
        cArray[130] = 233;
        cArray[131] = 226;
        cArray[132] = 228;
        cArray[133] = 224;
        cArray[134] = 229;
        cArray[135] = 231;
        cArray[136] = 234;
        cArray[137] = 235;
        cArray[138] = 232;
        cArray[139] = 239;
        cArray[140] = 238;
        cArray[141] = 236;
        cArray[142] = 196;
        cArray[143] = 197;
        cArray[144] = 201;
        cArray[145] = 230;
        cArray[146] = 198;
        cArray[147] = 244;
        cArray[148] = 246;
        cArray[149] = 242;
        cArray[150] = 251;
        cArray[151] = 249;
        cArray[152] = 255;
        cArray[153] = 214;
        cArray[154] = 220;
        cArray[155] = 162;
        cArray[156] = 163;
        cArray[157] = 165;
        cArray[158] = 8359;
        cArray[159] = 402;
        cArray[160] = 225;
        cArray[161] = 237;
        cArray[162] = 243;
        cArray[163] = 250;
        cArray[164] = 241;
        cArray[165] = 209;
        cArray[166] = 170;
        cArray[167] = 186;
        cArray[168] = 191;
        cArray[169] = 8976;
        cArray[170] = 172;
        cArray[171] = 189;
        cArray[172] = 188;
        cArray[173] = 161;
        cArray[174] = 171;
        cArray[175] = 187;
        cArray[176] = 9617;
        cArray[177] = 9618;
        cArray[178] = 9619;
        cArray[179] = 9474;
        cArray[180] = 9508;
        cArray[181] = 9569;
        cArray[182] = 9570;
        cArray[183] = 9558;
        cArray[184] = 9557;
        cArray[185] = 9571;
        cArray[186] = 9553;
        cArray[187] = 9559;
        cArray[188] = 9565;
        cArray[189] = 9564;
        cArray[190] = 9563;
        cArray[191] = 9488;
        cArray[192] = 9492;
        cArray[193] = 9524;
        cArray[194] = 9516;
        cArray[195] = 9500;
        cArray[196] = 9472;
        cArray[197] = 9532;
        cArray[198] = 9566;
        cArray[199] = 9567;
        cArray[200] = 9562;
        cArray[201] = 9556;
        cArray[202] = 9577;
        cArray[203] = 9574;
        cArray[204] = 9568;
        cArray[205] = 9552;
        cArray[206] = 9580;
        cArray[207] = 9575;
        cArray[208] = 9576;
        cArray[209] = 9572;
        cArray[210] = 9573;
        cArray[211] = 9561;
        cArray[212] = 9560;
        cArray[213] = 9554;
        cArray[214] = 9555;
        cArray[215] = 9579;
        cArray[216] = 9578;
        cArray[217] = 9496;
        cArray[218] = 9484;
        cArray[219] = 9608;
        cArray[220] = 9604;
        cArray[221] = 9612;
        cArray[222] = 9616;
        cArray[223] = 9600;
        cArray[224] = 945;
        cArray[225] = 223;
        cArray[226] = 915;
        cArray[227] = 960;
        cArray[228] = 931;
        cArray[229] = 963;
        cArray[230] = 181;
        cArray[231] = 964;
        cArray[232] = 934;
        cArray[233] = 920;
        cArray[234] = 937;
        cArray[235] = 948;
        cArray[236] = 8734;
        cArray[237] = 966;
        cArray[238] = 949;
        cArray[239] = 8745;
        cArray[240] = 8801;
        cArray[241] = 177;
        cArray[242] = 8805;
        cArray[243] = 8804;
        cArray[244] = 8992;
        cArray[245] = 8993;
        cArray[246] = 247;
        cArray[247] = 8776;
        cArray[248] = 176;
        cArray[249] = 8729;
        cArray[250] = 183;
        cArray[251] = 8730;
        cArray[252] = 8319;
        cArray[253] = 178;
        cArray[254] = 9632;
        cArray[255] = 160;
        unimap = cArray;
    }

    public vt320() {
        this(80, 24, new Font("Monospaced", 0, 10));
    }

    public vt320(int width, int height) {
        this(width, height, new Font("Monospaced", 0, 10));
    }

    public vt320(int width, int height, Font font) {
        super(width, height, font);
        this.setVMS(false);
        this.setIBMCharset(false);
        this.setTerminalID("vt320");
        this.setBufferSize(100);
        this.setBorder(2, false);
        int nw = this.getColumns();
        if (nw < 132) {
            nw = 132;
        }
        this.Tabs = new byte[nw];
        int i = 0;
        while (i < nw) {
            this.Tabs[i] = 1;
            i += 8;
        }
        this.PF1 = "\u001bOP";
        this.PF2 = "\u001bOQ";
        this.PF3 = "\u001bOR";
        this.PF4 = "\u001bOS";
        this.Insert = new String[4];
        this.Remove = new String[4];
        this.KeyHome = new String[4];
        this.KeyEnd = new String[4];
        this.NextScn = new String[4];
        this.PrevScn = new String[4];
        this.Insert[3] = "\u001b[2~";
        this.Insert[2] = "\u001b[2~";
        this.Insert[1] = "\u001b[2~";
        this.Insert[0] = "\u001b[2~";
        this.Remove[3] = "\u001b[3~";
        this.Remove[2] = "\u001b[3~";
        this.Remove[1] = "\u001b[3~";
        this.Remove[0] = "\u001b[3~";
        this.PrevScn[3] = "\u001b[5~";
        this.PrevScn[2] = "\u001b[5~";
        this.PrevScn[1] = "\u001b[5~";
        this.PrevScn[0] = "\u001b[5~";
        this.NextScn[3] = "\u001b[6~";
        this.NextScn[2] = "\u001b[6~";
        this.NextScn[1] = "\u001b[6~";
        this.NextScn[0] = "\u001b[6~";
        this.KeyHome[3] = "\u001bOH";
        this.KeyHome[2] = "\u001bOH";
        this.KeyHome[1] = "\u001bOH";
        this.KeyHome[0] = "\u001bOH";
        this.KeyEnd[3] = "\u001bOF";
        this.KeyEnd[2] = "\u001bOF";
        this.KeyEnd[1] = "\u001bOF";
        this.KeyEnd[0] = "\u001bOF";
        this.Find = "\u001b[1~";
        this.Select = "\u001b[4~";
        this.Help = "\u001b[28~";
        this.Do = "\u001b[29~";
        this.FunctionKey = new String[21];
        this.FunctionKey[0] = "";
        this.FunctionKey[1] = this.PF1;
        this.FunctionKey[2] = this.PF2;
        this.FunctionKey[3] = this.PF3;
        this.FunctionKey[4] = this.PF4;
        this.FunctionKey[5] = "\u001b[15~";
        this.FunctionKey[6] = "\u001b[17~";
        this.FunctionKey[7] = "\u001b[18~";
        this.FunctionKey[8] = "\u001b[19~";
        this.FunctionKey[9] = "\u001b[20~";
        this.FunctionKey[10] = "\u001b[21~";
        this.FunctionKey[11] = "\u001b[23~";
        this.FunctionKey[12] = "\u001b[24~";
        this.FunctionKey[13] = "\u001b[25~";
        this.FunctionKey[14] = "\u001b[26~";
        this.FunctionKey[15] = this.Help;
        this.FunctionKey[16] = this.Do;
        this.FunctionKey[17] = "\u001b[31~";
        this.FunctionKey[18] = "\u001b[32~";
        this.FunctionKey[19] = "\u001b[33~";
        this.FunctionKey[20] = "\u001b[34~";
        this.FunctionKeyShift = new String[21];
        this.FunctionKeyAlt = new String[21];
        this.FunctionKeyCtrl = new String[21];
        int i2 = 0;
        while (i2 < 20) {
            this.FunctionKeyShift[i2] = "";
            this.FunctionKeyAlt[i2] = "";
            this.FunctionKeyCtrl[i2] = "";
            ++i2;
        }
        this.FunctionKeyShift[15] = this.Find;
        this.FunctionKeyShift[16] = this.Select;
        this.KeyTab = "\t";
        this.KeyBacktab = "\u001bOP\t";
        this.KeyUp = "\u001b[A";
        this.KeyDown = "\u001b[B";
        this.KeyRight = "\u001b[C";
        this.KeyLeft = "\u001b[D";
        this.KP0 = "\u001bOp";
        this.KP1 = "\u001bOq";
        this.KP2 = "\u001bOr";
        this.KP3 = "\u001bOs";
        this.KP4 = "\u001bOt";
        this.KP5 = "\u001bOu";
        this.KP6 = "\u001bOv";
        this.KP7 = "\u001bOw";
        this.KP8 = "\u001bOx";
        this.KP9 = "\u001bOy";
        this.KPMinus = "\u001bOm";
        this.KPComma = "\u001bOl";
        this.KPPeriod = "\u001bOn";
        this.KPEnter = "\u001bOM";
        this.addKeyListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                vt320.this.requestFocus();
            }
        });
    }

    public vt320(Font font) {
        this(80, 24, font);
    }

    private void _SetCursor(int row, int col) {
        int maxr = this.getRows();
        int tm = this.getTopMargin();
        this.R = row < 0 ? 0 : row;
        int n = this.C = col < 0 ? 0 : col;
        if (!this.moveoutsidemargins) {
            this.R += this.getTopMargin();
            maxr = this.getBottomMargin();
        }
        if (this.R > maxr) {
            this.R = maxr;
        }
    }

    public String getTerminalID() {
        return this.terminalID;
    }

    private void handle_dcs(String dcs) {
        System.out.println("DCS: " + dcs);
    }

    private void handle_osc(String osc) {
        System.out.println("OSC: " + osc);
    }

    public void keyPressed(KeyEvent evt) {
        boolean control = evt.isControlDown();
        boolean shift = evt.isShiftDown();
        boolean alt = evt.isAltDown();
        int keyCode = evt.getKeyCode();
        char keyChar = evt.getKeyChar();
        if (keyCode == 10 && !control) {
            if (this.sendcrlf) {
                this.write("\r\n");
            } else {
                this.write("\r");
            }
        }
        if ((!this.vms && keyChar == '2' || keyChar == ' ') && control) {
            this.write("\u0000");
        }
        if (this.vms) {
            if (keyChar == '\b') {
                if (shift && !control) {
                    this.write("\n");
                } else if (control && !shift) {
                    this.write("\u0018");
                } else {
                    this.write("\u007f");
                }
            } else if (keyChar == '\u007f' && !control) {
                if (shift) {
                    this.write(this.Insert[0]);
                } else {
                    this.write(this.Remove[0]);
                }
            } else if (control) {
                switch (keyChar) {
                    case '0': {
                        this.write(this.KP0);
                        return;
                    }
                    case '1': {
                        this.write(this.KP1);
                        return;
                    }
                    case '2': {
                        this.write(this.KP2);
                        return;
                    }
                    case '3': {
                        this.write(this.KP3);
                        return;
                    }
                    case '4': {
                        this.write(this.KP4);
                        return;
                    }
                    case '5': {
                        this.write(this.KP5);
                        return;
                    }
                    case '6': {
                        this.write(this.KP6);
                        return;
                    }
                    case '7': {
                        this.write(this.KP7);
                        return;
                    }
                    case '8': {
                        this.write(this.KP8);
                        return;
                    }
                    case '9': {
                        this.write(this.KP9);
                        return;
                    }
                    case '.': {
                        this.write(this.KPPeriod);
                        return;
                    }
                    case '\u001f': 
                    case '-': {
                        this.write(this.KPMinus);
                        return;
                    }
                    case '+': {
                        this.write(this.KPComma);
                        return;
                    }
                    case '\n': {
                        this.write(this.KPEnter);
                        return;
                    }
                    case '/': {
                        this.write(this.PF2);
                        return;
                    }
                    case '*': {
                        this.write(this.PF3);
                        return;
                    }
                }
            }
            if (shift && keyChar < ' ') {
                this.write(String.valueOf(this.PF1) + (char)(keyChar + 64));
            }
            return;
        }
        int xind = 0;
        String[] fmap = this.FunctionKey;
        if (shift) {
            fmap = this.FunctionKeyShift;
            xind = 1;
        }
        if (control) {
            fmap = this.FunctionKeyCtrl;
            xind = 2;
        }
        if (alt) {
            fmap = this.FunctionKeyAlt;
            xind = 3;
        }
        switch (keyCode) {
            case 112: {
                this.write(fmap[1]);
                return;
            }
            case 113: {
                this.write(fmap[2]);
                return;
            }
            case 114: {
                this.write(fmap[3]);
                return;
            }
            case 115: {
                this.write(fmap[4]);
                return;
            }
            case 116: {
                this.write(fmap[5]);
                return;
            }
            case 117: {
                this.write(fmap[6]);
                return;
            }
            case 118: {
                this.write(fmap[7]);
                return;
            }
            case 119: {
                this.write(fmap[8]);
                return;
            }
            case 120: {
                this.write(fmap[9]);
                return;
            }
            case 121: {
                this.write(fmap[10]);
                return;
            }
            case 122: {
                this.write(fmap[11]);
                return;
            }
            case 123: {
                this.write(fmap[12]);
                return;
            }
            case 38: {
                this.write(this.KeyUp);
                return;
            }
            case 40: {
                this.write(this.KeyDown);
                return;
            }
            case 37: {
                this.write(this.KeyLeft);
                return;
            }
            case 39: {
                this.write(this.KeyRight);
                return;
            }
            case 34: {
                this.write(this.NextScn[xind]);
                return;
            }
            case 33: {
                this.write(this.PrevScn[xind]);
                return;
            }
            case 155: {
                this.write(this.Insert[xind]);
                return;
            }
            case 36: {
                if (this.vms) {
                    this.write("\b");
                } else {
                    this.write(this.KeyHome[xind]);
                }
                return;
            }
            case 35: {
                if (this.vms) {
                    this.write("\u0005");
                } else {
                    this.write(this.KeyEnd[xind]);
                }
                return;
            }
            case 144: {
                if (this.vms && control) {
                    if (this.pressedKey != keyCode) {
                        this.pressedKey = keyCode;
                        this.write(this.PF1);
                    } else {
                        this.pressedKey = 32;
                    }
                }
                if (!control) {
                    this.numlock ^= true;
                }
                return;
            }
            case 20: {
                this.capslock ^= true;
                return;
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        boolean control = evt.isControlDown();
        boolean shift = evt.isShiftDown();
        boolean alt = evt.isAltDown();
        int keyCode = evt.getKeyCode();
        char keyChar = evt.getKeyChar();
        if (shift && keyChar == '\t') {
            this.write(this.KeyBacktab);
        } else if (alt) {
            this.write(String.valueOf((char)(keyChar | 0x80)));
        } else if (this.capslock && !shift) {
            this.write(String.valueOf(keyChar).toUpperCase());
        } else if (keyChar != '\r' && keyChar != '\n' || control) {
            this.write(String.valueOf(keyChar));
        }
    }

    public char map_cp850_unicode(char x) {
        if (x >= '\u0100') {
            return x;
        }
        return unimap[x];
    }

    private void putChar(char c, boolean doshowcursor) {
        int rows = this.getRows();
        int columns = this.getColumns();
        int tm = this.getTopMargin();
        int bm = this.getBottomMargin();
        this.markLine(this.R, 1);
        if (c > '\u00ff') {
            return;
        }
        block0 : switch (this.term_state) {
            case 0: {
                if (!this.useibmcharset) {
                    boolean doneflag = true;
                    switch (c) {
                        case '\u009d': {
                            this.osc = "";
                            this.term_state = 6;
                            break;
                        }
                        case '\u008d': {
                            if (this.R > tm) {
                                --this.R;
                                break;
                            }
                            this.insertLine(this.R, 1, true);
                            break;
                        }
                        case '\u0084': {
                            if (this.R == tm - 1 || this.R == bm || this.R == rows - 1) {
                                this.insertLine(this.R, 1, false);
                                break;
                            }
                            ++this.R;
                            break;
                        }
                        case '\u0085': {
                            if (this.R == tm - 1 || this.R == bm || this.R == rows - 1) {
                                this.insertLine(this.R, 1, false);
                            } else {
                                ++this.R;
                            }
                            this.C = 0;
                            break;
                        }
                        case '\u0088': {
                            this.Tabs[this.C] = 1;
                            break;
                        }
                        case '\u0090': {
                            this.dcs = "";
                            this.term_state = 3;
                            break;
                        }
                        default: {
                            doneflag = false;
                        }
                    }
                    if (doneflag) break;
                }
                switch (c) {
                    case '\u009b': {
                        this.term_state = 4;
                        break;
                    }
                    case '\u001b': {
                        this.term_state = 1;
                        lastwaslf = 0;
                        break;
                    }
                    case '\b': {
                        --this.C;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        lastwaslf = 0;
                        break;
                    }
                    case '\t': {
                        if (this.insertmode == 1) {
                            int newc = this.C;
                            do {
                                this.insertChar(this.C, this.R, ' ', this.attributes);
                            } while (++newc < columns && this.Tabs[newc] == 0);
                        } else {
                            do {
                                this.putChar(this.C++, this.R, ' ', this.attributes);
                            } while (this.C < columns && this.Tabs[this.C] == 0);
                        }
                        lastwaslf = 0;
                        break;
                    }
                    case '\r': {
                        this.C = 0;
                        break;
                    }
                    case '\n': {
                        if (!this.vms) {
                            if (lastwaslf != 0 && lastwaslf != c) break block0;
                            lastwaslf = c;
                        }
                        if (this.R == bm || this.R >= rows - 1) {
                            this.insertLine(this.R, 1);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case '\u000e': {
                        gl = '\u0001';
                        break;
                    }
                    case '\u000f': {
                        gl = '\u0000';
                        break;
                    }
                    default: {
                        lastwaslf = 0;
                        if (c < ' ') break block0;
                        if (this.C >= columns) {
                            if (this.R < rows - 1) {
                                ++this.R;
                            } else {
                                this.insertLine(this.R, false);
                            }
                            this.C = 0;
                        }
                        if (gx[gl] == '0' && c >= '_' && c <= '~') {
                            c = DECSPECIAL[(short)c - 95];
                        }
                        if (this.useibmcharset) {
                            c = this.map_cp850_unicode(c);
                        }
                        if (this.insertmode == 1) {
                            this.insertChar(this.C, this.R, c, this.attributes);
                        } else {
                            this.putChar(this.C, this.R, c, this.attributes);
                        }
                        ++this.C;
                        break;
                    }
                }
                break;
            }
            case 6: {
                if (c < ' ' && c != '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                if (c == '\\' && this.osc.charAt(this.osc.length() - 1) == '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                this.osc = String.valueOf(this.osc) + c;
                break;
            }
            case 1: {
                switch (c) {
                    case '#': {
                        this.term_state = 5;
                        break block0;
                    }
                    case 'c': {
                        int nw = this.getColumns();
                        if (nw < 132) {
                            nw = 132;
                        }
                        this.Tabs = new byte[nw];
                        int i = 0;
                        while (i < nw) {
                            this.Tabs[i] = 1;
                            i += 8;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case '[': {
                        this.term_state = 2;
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        break block0;
                    }
                    case ']': {
                        this.osc = "";
                        this.term_state = 6;
                        break block0;
                    }
                    case 'P': {
                        this.dcs = "";
                        this.term_state = 3;
                        break block0;
                    }
                    case 'E': {
                        if (this.R == tm - 1 || this.R == bm || this.R == rows - 1) {
                            this.insertLine(this.R, 1, false);
                        } else {
                            ++this.R;
                        }
                        this.C = 0;
                        this.term_state = 0;
                        break block0;
                    }
                    case 'D': {
                        if (this.R == tm - 1 || this.R == bm || this.R == rows - 1) {
                            this.insertLine(this.R, 1, false);
                        } else {
                            ++this.R;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'M': {
                        if (this.R >= tm && this.R <= bm) {
                            this.insertLine(this.R, 1, true);
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'H': {
                        if (this.C >= columns) {
                            this.C = columns - 1;
                        }
                        this.Tabs[this.C] = 1;
                        this.term_state = 0;
                        break block0;
                    }
                    case '=': {
                        this.term_state = 0;
                        break block0;
                    }
                    case '>': {
                        this.term_state = 0;
                        break block0;
                    }
                    case '7': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sa = this.attributes;
                        this.term_state = 0;
                        break block0;
                    }
                    case '8': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.attributes = this.Sa;
                        this.term_state = 0;
                        break block0;
                    }
                    case '(': {
                        this.term_state = 7;
                        break block0;
                    }
                    case ')': {
                        this.term_state = 8;
                        break block0;
                    }
                    case '*': {
                        this.term_state = 9;
                        break block0;
                    }
                    case '+': {
                        this.term_state = 10;
                        break block0;
                    }
                    case '~': {
                        this.term_state = 0;
                        gr = '\u0001';
                        break block0;
                    }
                    case 'n': {
                        this.term_state = 0;
                        gl = (char)2;
                        break block0;
                    }
                    case '}': {
                        this.term_state = 0;
                        gr = (char)2;
                        break block0;
                    }
                    case 'o': {
                        this.term_state = 0;
                        gl = (char)3;
                        break block0;
                    }
                    case '|': {
                        this.term_state = 0;
                        gr = (char)3;
                        break block0;
                    }
                }
                System.out.println("ESC unknown letter: (" + c + ")");
                this.term_state = 0;
                break;
            }
            case 7: {
                if (c != '0' && c != 'A' && c != 'B') {
                    System.out.println("ESC ( : G0 char set?  (" + c + ")");
                } else {
                    vt320.gx[0] = c;
                }
                this.term_state = 0;
                break;
            }
            case 8: {
                if (c != '0' && c != 'A' && c != 'B') {
                    System.out.println("ESC ) :G1 char set?  (" + c + ")");
                } else {
                    vt320.gx[1] = c;
                }
                this.term_state = 0;
                break;
            }
            case 9: {
                if (c != '0' && c != 'A' && c != 'B') {
                    System.out.println("ESC*:G2 char set?  (" + c + ")");
                } else {
                    vt320.gx[2] = c;
                }
                this.term_state = 0;
                break;
            }
            case 10: {
                if (c != '0' && c != 'A' && c != 'B') {
                    System.out.println("ESC+:G3 char set?  (" + c + ")");
                } else {
                    vt320.gx[3] = c;
                }
                this.term_state = 0;
                break;
            }
            case 5: {
                switch (c) {
                    case '8': {
                        int i = 0;
                        while (i < columns) {
                            int j = 0;
                            while (j < rows) {
                                this.putChar(i, j, 'E', 0);
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                    default: {
                        System.out.println("ESC # " + c + " not supported.");
                    }
                }
                this.term_state = 0;
                break;
            }
            case 3: {
                if (c == '\\' && this.dcs.charAt(this.dcs.length() - 1) == '\u001b') {
                    this.handle_dcs(this.dcs);
                    this.term_state = 0;
                    break;
                }
                this.dcs = String.valueOf(this.dcs) + c;
                break;
            }
            case 4: {
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        break block0;
                    }
                    case 'r': {
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " r");
                        switch (this.DCEvars[0]) {
                            case 3: {
                                Dimension size = this.getSize();
                                this.setScreenSize(80, rows);
                                break;
                            }
                            case 6: {
                                this.moveoutsidemargins = true;
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'h': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                this.KeyUp = "\u001bOA";
                                this.KeyDown = "\u001bOB";
                                this.KeyRight = "\u001bOC";
                                this.KeyLeft = "\u001bOD";
                                break;
                            }
                            case 3: {
                                Dimension size = this.getSize();
                                this.setScreenSize(132, rows);
                                break;
                            }
                            case 6: {
                                this.moveoutsidemargins = false;
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'l': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                this.KeyUp = "\u001b[A";
                                this.KeyDown = "\u001b[B";
                                this.KeyRight = "\u001b[C";
                                this.KeyLeft = "\u001b[D";
                                break;
                            }
                            case 3: {
                                Dimension size = this.getSize();
                                this.setScreenSize(80, rows);
                                break;
                            }
                            case 6: {
                                this.moveoutsidemargins = true;
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 15: {
                                this.write("\u001b[?13n");
                                System.out.println("ESC[5n");
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                }
                this.term_state = 0;
                break;
            }
            case 11: {
                switch (c) {
                    case '}': {
                        System.out.println("Active Status Display now " + this.DCEvars[0]);
                        this.statusmode = this.DCEvars[0];
                        break;
                    }
                    case '~': {
                        System.out.println("Status Line mode now " + this.DCEvars[0]);
                        break;
                    }
                    default: {
                        System.out.println("UNKNOWN Status Display code " + c + ", with Pn=" + this.DCEvars[0]);
                    }
                }
                this.term_state = 0;
                break;
            }
            case 2: {
                switch (c) {
                    case '$': {
                        this.term_state = 11;
                        break block0;
                    }
                    case '?': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.term_state = 4;
                        break block0;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        break block0;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        break block0;
                    }
                    case 'c': {
                        this.write("\u001b[?1;2c");
                        this.term_state = 0;
                        break block0;
                    }
                    case 'q': {
                        this.term_state = 0;
                        break block0;
                    }
                    case 'g': {
                        switch (this.DCEvars[0]) {
                            case 3: {
                                int nw = this.getColumns();
                                this.Tabs = new byte[nw];
                                break;
                            }
                            case 0: {
                                this.Tabs[this.C] = 0;
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'h': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 1;
                                break;
                            }
                            case 20: {
                                this.sendcrlf = true;
                                break;
                            }
                            default: {
                                System.out.println("unsupported: ESC [ " + this.DCEvars[0] + " h");
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'l': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 0;
                                break;
                            }
                            case 20: {
                                this.sendcrlf = false;
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'A': {
                        int limit = this.R > bm ? bm + 1 : (this.R >= tm ? tm : 0);
                        this.R = this.DCEvars[0] == 0 ? --this.R : (this.R -= this.DCEvars[0]);
                        if (this.R < limit) {
                            this.R = limit;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'B': {
                        int limit = this.R < tm ? tm - 1 : (this.R <= bm ? bm : rows - 1);
                        this.R = this.DCEvars[0] == 0 ? ++this.R : (this.R += this.DCEvars[0]);
                        if (this.R > limit) {
                            this.R = limit;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'C': {
                        this.C = this.DCEvars[0] == 0 ? ++this.C : (this.C += this.DCEvars[0]);
                        if (this.C > columns - 1) {
                            this.C = columns - 1;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'd': {
                        this.R = this.DCEvars[0];
                        System.out.println("ESC [ " + this.DCEvars[0] + " d");
                        this.term_state = 0;
                        break block0;
                    }
                    case 'D': {
                        this.C = this.DCEvars[0] == 0 ? --this.C : (this.C -= this.DCEvars[0]);
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'r': {
                        if (this.DCEvar > 0) {
                            this.R = this.DCEvars[1] - 1;
                            if (this.R < 0) {
                                this.R = rows - 1;
                            } else if (this.R >= rows) {
                                this.R = rows - 1;
                            }
                        } else {
                            this.R = rows - 1;
                        }
                        this.setBottomMargin(this.DCEvars[1] - 1);
                        if (this.R >= this.DCEvars[0]) {
                            this.R = this.DCEvars[0] - 1;
                            if (this.R < 0) {
                                this.R = 0;
                            }
                        }
                        this.setTopMargin(this.DCEvars[0] - 1);
                        this._SetCursor(0, 0);
                        this.term_state = 0;
                        break block0;
                    }
                    case 'G': {
                        this.C = this.DCEvars[0];
                        System.out.println("ESC [ " + this.DCEvars[0] + " G");
                        this.term_state = 0;
                        break block0;
                    }
                    case 'H': {
                        this._SetCursor(this.DCEvars[0] - 1, this.DCEvars[1] - 1);
                        this.term_state = 0;
                        break block0;
                    }
                    case 'f': {
                        this.R = this.DCEvars[0] - 1;
                        this.C = this.DCEvars[1] - 1;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        if (this.R < 0) {
                            this.R = 0;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'L': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(this.R, true);
                        } else {
                            this.insertLine(this.R, this.DCEvars[0], true);
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'M': {
                        if (this.DCEvars[0] == 0) {
                            this.deleteLine(this.R);
                        } else {
                            int i = 0;
                            while (i < this.DCEvars[0]) {
                                this.deleteLine(this.R);
                                ++i;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'K': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                if (this.C >= columns - 1) break;
                                this.deleteArea(this.C, this.R, columns - this.C, 1);
                                break;
                            }
                            case 1: {
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C, 1);
                                break;
                            }
                            case 2: {
                                this.deleteArea(0, this.R, columns, 1);
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'J': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                if (this.R < rows - 1) {
                                    this.deleteArea(0, this.R + 1, columns, rows - this.R - 1);
                                }
                                if (this.C >= columns - 1) break;
                                this.deleteArea(this.C, this.R, columns - this.C, 1);
                                break;
                            }
                            case 1: {
                                if (this.R > 0) {
                                    this.deleteArea(0, 0, columns, this.R - 1);
                                }
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C, 1);
                                break;
                            }
                            case 2: {
                                this.deleteArea(0, 0, columns, rows);
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case '@': {
                        int i = 0;
                        while (i < this.DCEvars[0]) {
                            this.insertChar(this.C, this.R, ' ', this.attributes);
                            ++i;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'P': {
                        if (this.DCEvars[0] == 0) {
                            this.DCEvars[0] = 1;
                        }
                        int i = 0;
                        while (i < this.DCEvars[0]) {
                            this.deleteChar(this.C, this.R);
                            ++i;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 5: {
                                this.write("\u001b[0n");
                                break;
                            }
                            case 6: {
                                this.write("\u001b[" + this.R + ";" + this.C + "R");
                                break;
                            }
                        }
                        this.term_state = 0;
                        break block0;
                    }
                    case 'm': {
                        if (this.DCEvar == 0 && this.DCEvars[0] == 0) {
                            this.attributes = 0;
                        }
                        i = 0;
                        while (i <= this.DCEvar) {
                            switch (this.DCEvars[i]) {
                                case 0: {
                                    if (this.DCEvar <= 0) break;
                                    this.attributes = 0;
                                    break;
                                }
                                case 4: {
                                    this.attributes |= 2;
                                    break;
                                }
                                case 1: {
                                    this.attributes |= 1;
                                    break;
                                }
                                case 7: {
                                    this.attributes |= 4;
                                    break;
                                }
                                case 27: {
                                    this.attributes &= 0xFFFFFFFB;
                                    break;
                                }
                                case 24: {
                                    this.attributes &= 0xFFFFFFFD;
                                    break;
                                }
                                case 22: {
                                    this.attributes &= 0xFFFFFFFE;
                                    break;
                                }
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: {
                                    this.attributes &= 0xFFFFFF87;
                                    this.attributes |= this.DCEvars[i] - 30 + 1 << 3;
                                    break;
                                }
                                case 39: {
                                    this.attributes &= 0xFFFFFF87;
                                    break;
                                }
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    this.attributes &= 0xFFFFF87F;
                                    this.attributes |= this.DCEvars[i] - 40 + 1 << 7;
                                    break;
                                }
                                case 49: {
                                    this.attributes &= 0xFFFFF87F;
                                    break;
                                }
                                default: {
                                    System.out.println("ESC [ " + this.DCEvars[i] + " m unknown...");
                                }
                                case 5: 
                                case 25: 
                            }
                            ++i;
                        }
                        this.term_state = 0;
                        break block0;
                    }
                }
                this.term_state = 0;
                break;
            }
            default: {
                this.term_state = 0;
            }
        }
        if (this.C > columns) {
            this.C = columns;
        }
        if (this.R > rows) {
            this.R = rows;
        }
        if (this.C < 0) {
            this.C = 0;
        }
        if (this.R < 0) {
            this.R = 0;
        }
        if (doshowcursor) {
            this.setCursorPosition(this.C, this.R);
        }
        this.markLine(this.R, 1);
    }

    public void putString(String s) {
        int len = s.length();
        this.markLine(this.R, 1);
        int i = 0;
        while (i < len) {
            this.putChar(s.charAt(i), false);
            ++i;
        }
        this.setCursorPosition(this.C, this.R);
        this.redraw();
    }

    public void setIBMCharset(boolean ibm) {
        this.useibmcharset = ibm;
    }

    public void setKeyCodes(Properties codes) {
        String res;
        String[] prefixes = new String[]{"", "S", "C", "A"};
        int i = 1;
        while (i < 20) {
            res = codes.getProperty("F" + i);
            if (res != null) {
                this.FunctionKey[i] = vt320.unEscape(res);
            }
            if ((res = codes.getProperty("SF" + i)) != null) {
                this.FunctionKeyShift[i] = vt320.unEscape(res);
            }
            if ((res = codes.getProperty("CF" + i)) != null) {
                this.FunctionKeyCtrl[i] = vt320.unEscape(res);
            }
            if ((res = codes.getProperty("AF" + i)) != null) {
                this.FunctionKeyAlt[i] = vt320.unEscape(res);
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            res = codes.getProperty(String.valueOf(prefixes[i]) + "PGUP");
            if (res != null) {
                this.PrevScn[i] = vt320.unEscape(res);
            }
            if ((res = codes.getProperty(String.valueOf(prefixes[i]) + "PGDOWN")) != null) {
                this.NextScn[i] = vt320.unEscape(res);
            }
            if ((res = codes.getProperty(String.valueOf(prefixes[i]) + "END")) != null) {
                this.KeyEnd[i] = vt320.unEscape(res);
            }
            if ((res = codes.getProperty(String.valueOf(prefixes[i]) + "HOME")) != null) {
                this.KeyHome[i] = vt320.unEscape(res);
            }
            if ((res = codes.getProperty(String.valueOf(prefixes[i]) + "INSERT")) != null) {
                this.Insert[i] = vt320.unEscape(res);
            }
            if ((res = codes.getProperty(String.valueOf(prefixes[i]) + "REMOVE")) != null) {
                this.Remove[i] = vt320.unEscape(res);
            }
            ++i;
        }
        res = codes.getProperty("UP");
        if (res != null) {
            this.KeyUp = vt320.unEscape(res);
        }
        if ((res = codes.getProperty("DOWN")) != null) {
            this.KeyDown = vt320.unEscape(res);
        }
        if ((res = codes.getProperty("LEFT")) != null) {
            this.KeyLeft = vt320.unEscape(res);
        }
        if ((res = codes.getProperty("RIGHT")) != null) {
            this.KeyRight = vt320.unEscape(res);
        }
    }

    public void setLocalEcho(boolean echo) {
        this.localecho = echo;
    }

    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }

    public void setVMS(boolean vms) {
        this.vms = vms;
    }

    /*
     * Unable to fully structure code
     */
    static String unEscape(String tmp) {
        idx = 0;
        oldidx = 0;
        cmd = "";
        if (true) ** GOTO lbl43
        do {
            cmd = String.valueOf(cmd) + tmp.substring(oldidx, idx - 1);
            if (idx == tmp.length()) {
                return cmd;
            }
            switch (tmp.charAt(idx)) {
                case 'b': {
                    cmd = String.valueOf(cmd) + "\b";
                    break;
                }
                case 'e': {
                    cmd = String.valueOf(cmd) + "\u001b";
                    break;
                }
                case 'n': {
                    cmd = String.valueOf(cmd) + "\n";
                    break;
                }
                case 'r': {
                    cmd = String.valueOf(cmd) + "\r";
                    break;
                }
                case 't': {
                    cmd = String.valueOf(cmd) + "\t";
                    break;
                }
                case 'v': {
                    cmd = String.valueOf(cmd) + "\u000b";
                    break;
                }
                case 'a': {
                    cmd = String.valueOf(cmd) + "\u0012";
                    break;
                }
                default: {
                    if (tmp.charAt(idx) >= '0' && tmp.charAt(idx) <= '9') {
                        vt320.i = idx;
                        while (vt320.i < tmp.length()) {
                            if (tmp.charAt(vt320.i) < '0' || tmp.charAt(vt320.i) > '9') break;
                            ++vt320.i;
                        }
                        cmd = String.valueOf(cmd) + (char)Integer.parseInt(tmp.substring(idx, vt320.i));
                        idx = vt320.i - 1;
                        break;
                    }
                    cmd = String.valueOf(cmd) + tmp.substring(idx++, idx);
                }
            }
            oldidx = ++idx;
lbl43:
            // 2 sources

            idx = tmp.indexOf(92, oldidx);
        } while (idx >= 0 && ++idx <= tmp.length());
        if (oldidx <= tmp.length()) {
            cmd = String.valueOf(cmd) + tmp.substring(oldidx);
        }
        return cmd;
    }

    private boolean write(String s) {
        this.write(s.getBytes());
        return true;
    }

    protected abstract void write(byte[] var1);
}

