/*
 * Decompiled with CFR 0.152.
 */
package de.mud.terminal;

import de.mud.terminal.SoftFont;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class VDU
extends Canvas
implements MouseListener,
MouseMotionListener {
    public static final String ID = "$Id: VDU.java,v 2.8 1999/09/27 12:33:34 leo Exp $";
    public static final int debug = 0;
    private Dimension size;
    private Insets insets;
    private boolean raised;
    private char[][] charArray;
    private int[][] charAttributes;
    private int bufSize;
    private int maxBufSize;
    private int windowBase;
    private int screenBase;
    private int topMargin;
    private int bottomMargin;
    private Font normalFont;
    private FontMetrics fm;
    private int charWidth;
    private int charHeight;
    private int charDescent;
    private int resizeStrategy;
    private int cursorX;
    private int cursorY;
    private Point selectBegin;
    private Point selectEnd;
    private String selection;
    private Scrollbar scrollBar;
    private SoftFont sf = new SoftFont();
    private boolean screenLocked = false;
    private boolean[] update;
    private Color[] color = new Color[]{this.brighten(Color.black), this.brighten(Color.red), this.brighten(Color.green), this.brighten(Color.yellow), this.brighten(Color.blue), this.brighten(Color.magenta), this.brighten(Color.cyan), this.brighten(Color.white)};
    public static final int COLOR_0 = 0;
    public static final int COLOR_1 = 1;
    public static final int COLOR_2 = 2;
    public static final int COLOR_3 = 3;
    public static final int COLOR_4 = 4;
    public static final int COLOR_5 = 5;
    public static final int COLOR_6 = 6;
    public static final int COLOR_7 = 7;
    private static int COLOR_FG_STD = 7;
    private static int COLOR_FG_BOLD = 3;
    private static int COLOR_BG_STD = 0;
    private static final int COLOR = 2040;
    private static final int COLOR_FG = 120;
    private static final int COLOR_BG = 1920;
    public static final boolean SCROLL_UP = false;
    public static final boolean SCROLL_DOWN = true;
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_SCREEN = 1;
    public static final int RESIZE_FONT = 2;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int UNDERLINE = 2;
    public static final int INVERT = 4;

    public VDU() {
        this(80, 24, new Font("Monospaced", 0, 11));
    }

    public VDU(int width, int height) {
        this(width, height, new Font("Monospaced", 0, 11));
    }

    public VDU(int width, int height, Font font) {
        this.setFont(font);
        this.setResizeStrategy(2);
        this.setScreenSize(width, height);
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        this.clearSelection();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                VDU.this.markLine(0, 24);
                if (evt.isControlDown()) {
                    Component frame = VDU.this;
                    while (frame != null && !(frame instanceof Frame)) {
                        frame = frame.getParent();
                    }
                    PrintJob printJob = VDU.this.getToolkit().getPrintJob((Frame)frame, "VDU terminal printout", null);
                    VDU.this.print(printJob.getGraphics());
                }
            }
        });
        this.selection = null;
    }

    public VDU(Font font) {
        this(80, 24, font);
    }

    private Color brighten(Color clr) {
        return new Color(Math.max((int)((double)clr.getRed() * 0.85), 0), Math.max((int)((double)clr.getGreen() * 0.85), 0), Math.max((int)((double)clr.getBlue() * 0.85), 0));
    }

    private boolean buttonCheck(int modifiers, int mask) {
        return (modifiers & mask) == mask;
    }

    private int checkBounds(int value, int lower, int upper) {
        if (value < lower) {
            return lower;
        }
        if (value > upper) {
            return upper;
        }
        return value;
    }

    public void clearSelection() {
        this.selectBegin = new Point(0, 0);
        this.selectEnd = new Point(0, 0);
        this.selection = null;
    }

    public void deleteArea(int c, int l, int w, int h) {
        c = this.checkBounds(c, 0, this.size.width - 1);
        l = this.checkBounds(l, 0, this.size.height - 1);
        char[] cbuf = new char[w];
        int[] abuf = new int[w];
        int i = 0;
        while (i < h && l + i < this.size.height) {
            System.arraycopy(cbuf, 0, this.charArray[this.screenBase + l + i], c, w);
            System.arraycopy(abuf, 0, this.charAttributes[this.screenBase + l + i], c, w);
            ++i;
        }
        this.markLine(l, h);
    }

    public void deleteChar(int c, int l) {
        c = this.checkBounds(c, 0, this.size.width - 1);
        l = this.checkBounds(l, 0, this.size.height - 1);
        if (c < this.size.width - 1) {
            System.arraycopy(this.charArray[this.screenBase + l], c + 1, this.charArray[this.screenBase + l], c, this.size.width - c - 1);
            System.arraycopy(this.charAttributes[this.screenBase + l], c + 1, this.charAttributes[this.screenBase + l], c, this.size.width - c - 1);
        }
        this.putChar(this.size.width - 1, l, '\u0000');
    }

    public void deleteLine(int l) {
        int bottom = (l = this.checkBounds(l, 0, this.size.height - 1)) > this.bottomMargin ? this.size.height - 1 : (l < this.topMargin ? this.topMargin : this.bottomMargin + 1);
        System.arraycopy(this.charArray, this.screenBase + l + 1, this.charArray, this.screenBase + l, bottom - l - 1);
        System.arraycopy(this.charAttributes, this.screenBase + l + 1, this.charAttributes, this.screenBase + l, bottom - l - 1);
        this.charArray[this.screenBase + bottom - 1] = new char[this.size.width];
        this.charAttributes[this.screenBase + bottom - 1] = new int[this.size.width];
        this.markLine(l, bottom - l);
    }

    public int getAttributes(int c, int l) {
        c = this.checkBounds(c, 0, this.size.width - 1);
        l = this.checkBounds(l, 0, this.size.height - 1);
        return this.charAttributes[l][c];
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public char getChar(int c, int l) {
        c = this.checkBounds(c, 0, this.size.width - 1);
        l = this.checkBounds(l, 0, this.size.height - 1);
        return this.charArray[l][c];
    }

    public Color[] getColorSet() {
        return this.color;
    }

    public int getColumns() {
        return this.size.width;
    }

    public Dimension getCursorPosition() {
        return new Dimension(this.cursorX, this.cursorY);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public int getMaxBufferSize() {
        return this.maxBufSize;
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public int getRows() {
        return this.size.height;
    }

    public Dimension getScreenSize() {
        return this.size;
    }

    public String getSelection() {
        return this.selection;
    }

    public Dimension getSize() {
        int xborder = 0;
        int yborder = 0;
        if (this.insets != null) {
            xborder = this.insets.left + this.insets.right;
            yborder = this.insets.top + this.insets.bottom;
        }
        return new Dimension(this.size.width * this.charWidth + xborder, this.size.height * this.charHeight + yborder);
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getWindowBase() {
        return this.windowBase;
    }

    public void insertChar(int c, int l, char ch, int attributes) {
        c = this.checkBounds(c, 0, this.size.width - 1);
        l = this.checkBounds(l, 0, this.size.height - 1);
        System.arraycopy(this.charArray[this.screenBase + l], c, this.charArray[this.screenBase + l], c + 1, this.size.width - c - 1);
        System.arraycopy(this.charAttributes[this.screenBase + l], c, this.charAttributes[this.screenBase + l], c + 1, this.size.width - c - 1);
        this.putChar(c, l, ch, attributes);
    }

    public void insertLine(int l) {
        this.insertLine(l, 1, false);
    }

    public void insertLine(int l, int n) {
        this.insertLine(l, n, false);
    }

    public synchronized void insertLine(int l, int n, boolean scrollDown) {
        int bottom;
        int top;
        this.screenLocked = true;
        l = this.checkBounds(l, 0, this.size.height - 1);
        char[][] cbuf = null;
        int[][] abuf = null;
        int offset = 0;
        int oldBase = this.screenBase;
        int n2 = l < this.topMargin ? 0 : (l > this.bottomMargin ? (this.bottomMargin + 1 < this.size.height ? this.bottomMargin + 1 : this.size.height - 1) : (top = this.topMargin));
        int n3 = l > this.bottomMargin ? this.size.height - 1 : (l < this.topMargin ? (this.topMargin > 0 ? this.topMargin - 1 : 0) : (bottom = this.bottomMargin));
        if (scrollDown) {
            if (n > bottom - top) {
                n = bottom - top;
            }
            cbuf = new char[bottom - l - (n - 1)][this.size.width];
            abuf = new int[bottom - l - (n - 1)][this.size.width];
            System.arraycopy(this.charArray, oldBase + l, cbuf, 0, bottom - l - (n - 1));
            System.arraycopy(this.charAttributes, oldBase + l, abuf, 0, bottom - l - (n - 1));
            System.arraycopy(cbuf, 0, this.charArray, oldBase + l + n, bottom - l - (n - 1));
            System.arraycopy(abuf, 0, this.charAttributes, oldBase + l + n, bottom - l - (n - 1));
            cbuf = this.charArray;
            abuf = this.charAttributes;
        } else {
            try {
                if (n > bottom - top + 1) {
                    n = bottom - top + 1;
                }
                if (this.bufSize < this.maxBufSize) {
                    if (this.bufSize + n > this.maxBufSize) {
                        offset = n - (this.maxBufSize - this.bufSize);
                        this.bufSize = this.maxBufSize;
                        this.windowBase = this.screenBase = this.maxBufSize - this.size.height - 1;
                    } else {
                        this.screenBase += n;
                        this.windowBase += n;
                        this.bufSize += n;
                    }
                    cbuf = new char[this.bufSize][this.size.width];
                    abuf = new int[this.bufSize][this.size.width];
                } else {
                    offset = n;
                    cbuf = this.charArray;
                    abuf = this.charAttributes;
                }
                if (oldBase > 0) {
                    System.arraycopy(this.charArray, offset, cbuf, 0, oldBase - offset);
                    System.arraycopy(this.charAttributes, offset, abuf, 0, oldBase - offset);
                }
                if (top > 0) {
                    System.arraycopy(this.charArray, oldBase, cbuf, this.screenBase, top);
                    System.arraycopy(this.charAttributes, oldBase, abuf, this.screenBase, top);
                }
                if (oldBase > 0) {
                    System.arraycopy(this.charArray, oldBase + top, cbuf, oldBase - offset, n);
                    System.arraycopy(this.charAttributes, oldBase + top, abuf, oldBase - offset, n);
                }
                System.arraycopy(this.charArray, oldBase + top + n, cbuf, this.screenBase + top, l - top - (n - 1));
                System.arraycopy(this.charAttributes, oldBase + top + n, abuf, this.screenBase + top, l - top - (n - 1));
                if (l < this.size.height - 1) {
                    System.arraycopy(this.charArray, oldBase + l + 1, cbuf, this.screenBase + l + 1, this.size.height - 1 - l);
                    System.arraycopy(this.charAttributes, oldBase + l + 1, abuf, this.screenBase + l + 1, this.size.height - 1 - l);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("*** Error while scrolling up:");
                System.err.println("--- BEGIN STACK TRACE ---");
                e.printStackTrace();
                System.err.println("--- END STACK TRACE ---");
                System.err.println("bufSize=" + this.bufSize + ", maxBufSize=" + this.maxBufSize);
                System.err.println("top=" + top + ", bottom=" + bottom);
                System.err.println("n=" + n + ", l=" + l);
                System.err.println("screenBase=" + this.screenBase + ", windowBase=" + this.windowBase);
                System.err.println("oldBase=" + oldBase);
                System.err.println("size.width=" + this.size.width + ", size.height=" + this.size.height);
                System.err.println("abuf.length=" + abuf.length + ", cbuf.length=" + cbuf.length);
                System.err.println("*** done dumping debug information");
            }
        }
        int i = 0;
        while (i < n) {
            cbuf[this.screenBase + l + (scrollDown ? i : -i)] = new char[this.size.width];
            abuf[this.screenBase + l + (scrollDown ? i : -i)] = new int[this.size.width];
            ++i;
        }
        this.charArray = cbuf;
        this.charAttributes = abuf;
        if (scrollDown) {
            this.markLine(l, bottom - l + 1);
        } else {
            this.markLine(top, l - top + 1);
        }
        if (this.scrollBar != null) {
            this.scrollBar.setValues(this.windowBase, this.size.height, 0, this.bufSize);
        }
        this.screenLocked = false;
    }

    public void insertLine(int l, boolean scrollDown) {
        this.insertLine(l, 1, scrollDown);
    }

    public void markLine(int l, int n) {
        l = this.checkBounds(l, 0, this.size.height - 1);
        int i = 0;
        while (i < n && l + i < this.size.height) {
            this.update[l + i + 1] = true;
            ++i;
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.buttonCheck(evt.getModifiers(), 16)) {
            int xoffset = (super.getSize().width - this.size.width * this.charWidth) / 2;
            int yoffset = (super.getSize().height - this.size.height * this.charHeight) / 2;
            int x = (evt.getX() - xoffset) / this.charWidth;
            int y = (evt.getY() - yoffset) / this.charHeight + this.windowBase;
            int oldx = this.selectEnd.x;
            int oldy = this.selectEnd.y;
            if (x < this.selectBegin.x && y < this.selectBegin.y && x < this.selectEnd.x && y < this.selectEnd.y) {
                this.selectBegin.x = x;
                this.selectBegin.y = y;
            } else {
                this.selectEnd.x = x;
                this.selectEnd.y = y;
            }
            if (oldx != x || oldy != y) {
                this.repaint();
            }
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (this.buttonCheck(evt.getModifiers(), 16)) {
            int xoffset = (super.getSize().width - this.size.width * this.charWidth) / 2;
            int yoffset = (super.getSize().height - this.size.height * this.charHeight) / 2;
            this.selectBegin.x = (evt.getX() - xoffset) / this.charWidth;
            this.selectBegin.y = (evt.getY() - yoffset) / this.charHeight + this.windowBase;
            this.selectEnd.x = this.selectBegin.x;
            this.selectEnd.y = this.selectBegin.y;
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.buttonCheck(evt.getModifiers(), 16)) {
            int xoffset = (super.getSize().width - this.size.width * this.charWidth) / 2;
            int yoffset = (super.getSize().height - this.size.height * this.charHeight) / 2;
            this.mouseDragged(evt);
            if (this.selectBegin.x == this.selectEnd.x && this.selectBegin.y == this.selectEnd.y) {
                this.repaint();
                return;
            }
            this.selection = "";
            if (this.selectEnd.x < 0) {
                this.selectEnd.x = 0;
            }
            if (this.selectEnd.y < 0) {
                this.selectEnd.y = 0;
            }
            if (this.selectEnd.y >= this.charArray.length) {
                this.selectEnd.y = this.charArray.length - 1;
            }
            if (this.selectEnd.x >= this.charArray[0].length) {
                this.selectEnd.x = this.charArray[0].length - 1;
            }
            int l = this.selectBegin.y;
            while (l <= this.selectEnd.y) {
                int end;
                int start;
                start = l == this.selectBegin.y ? (start = this.selectBegin.x) : 0;
                end = l == this.selectEnd.y ? (end = this.selectEnd.x) : this.charArray.length - 1;
                this.selection = String.valueOf(this.selection) + new String(this.charArray[l]).substring(start, end);
                if (end == this.charArray.length - 1) {
                    this.selection = String.valueOf(this.selection) + "\n";
                }
                ++l;
            }
            this.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void paint(Graphics g) {
        if (this.screenLocked) {
            return;
        }
        xoffset = (super.getSize().width - this.size.width * this.charWidth) / 2;
        yoffset = (super.getSize().height - this.size.height * this.charHeight) / 2;
        fg = this.color[VDU.COLOR_FG_STD];
        bg = this.color[VDU.COLOR_BG_STD];
        g.setFont(this.normalFont);
        l = 0;
        while (l < this.size.height) {
            block24: {
                if (this.update[0] && !this.update[l + 1]) break block24;
                this.update[l + 1] = false;
                c = 0;
                while (c < this.size.width) {
                    block25: {
                        addr = 0;
                        currAttr = this.charAttributes[this.windowBase + l][c];
                        fg = this.getForeground();
                        bg = this.getBackground();
                        if ((currAttr & 1) != 0 && (currAttr & 120) == 0 && (currAttr & 1920) == 0) {
                            fg = this.color[VDU.COLOR_FG_BOLD];
                        }
                        if ((currAttr & 120) != 0) {
                            fg = this.color[((currAttr & 120) >> 3) - 1];
                        }
                        if ((currAttr & 1920) != 0) {
                            bg = this.color[((currAttr & 1920) >> 7) - 1];
                        }
                        if ((currAttr & 1) != 0) {
                            if (fg.equals(Color.black)) {
                                fg = Color.gray;
                            } else {
                                fg = fg.brighter();
                                bg = bg.brighter();
                            }
                        }
                        if ((currAttr & 4) != 0) {
                            swapc = bg;
                            bg = fg;
                            fg = swapc;
                        }
                        if (!this.sf.inSoftFont(this.charArray[this.windowBase + l][c])) ** GOTO lbl45
                        g.setColor(bg);
                        g.fillRect(c * this.charWidth + xoffset, l * this.charHeight + yoffset, this.charWidth, this.charHeight);
                        g.setColor(fg);
                        this.sf.drawChar(g, this.charArray[this.windowBase + l][c], xoffset + c * this.charWidth, l * this.charHeight + yoffset, this.charWidth, this.charHeight);
                        if ((currAttr & 2) == 0) break block25;
                        g.drawLine(c * this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent / 2 + yoffset, c * this.charWidth + this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent / 2 + yoffset);
                        break block25;
lbl-1000:
                        // 1 sources

                        {
                            if (this.charArray[this.windowBase + l][c + addr] < ' ') {
                                this.charArray[this.windowBase + l][c + addr] = 32;
                            }
                            ++addr;
lbl45:
                            // 2 sources

                            ** while (c + addr < this.size.width && this.charAttributes[this.windowBase + l][c + addr] == currAttr && !this.sf.inSoftFont((char)this.charArray[this.windowBase + l][c + addr]))
                        }
lbl46:
                        // 1 sources

                        g.setColor(bg);
                        g.fillRect(c * this.charWidth + xoffset, l * this.charHeight + yoffset, addr * this.charWidth, this.charHeight);
                        g.setColor(fg);
                        g.drawChars(this.charArray[this.windowBase + l], c, addr, c * this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent + yoffset);
                        if ((currAttr & 2) != 0) {
                            g.drawLine(c * this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent / 2 + yoffset, c * this.charWidth + addr * this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent / 2 + yoffset);
                        }
                        c += addr - 1;
                    }
                    ++c;
                }
            }
            ++l;
        }
        if (this.screenBase + this.cursorY >= this.windowBase && this.screenBase + this.cursorY < this.windowBase + this.size.height) {
            g.setColor(this.color[VDU.COLOR_FG_STD]);
            g.setXORMode(this.color[VDU.COLOR_BG_STD]);
            g.fillRect(this.cursorX * this.charWidth + xoffset, (this.cursorY + this.screenBase - this.windowBase) * this.charHeight + yoffset, this.charWidth, this.charHeight);
            g.setPaintMode();
        }
        if (this.windowBase <= this.selectBegin.y || this.windowBase <= this.selectEnd.y) {
            beginLine = this.selectBegin.y - this.windowBase;
            endLine = this.selectEnd.y - this.selectBegin.y;
            if (beginLine < 0) {
                endLine += beginLine;
                beginLine = 0;
            }
            if (endLine > this.size.height) {
                endLine = this.size.height - beginLine;
            }
            g.setXORMode(this.color[VDU.COLOR_BG_STD]);
            g.fillRect(this.selectBegin.x * this.charWidth + xoffset, beginLine * this.charHeight + yoffset, (endLine == 0 ? this.selectEnd.x - this.selectBegin.x : this.size.width - this.selectBegin.x) * this.charWidth, this.charHeight);
            if (endLine > 1) {
                g.fillRect(xoffset, (beginLine + 1) * this.charHeight + yoffset, this.size.width * this.charWidth, (endLine - 1) * this.charHeight);
            }
            if (endLine > 0) {
                g.fillRect(xoffset, (beginLine + endLine) * this.charHeight + yoffset, this.selectEnd.x * this.charWidth, this.charHeight);
            }
            g.setPaintMode();
        }
        if (this.insets != null) {
            g.setColor(this.getBackground());
            --xoffset;
            --yoffset;
            i = this.insets.top - 1;
            while (i >= 0) {
                g.draw3DRect(xoffset - i, yoffset - i, this.charWidth * this.size.width + 1 + i * 2, this.charHeight * this.size.height + 1 + i * 2, this.raised);
                --i;
            }
        }
        this.update[0] = false;
    }

    public void print(Graphics g) {
        int i = 0;
        while (i <= this.size.height) {
            this.update[i] = true;
            ++i;
        }
        this.paint(g);
    }

    public void putChar(int c, int l, char ch) {
        this.putChar(c, l, ch, 0);
    }

    public void putChar(int c, int l, char ch, int attributes) {
        c = this.checkBounds(c, 0, this.size.width - 1);
        l = this.checkBounds(l, 0, this.size.height - 1);
        this.charArray[this.screenBase + l][c] = ch;
        this.charAttributes[this.screenBase + l][c] = attributes;
        this.markLine(l, 1);
    }

    public void putString(int c, int l, String s) {
        this.putString(c, l, s, 0);
    }

    public void putString(int c, int l, String s, int attributes) {
        int i = 0;
        while (i < s.length() && c + i < this.size.width) {
            this.putChar(c + i, l, s.charAt(i), attributes);
            ++i;
        }
    }

    public void redraw() {
        this.update[0] = true;
        this.repaint();
    }

    public void setBorder(int thickness, boolean raised) {
        this.insets = thickness == 0 ? null : new Insets(thickness + 1, thickness + 1, thickness + 1, thickness + 1);
        this.raised = raised;
    }

    public void setBottomMargin(int l) {
        if (l < this.topMargin) {
            this.bottomMargin = this.topMargin;
            this.topMargin = l;
        } else {
            this.bottomMargin = l;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.size.height - 1) {
            this.bottomMargin = this.size.height - 1;
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        int xborder = 0;
        int yborder = 0;
        if (this.insets != null) {
            xborder = this.insets.left + this.insets.right;
            w -= xborder;
            yborder = this.insets.top + this.insets.bottom;
            h -= yborder;
        }
        Font tmpFont = this.normalFont;
        String fontName = tmpFont.getName();
        int fontStyle = tmpFont.getStyle();
        this.fm = this.getFontMetrics(this.normalFont);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
        }
        switch (this.resizeStrategy) {
            case 1: {
                this.size.height = h / this.charHeight;
                this.setScreenSize(w / this.charWidth, this.size.height);
                break;
            }
            case 2: {
                int height = h / this.size.height;
                int width = w / this.size.width;
                this.normalFont = new Font(fontName, fontStyle, this.charHeight);
                this.fm = this.getFontMetrics(this.normalFont);
                if (this.fm.getHeight() < height || this.fm.charWidth('@') < width) {
                    do {
                        this.normalFont = new Font(fontName, fontStyle, ++this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.fm.getHeight() < height || this.fm.charWidth('@') < width);
                }
                if (this.fm.getHeight() > height || this.fm.charWidth('@') > width) {
                    do {
                        this.normalFont = new Font(fontName, fontStyle, --this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.charHeight > 1 && (this.fm.getHeight() > height || this.fm.charWidth('@') > width));
                }
                if (this.charHeight <= 1) {
                    System.err.println("VDU: error during resize, resetting");
                    this.normalFont = tmpFont;
                    System.err.println("VDU: disabling font/screen resize");
                    this.resizeStrategy = 0;
                }
                this.setFont(this.normalFont);
                this.fm = this.getFontMetrics(this.normalFont);
                this.charWidth = this.fm.charWidth('@');
                this.charHeight = this.fm.getHeight();
                this.charDescent = this.fm.getDescent();
                break;
            }
        }
    }

    public void setBufferSize(int amount) {
        this.screenLocked = true;
        if (amount < this.size.height) {
            amount = this.size.height;
        }
        if (amount < this.maxBufSize) {
            char[][] cbuf = new char[amount][this.size.width];
            int[][] abuf = new int[amount][this.size.width];
            if (this.charArray != null) {
                System.arraycopy(this.charArray, this.bufSize - amount, cbuf, 0, amount);
            }
            if (this.charAttributes != null) {
                System.arraycopy(this.charAttributes, this.bufSize - amount, abuf, 0, amount);
            }
            this.charArray = cbuf;
            this.charAttributes = abuf;
        }
        this.maxBufSize = amount;
        this.screenLocked = false;
        this.repaint();
    }

    public void setColorSet(Color[] colorset) {
        System.arraycopy(colorset, 0, this.color, 0, 8);
    }

    public void setCursorPosition(int c, int l) {
        c = this.checkBounds(c, 0, this.size.width - 1);
        l = this.checkBounds(l, 0, this.size.height - 1);
        this.markLine(this.cursorY, 1);
        this.cursorX = c < this.size.width ? c : this.size.width;
        this.cursorY = l < this.size.height ? l : this.size.height;
        this.markLine(l, 1);
    }

    public void setFont(Font font) {
        this.normalFont = font;
        super.setFont(this.normalFont);
        this.fm = this.getFontMetrics(font);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
            this.charDescent = this.fm.getDescent();
        }
    }

    public void setResizeStrategy(int strategy) {
        this.resizeStrategy = strategy;
    }

    public void setScreenSize(int width, int height) {
        int i;
        int bsize = this.bufSize;
        if (width < 1 || height < 1) {
            return;
        }
        this.screenLocked = true;
        if (height > this.maxBufSize) {
            this.maxBufSize = height;
        }
        if (height > this.bufSize) {
            this.bufSize = height;
            this.screenBase = 0;
            this.windowBase = 0;
        }
        char[][] cbuf = new char[this.bufSize][width];
        int[][] abuf = new int[this.bufSize][width];
        if (this.charArray != null && this.charAttributes != null) {
            i = 0;
            while (i < bsize && i < this.bufSize) {
                System.arraycopy(this.charArray[i], 0, cbuf[i], 0, width < this.size.width ? width : this.size.width);
                System.arraycopy(this.charAttributes[i], 0, abuf[i], 0, width < this.size.width ? width : this.size.width);
                ++i;
            }
        }
        this.charArray = cbuf;
        this.charAttributes = abuf;
        this.size = new Dimension(width, height);
        this.topMargin = 0;
        this.bottomMargin = height - 1;
        this.update = new boolean[height + 1];
        i = 0;
        while (i <= height) {
            this.update[i] = true;
            ++i;
        }
        this.screenLocked = false;
    }

    public void setScrollbar(Scrollbar scrollBar) {
        if (scrollBar == null) {
            return;
        }
        this.scrollBar = scrollBar;
        this.scrollBar.setValues(this.windowBase, this.size.height, 0, this.bufSize - this.size.height);
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                VDU.this.setWindowBase(evt.getValue());
            }
        });
    }

    public void setTopMargin(int l) {
        if (l > this.bottomMargin) {
            this.topMargin = this.bottomMargin;
            this.bottomMargin = l;
        } else {
            this.topMargin = l;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.size.height - 1) {
            this.bottomMargin = this.size.height - 1;
        }
    }

    public void setWindowBase(int line) {
        if (line > this.screenBase) {
            line = this.screenBase;
        } else if (line < 0) {
            line = 0;
        }
        this.windowBase = line;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

