/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.SshCrypto;
import de.mud.ssh.SshMisc;
import java.io.IOException;

class SshPacket {
    private byte[] packet_length_array = new byte[4];
    private int packet_length = 0;
    private byte[] padding = null;
    private byte packet_type;
    private short last_packet_type;
    private byte[] data = null;
    private byte[] crc_array = new byte[4];
    private byte[] block = null;
    private byte[] encryptedBlock = null;
    private byte[] decryptedBlock = null;
    public static boolean encryption = false;
    public static SshCrypto crypto;
    public boolean toBeFinished = false;
    public byte[] unfinishedBuffer;
    public int positionInUnfinishedBuffer;
    private int position = 0;
    private int phase_packet = 0;
    private final int PHASE_packet_length = 0;
    private final int PHASE_block = 1;

    public SshPacket(byte newType, byte[] newData) throws IOException {
        int i;
        this.data = newData;
        this.packet_type = newType;
        this.packet_length = this.data != null ? this.data.length + 5 : 5;
        this.packet_length_array[3] = (byte)(this.packet_length & 0xFF);
        this.packet_length_array[2] = (byte)(this.packet_length >> 8 & 0xFF);
        this.packet_length_array[1] = (byte)(this.packet_length >> 16 & 0xFF);
        this.packet_length_array[0] = (byte)(this.packet_length >> 24 & 0xFF);
        this.padding = new byte[8 - this.packet_length % 8];
        if (!encryption) {
            i = 0;
            while (i < this.padding.length) {
                this.padding[i] = 0;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.padding.length) {
                this.padding[i] = SshMisc.getNotZeroRandomByte();
                ++i;
            }
        }
        byte[] tempByte = new byte[this.packet_length + this.padding.length - 4];
        int offset = 0;
        int i2 = 0;
        while (i2 < this.padding.length) {
            tempByte[offset++] = this.padding[i2];
            ++i2;
        }
        tempByte[offset++] = this.packet_type;
        if (this.packet_length > 5) {
            int i3 = 0;
            while (i3 < this.data.length) {
                tempByte[offset++] = this.data[i3];
                ++i3;
            }
        }
        long crc = 0L;
        crc = SshMisc.crc32(tempByte, tempByte.length);
        this.crc_array[3] = (byte)(crc & 0xFFL);
        this.crc_array[2] = (byte)(crc >> 8 & 0xFFL);
        this.crc_array[1] = (byte)(crc >> 16 & 0xFFL);
        this.crc_array[0] = (byte)(crc >> 24 & 0xFFL);
        this.setBlock();
        if (encryption) {
            crypto.encrypt(this.block);
        }
        this.encryptedBlock = this.block;
    }

    private boolean checkCrc() {
        byte[] crc_arrayCheck = new byte[4];
        long crcCheck = SshMisc.crc32(this.decryptedBlock, this.decryptedBlock.length - 4);
        crc_arrayCheck[3] = (byte)(crcCheck & 0xFFL);
        crc_arrayCheck[2] = (byte)(crcCheck >> 8 & 0xFFL);
        crc_arrayCheck[1] = (byte)(crcCheck >> 16 & 0xFFL);
        crc_arrayCheck[0] = (byte)(crcCheck >> 24 & 0xFFL);
        if (crc_arrayCheck[3] != this.crc_array[3]) {
            return false;
        }
        if (crc_arrayCheck[2] != this.crc_array[2]) {
            return false;
        }
        if (crc_arrayCheck[1] != this.crc_array[1]) {
            return false;
        }
        return crc_arrayCheck[0] == this.crc_array[0];
    }

    public byte[] getBytes() throws IOException {
        return SshMisc.addArrayOfBytes(this.packet_length_array, this.encryptedBlock);
    }

    public byte[] getData() throws IOException {
        return this.data;
    }

    public SshPacket getPacketfromBytes(byte[] buff, int offset, int count) throws IOException {
        int boffset = offset;
        while (boffset < count) {
            byte b = buff[boffset++];
            switch (this.phase_packet) {
                case 0: {
                    this.packet_length_array[this.position] = b;
                    if (++this.position < 4) break;
                    this.packet_length = (this.packet_length_array[3] & 0xFF) + ((this.packet_length_array[2] & 0xFF) << 8) + ((this.packet_length_array[1] & 0xFF) << 16) + ((this.packet_length_array[0] & 0xFF) << 24);
                    this.position = 0;
                    ++this.phase_packet;
                    break;
                }
                case 1: {
                    if (this.position == 0) {
                        int lengthBlock = 8 * (this.packet_length / 8 + 1);
                        this.block = new byte[lengthBlock];
                    }
                    this.block[this.position] = b;
                    if (++this.position < this.block.length) break;
                    if (count > boffset) {
                        this.toBeFinished = true;
                        this.unfinishedBuffer = buff;
                        this.positionInUnfinishedBuffer = boffset;
                    } else {
                        this.toBeFinished = false;
                    }
                    this.position = 0;
                    this.phase_packet = 0;
                    if (encryption) {
                        crypto.decrypt(this.block);
                    }
                    this.decryptedBlock = this.block;
                    this.setPacketFromDecryptedBlock();
                    if (!this.checkCrc()) {
                        System.err.println("SshPacket: Crc Error !!");
                        return null;
                    }
                    return this;
                }
            }
        }
        this.toBeFinished = false;
        return null;
    }

    public byte getType() throws IOException {
        return this.packet_type;
    }

    private void setBlock() throws IOException {
        int i;
        this.block = new byte[this.packet_length + this.padding.length];
        int blockOffset = 0;
        int i2 = 0;
        while (i2 < this.padding.length) {
            this.block[blockOffset++] = this.padding[i2];
            ++i2;
        }
        this.block[blockOffset++] = this.packet_type;
        if (this.packet_length > 5) {
            i = 0;
            while (i < this.data.length) {
                this.block[blockOffset++] = this.data[i];
                ++i;
            }
        }
        i = 0;
        while (i < this.crc_array.length) {
            this.block[blockOffset++] = this.crc_array[i];
            ++i;
        }
    }

    private void setPacketFromDecryptedBlock() throws IOException {
        int i;
        int blockOffset = 0;
        int padding_length = 8 - this.packet_length % 8;
        this.padding = new byte[padding_length];
        if (this.decryptedBlock.length != padding_length + this.packet_length) {
            System.out.println("???");
        }
        int i2 = 0;
        while (i2 < this.padding.length) {
            this.padding[i2] = this.decryptedBlock[blockOffset++];
            ++i2;
        }
        this.packet_type = this.decryptedBlock[blockOffset++];
        if (this.packet_length > 5) {
            this.data = new byte[this.packet_length - 5];
            i = 0;
            while (i < this.data.length) {
                this.data[i] = this.decryptedBlock[blockOffset++];
                ++i;
            }
        } else {
            this.data = null;
        }
        i = 0;
        while (i < this.crc_array.length) {
            this.crc_array[i] = this.decryptedBlock[blockOffset++];
            ++i;
        }
    }
}

