/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import cryptix.crypt.MD5;
import de.mud.ssh.SshCrypto;
import de.mud.ssh.SshMisc;
import de.mud.ssh.SshPacket;
import java.io.IOException;
import java.util.Date;

public abstract class SshIO {
    private String identification_string = "";
    private String identification_string_sent = "SSH-1.5-Java Ssh 1.1 (16/09/99) leo@mud.de, original by Cedric Gourio (javassh@france-mail.com)\r";
    private static int debug = 0;
    private boolean encryption = false;
    private SshCrypto crypto;
    SshPacket lastPacketReceived;
    boolean ScreenUpdateForEachPacket = false;
    private String login;
    private String password;
    public String dataToSend = null;
    public String hashHostKey = null;
    byte lastPacketSentType;
    private int phase = 0;
    private final int PHASE_INIT = 0;
    private final int PHASE_SSH_RECEIVE_PACKET = 1;
    private final int SSH_MSG_DISCONNECT = 1;
    private final int SSH_SMSG_PUBLIC_KEY = 2;
    private final int SSH_CMSG_SESSION_KEY = 3;
    private final int SSH_CMSG_USER = 4;
    private final int SSH_CMSG_AUTH_PASSWORD = 9;
    private final int SSH_CMSG_REQUEST_PTY = 10;
    private final int SSH_CMSG_EXEC_SHELL = 12;
    private final int SSH_SMSG_SUCCESS = 14;
    private final int SSH_SMSG_FAILURE = 15;
    private final int SSH_CMSG_STDIN_DATA = 16;
    private final int SSH_SMSG_STDOUT_DATA = 17;
    private final int SSH_SMSG_STDERR_DATA = 18;
    private final int SSH_SMSG_EXITSTATUS = 20;
    private final int SSH_CMSG_EXIT_CONFIRMATION = 33;
    private int position = 0;
    private int SSH_CIPHER_NONE = 0;
    private int SSH_CIPHER_IDEA = 1;
    private int SSH_CIPHER_DES = 2;
    private int SSH_CIPHER_3DES = 3;
    private int SSH_CIPHER_TSS = 4;
    private int SSH_CIPHER_RC4 = 5;
    private final int SSH_AUTH_RHOSTS = 1;
    private final int SSH_AUTH_RSA = 2;
    private final int SSH_AUTH_PASSWORD = 3;
    private final int SSH_AUTH_RHOSTS_RSA = 4;
    byte[] one = new byte[1];

    public SshIO() {
        SshPacket.encryption = false;
    }

    private byte[] Send_SSH_CMSG_AUTH_PASSWORD() throws IOException {
        byte[] data = SshMisc.createString(this.password);
        byte packet_type = 9;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        return null;
    }

    private byte[] Send_SSH_CMSG_EXEC_SHELL() throws IOException {
        byte[] data = null;
        byte packet_type = 12;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        this.lastPacketSentType = packet_type;
        return null;
    }

    private byte[] Send_SSH_CMSG_EXIT_CONFIRMATION() throws IOException {
        byte packet_type = 33;
        SshPacket packet = this.createPacket(packet_type, null);
        this.sendPacket(packet);
        return null;
    }

    private byte[] Send_SSH_CMSG_REQUEST_PTY() throws IOException {
        byte[] termType = SshMisc.createString("dumb");
        byte[] row = new byte[4];
        row[3] = 24;
        byte[] col = new byte[4];
        col[3] = 80;
        byte[] XPixels = new byte[4];
        byte[] YPixels = new byte[4];
        byte[] terminalModes = new byte[]{0};
        byte[] data = new byte[termType.length + 16 + terminalModes.length];
        int offset = 0;
        int i = 0;
        while (i < termType.length) {
            data[offset++] = termType[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            data[offset++] = row[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < 4) {
            data[offset++] = col[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < 4) {
            data[offset++] = XPixels[i4];
            ++i4;
        }
        int i5 = 0;
        while (i5 < 4) {
            data[offset++] = YPixels[i5];
            ++i5;
        }
        int i6 = 0;
        while (i6 < terminalModes.length) {
            data[offset++] = terminalModes[i6];
            ++i6;
        }
        byte packet_type = 10;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        return null;
    }

    private byte[] Send_SSH_CMSG_SESSION_KEY(byte[] anti_spoofing_cookie, byte[] server_key_public_modulus, byte[] host_key_public_modulus, byte[] supported_ciphers_mask, byte[] server_key_public_exponent, byte[] host_key_public_exponent) throws IOException {
        String session_id = new String(host_key_public_modulus);
        session_id = String.valueOf(session_id) + new String(server_key_public_modulus);
        session_id = String.valueOf(session_id) + new String(anti_spoofing_cookie);
        byte[] hash_md5 = MD5.hash((String)session_id);
        byte[] session_id_byte = session_id.getBytes();
        byte cipher_type = (byte)this.SSH_CIPHER_IDEA;
        if ((1 << cipher_type & 0xFF & supported_ciphers_mask[3]) == 0) {
            System.err.println("SshIO: encryption method not supported\n");
            this.disconnect();
            return "\rencryption method not supported !!\r\n".getBytes();
        }
        byte[] random_bits1 = new byte[16];
        byte[] random_bits2 = new byte[16];
        Date date = new Date();
        random_bits1 = MD5.hash((String)String.valueOf(Math.random() * (double)new Date().getDate()));
        random_bits2 = random_bits1;
        random_bits1 = MD5.hash((byte[])SshMisc.addArrayOfBytes(MD5.hash((String)(String.valueOf(this.password) + this.login)), random_bits1));
        random_bits2 = MD5.hash((byte[])SshMisc.addArrayOfBytes(MD5.hash((String)(String.valueOf(this.password) + this.login)), random_bits2));
        byte[] session_key = SshMisc.addArrayOfBytes(random_bits1, random_bits2);
        byte[] session_keyXored = SshMisc.XORArrayOfBytes(random_bits1, hash_md5);
        session_keyXored = SshMisc.addArrayOfBytes(session_keyXored, session_keyXored);
        byte[] encrypted_session_key = SshCrypto.encrypteRSAPkcs1Twice(session_keyXored, server_key_public_exponent, server_key_public_modulus, host_key_public_exponent, host_key_public_modulus);
        byte[] protocol_flags = new byte[4];
        protocol_flags[3] = 0;
        protocol_flags[2] = 0;
        protocol_flags[1] = 0;
        protocol_flags[0] = 0;
        int length = 1 + anti_spoofing_cookie.length + encrypted_session_key.length + protocol_flags.length;
        byte[] data = new byte[length];
        int boffset = 0;
        data[boffset++] = cipher_type;
        int i = 0;
        while (i < 8) {
            data[boffset++] = anti_spoofing_cookie[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < encrypted_session_key.length) {
            data[boffset++] = encrypted_session_key[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < 4) {
            data[boffset++] = protocol_flags[i3];
            ++i3;
        }
        byte packet_type = 3;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        if (cipher_type == (byte)this.SSH_CIPHER_IDEA) {
            byte[] IDEAKey = new byte[16];
            int i4 = 0;
            while (i4 < 16) {
                IDEAKey[i4] = session_key[i4];
                ++i4;
            }
            this.crypto = new SshCrypto(IDEAKey);
            SshPacket.encryption = this.encryption = true;
            SshPacket.crypto = this.crypto;
        }
        return null;
    }

    private byte[] Send_SSH_CMSG_STDIN_DATA(String str) throws IOException {
        byte[] data = SshMisc.createString(str);
        byte packet_type = 16;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        return null;
    }

    private byte[] Send_SSH_CMSG_USER() throws IOException {
        byte[] data = SshMisc.createString(this.login);
        byte packet_type = 4;
        SshPacket packet = this.createPacket(packet_type, data);
        this.sendPacket(packet);
        return null;
    }

    private SshPacket createPacket(byte newType, byte[] newData) throws IOException {
        return new SshPacket(newType, newData);
    }

    public void disconnect() {
        System.out.println("ssh: disconnect");
    }

    private SshPacket handleBytes(byte[] buff, int offset, int count) throws IOException {
        if (debug > 1) {
            System.out.println("SshIO.getPacket(" + buff + "," + count + ")");
        }
        int boffset = offset;
        while (boffset < count) {
            byte b = buff[boffset++];
            switch (this.phase) {
                case 0: {
                    this.identification_string = String.valueOf(this.identification_string) + (char)b;
                    if (b != 10) break;
                    ++this.phase;
                    this.write(this.identification_string_sent.getBytes());
                    this.position = 0;
                    byte[] data = SshMisc.createString(this.identification_string_sent);
                    byte packet_type = 17;
                    SshPacket fistLine = this.createPacket(packet_type, data);
                    return fistLine;
                }
                case 1: {
                    SshPacket result = this.lastPacketReceived.getPacketfromBytes(buff, boffset - 1, count);
                    return result;
                }
            }
        }
        return null;
    }

    private byte[] handlePacket(byte packetType, byte[] packetData) throws IOException {
        int boffset = 0;
        if (debug > 0) {
            System.out.println("1 packet to handle");
        }
        switch (packetType) {
            case 1: {
                String str = SshMisc.getString(boffset, packetData);
                this.disconnect();
                return str.getBytes();
            }
            case 2: {
                byte[] anti_spoofing_cookie = new byte[8];
                byte[] server_key_bits = new byte[4];
                byte[] host_key_bits = new byte[4];
                byte[] protocol_flags = new byte[4];
                byte[] supported_ciphers_mask = new byte[4];
                byte[] supported_authentications_mask = new byte[4];
                int i = 0;
                while (i <= 7) {
                    anti_spoofing_cookie[i] = packetData[boffset++];
                    ++i;
                }
                i = 0;
                while (i <= 3) {
                    server_key_bits[i] = packetData[boffset++];
                    ++i;
                }
                byte[] server_key_public_exponent = SshMisc.getMpInt(boffset, packetData);
                byte[] server_key_public_modulus = SshMisc.getMpInt(boffset += server_key_public_exponent.length + 2, packetData);
                boffset += server_key_public_modulus.length + 2;
                i = 0;
                while (i <= 3) {
                    host_key_bits[i] = packetData[boffset++];
                    ++i;
                }
                byte[] host_key_public_exponent = SshMisc.getMpInt(boffset, packetData);
                byte[] host_key_public_modulus = SshMisc.getMpInt(boffset += host_key_public_exponent.length + 2, packetData);
                boffset += host_key_public_modulus.length + 2;
                i = 0;
                while (i < 4) {
                    protocol_flags[i] = packetData[boffset++];
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    supported_ciphers_mask[i] = packetData[boffset++];
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    supported_authentications_mask[i] = packetData[boffset++];
                    ++i;
                }
                this.Send_SSH_CMSG_SESSION_KEY(anti_spoofing_cookie, server_key_public_modulus, host_key_public_modulus, supported_ciphers_mask, server_key_public_exponent, host_key_public_exponent);
                if (this.hashHostKey == null || this.hashHostKey.compareTo("") == 0) break;
                byte[] Md5_hostKey = MD5.hash((byte[])host_key_public_modulus);
                String hashHostKeyBis = "";
                int i2 = 0;
                while (i2 < Md5_hostKey.length) {
                    String hex = "";
                    int[] v = new int[]{(Md5_hostKey[i2] & 0xF0) >> 4, Md5_hostKey[i2] & 0xF};
                    int j = 0;
                    while (j < 1) {
                        switch (v[j]) {
                            case 10: {
                                hex = String.valueOf(hex) + "a";
                                break;
                            }
                            case 11: {
                                hex = String.valueOf(hex) + "b";
                                break;
                            }
                            case 12: {
                                hex = String.valueOf(hex) + "c";
                                break;
                            }
                            case 13: {
                                hex = String.valueOf(hex) + "d";
                                break;
                            }
                            case 14: {
                                hex = String.valueOf(hex) + "e";
                                break;
                            }
                            case 15: {
                                hex = String.valueOf(hex) + "f";
                                break;
                            }
                            default: {
                                hex = String.valueOf(hex) + String.valueOf(v[j]);
                                break;
                            }
                        }
                        ++j;
                    }
                    hashHostKeyBis = String.valueOf(hashHostKeyBis) + hex;
                    ++i2;
                }
                if (hashHostKeyBis.compareTo(this.hashHostKey) == 0) break;
                this.password = "";
                this.login = "";
                return "\nHash value of the host key not correct \r\nlogin & password have been reset \r\n- erase the 'hashHostKey' parameter in the Html\r\n(it is used for auhentificating the server and prevent you from connecting \r\nto any other)\r\n".getBytes();
            }
            case 14: {
                if (this.lastPacketSentType == 3) {
                    this.Send_SSH_CMSG_USER();
                    break;
                }
                if (this.lastPacketSentType == 9) {
                    System.out.println("login succesful");
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "\nLogin & password accepted\r\n".getBytes();
                }
                if (this.lastPacketSentType != 10) break;
                this.Send_SSH_CMSG_EXEC_SHELL();
                break;
            }
            case 15: {
                if (this.lastPacketSentType == 9) {
                    System.out.println("failed to log in");
                    return "\nLogin & password not accepted\r\n".getBytes();
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_AUTH_PASSWORD();
                    break;
                }
                if (this.lastPacketSentType != 10) break;
                break;
            }
            case 17: {
                String str = SshMisc.getString(0, packetData);
                return str.getBytes();
            }
            case 18: {
                String str = "Error : " + SshMisc.getString(0, packetData);
                System.out.println("SshIO.handlePacket : STDERR_DATA " + str);
                break;
            }
            case 20: {
                int value = (packetData[0] << 24) + (packetData[1] << 16) + (packetData[2] << 8) + packetData[3];
                this.Send_SSH_CMSG_EXIT_CONFIRMATION();
                System.out.println("SshIO : Exit status " + value);
                this.disconnect();
                break;
            }
            default: {
                System.err.print("SshIO.handlePacket : Packet Type unknown\r\n");
            }
        }
        return null;
    }

    public synchronized byte[] handleSSH(byte[] b) throws IOException {
        byte[] rest = null;
        while (this.lastPacketReceived != null && this.lastPacketReceived.toBeFinished) {
            byte[] buff = this.lastPacketReceived.unfinishedBuffer;
            int start = this.lastPacketReceived.positionInUnfinishedBuffer;
            if (buff == null) continue;
            byte[] result = this.packetDone(this.handleBytes(buff, start, buff.length));
            if (rest != null) {
                if (result == null) continue;
                byte[] tmp = new byte[rest.length + result.length];
                System.arraycopy(rest, 0, tmp, 0, rest.length);
                System.arraycopy(result, 0, tmp, rest.length, result.length);
                rest = tmp;
                continue;
            }
            rest = result;
        }
        byte[] result = this.packetDone(this.handleBytes(b, 0, b.length));
        if (rest != null) {
            if (result != null) {
                byte[] cat = new byte[rest.length + result.length];
                System.arraycopy(rest, 0, cat, 0, rest.length);
                System.arraycopy(result, 0, cat, rest.length, result.length);
                return cat;
            }
            return rest;
        }
        return result;
    }

    private byte[] packetDone(SshPacket packet) throws IOException {
        if (packet == null) {
            return null;
        }
        this.lastPacketReceived = packet;
        byte[] result = this.handlePacket(this.lastPacketReceived.getType(), this.lastPacketReceived.getData());
        return result;
    }

    public synchronized void sendData(String str) throws IOException {
        if (debug > 1) {
            System.out.println("SshIO.send(" + str + ")");
        }
        this.dataToSend = this.dataToSend == null ? str : String.valueOf(this.dataToSend) + str;
        this.Send_SSH_CMSG_STDIN_DATA(str);
        this.dataToSend = null;
    }

    private void sendPacket(SshPacket packet) throws IOException {
        this.write(packet.getBytes());
        this.lastPacketSentType = packet.getType();
    }

    public void setLogin(String user) {
        this.login = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void write(byte b) throws IOException {
        this.one[0] = b;
        this.write(this.one);
    }

    protected abstract void write(byte[] var1) throws IOException;
}

