/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import cryptix.crypt.IDEA;
import de.mud.ssh.SshMisc;
import java.math.BigInteger;

class SshCrypto {
    private IDEA blockCipherIDEA;
    private byte[] IDEA_Vector_Receive = new byte[8];
    private byte[] IDEA_Vector_Send = new byte[8];

    public SshCrypto(byte[] key) {
        this.blockCipherIDEA = new IDEA(key);
    }

    public void decrypt(byte[] block) {
        int numberOfRound = block.length / 8;
        int offset = 0;
        byte[] blockOfHeight = new byte[8];
        int round = 0;
        while (round < numberOfRound) {
            int offsetBis = offset;
            this.blockCipherIDEA.encrypt(this.IDEA_Vector_Receive);
            byte[] next_IDEA_Vector = new byte[8];
            int i = 0;
            while (i < 8) {
                blockOfHeight[i] = next_IDEA_Vector[i] = block[offset++];
                ++i;
            }
            int i2 = 0;
            while (i2 < 8) {
                int int1 = this.IDEA_Vector_Receive[i2] & 0xFF;
                int int2 = blockOfHeight[i2] & 0xFF;
                blockOfHeight[i2] = (byte)((int1 ^ int2) & 0xFF);
                ++i2;
            }
            int i3 = 0;
            while (i3 < 8) {
                block[offsetBis++] = blockOfHeight[i3];
                ++i3;
            }
            this.IDEA_Vector_Receive = next_IDEA_Vector;
            ++round;
        }
    }

    public void encrypt(byte[] block) {
        int numberOfRound = block.length / 8;
        int offset = 0;
        byte[] blockOfHeight = new byte[8];
        int round = 0;
        while (round < numberOfRound) {
            int offsetBis = offset;
            int i = 0;
            while (i < 8) {
                blockOfHeight[i] = block[offset++];
                ++i;
            }
            this.blockCipherIDEA.encrypt(this.IDEA_Vector_Send);
            int i2 = 0;
            while (i2 < 8) {
                blockOfHeight[i2] = (byte)(blockOfHeight[i2] & 0xFF ^ this.IDEA_Vector_Send[i2] & 0xFF & 0xFF);
                ++i2;
            }
            int i3 = 0;
            while (i3 < 8) {
                this.IDEA_Vector_Send[i3] = blockOfHeight[i3];
                ++i3;
            }
            int i4 = 0;
            while (i4 < 8) {
                block[offsetBis++] = blockOfHeight[i4];
                ++i4;
            }
            ++round;
        }
    }

    public static byte[] encrypteRSAPkcs1Twice(byte[] clearData, byte[] server_key_public_exponent, byte[] server_key_public_modulus, byte[] host_key_public_exponent, byte[] host_key_public_modulus) {
        int offset = 0;
        byte[] EncryptionBlock = new byte[server_key_public_modulus.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        offset = 2;
        int i = 2;
        while (i < EncryptionBlock.length - clearData.length - 1) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
            ++i;
        }
        EncryptionBlock[offset++] = 0;
        int i2 = 0;
        while (i2 < clearData.length) {
            EncryptionBlock[offset++] = clearData[i2];
            ++i2;
        }
        BigInteger m = new BigInteger(1, server_key_public_modulus);
        BigInteger e = new BigInteger(1, server_key_public_exponent);
        BigInteger message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        byte[] messageByteTemp = message.toByteArray();
        byte[] messageByte = new byte[server_key_public_modulus.length];
        int tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        int i3 = messageByte.length - messageByteTemp.length + tempOffset;
        while (i3 < messageByte.length) {
            messageByte[i3] = messageByteTemp[tempOffset++];
            ++i3;
        }
        clearData = messageByte;
        offset = 0;
        EncryptionBlock = new byte[host_key_public_modulus.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        offset = 2;
        int i4 = 2;
        while (i4 < EncryptionBlock.length - clearData.length - 1) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
            ++i4;
        }
        EncryptionBlock[offset++] = 0;
        int i5 = 0;
        while (i5 < clearData.length) {
            EncryptionBlock[offset++] = clearData[i5];
            ++i5;
        }
        m = new BigInteger(1, host_key_public_modulus);
        e = new BigInteger(1, host_key_public_exponent);
        message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        messageByteTemp = message.toByteArray();
        messageByte = new byte[host_key_public_modulus.length];
        tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        int i6 = messageByte.length - messageByteTemp.length + tempOffset;
        while (i6 < messageByte.length) {
            messageByte[i6] = messageByteTemp[tempOffset++];
            ++i6;
        }
        byte[] encrypted_session_key = new byte[host_key_public_modulus.length + 2];
        encrypted_session_key[1] = (byte)(8 * host_key_public_modulus.length & 0xFF);
        encrypted_session_key[0] = (byte)(8 * host_key_public_modulus.length >> 8 & 0xFF);
        int i7 = 0;
        while (i7 < host_key_public_modulus.length) {
            encrypted_session_key[i7 + 2] = messageByte[i7];
            ++i7;
        }
        return encrypted_session_key;
    }
}

