/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.LocalEchoListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.TerminalTypeListener;
import de.mud.jta.event.WindowSizeListener;
import de.mud.terminal.vt320;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Terminal
extends Plugin
implements FilterPlugin,
VisualTransferPlugin,
ClipboardOwner,
Runnable {
    private static final int debug = 0;
    protected vt320 terminal;
    protected Panel tPanel;
    protected Menu menu = new Menu("Terminal");
    private Thread reader = null;
    protected FilterPlugin source;

    public Terminal(PluginBus bus) {
        super(bus);
        MenuItem item = new MenuItem("Smaller Font");
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Font font = Terminal.this.terminal.getFont();
                Terminal.this.terminal.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 1));
                if (Terminal.this.tPanel.getParent() != null) {
                    Container parent = Terminal.this.tPanel.getParent();
                    if (parent instanceof Frame) {
                        ((Frame)parent).pack();
                    }
                    Terminal.this.tPanel.getParent().doLayout();
                    Terminal.this.tPanel.getParent().validate();
                }
            }
        });
        item = new MenuItem("Larger Font");
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Font font = Terminal.this.terminal.getFont();
                Terminal.this.terminal.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 1));
                if (Terminal.this.tPanel.getParent() != null) {
                    Container parent = Terminal.this.tPanel.getParent();
                    if (parent instanceof Frame) {
                        ((Frame)parent).pack();
                    }
                    Terminal.this.tPanel.getParent().doLayout();
                    Terminal.this.tPanel.getParent().validate();
                }
            }
        });
        this.terminal = new vt320(){

            public void write(byte[] b) {
                try {
                    Terminal.this.write(b);
                }
                catch (IOException iOException) {
                    Terminal.this.reader = null;
                }
            }
        };
        this.tPanel = new Panel(new BorderLayout());
        this.tPanel.add("Center", this.terminal);
        bus.registerPluginListener(new OnlineStatusListener(){

            public void offline() {
                if (Terminal.this.reader != null) {
                    Terminal.this.reader = null;
                }
            }

            public void online() {
                if (Terminal.this.reader == null) {
                    Terminal.this.reader = new Thread(Terminal.this);
                    Terminal.this.reader.start();
                }
            }
        });
        bus.registerPluginListener(new TerminalTypeListener(){

            public String getTerminalType() {
                return Terminal.this.terminal.getTerminalID();
            }
        });
        bus.registerPluginListener(new WindowSizeListener(){

            public Dimension getWindowSize() {
                return Terminal.this.terminal.getScreenSize();
            }
        });
        bus.registerPluginListener(new LocalEchoListener(){

            public void setLocalEcho(boolean echo) {
                Terminal.this.terminal.setLocalEcho(echo);
            }
        });
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(Properties config) {
                Terminal.this.configure(config);
            }
        });
    }

    private void configure(Properties config) {
        Enumeration p = ((Hashtable)config).keys();
        while (p.hasMoreElements()) {
            String key = (String)p.nextElement();
            if (!key.startsWith("Terminal.")) continue;
            if (key.equals("Terminal.foreground")) {
                this.terminal.setForeground(Color.decode(config.getProperty(key)));
                continue;
            }
            if (key.equals("Terminal.background")) {
                this.terminal.setBackground(Color.decode(config.getProperty(key)));
                continue;
            }
            if (key.equals("Terminal.colorSet")) {
                System.out.println("Terminal.colorSet not implemented yet");
                continue;
            }
            if (key.equals("Terminal.borderRaised")) continue;
            if (key.equals("Terminal.border")) {
                boolean raised = false;
                if (((Hashtable)config).containsKey("Terminal.borderRaised")) {
                    raised = Boolean.valueOf("Terminal.borderRaised");
                }
                this.terminal.setBorder(Integer.parseInt(config.getProperty(key)), raised);
                continue;
            }
            if (key.equals("Terminal.scrollBar")) {
                String direction = config.getProperty(key);
                if (!direction.equals("East") && !direction.equals("West")) {
                    direction = "East";
                }
                Scrollbar scrollBar = new Scrollbar();
                this.tPanel.add(direction, scrollBar);
                this.terminal.setScrollbar(scrollBar);
                continue;
            }
            if (key.equals("Terminal.id")) {
                this.terminal.setTerminalID(config.getProperty(key));
                continue;
            }
            if (key.equals("Terminal.buffer")) {
                this.terminal.setBufferSize(Integer.parseInt(config.getProperty(key)));
                continue;
            }
            if (key.equals("Terminal.size")) {
                String size = config.getProperty(key);
                try {
                    int idx = size.indexOf(44);
                    int width = Integer.parseInt(size.substring(1, idx).trim());
                    int height = Integer.parseInt(size.substring(idx + 1, size.length() - 1).trim());
                    this.terminal.setScreenSize(width, height);
                }
                catch (Exception e) {
                    System.err.println("Terminal: screen size is wrong: " + size);
                    System.err.println("Terminal: " + e);
                }
                continue;
            }
            if (key.equals("Terminal.resize")) {
                String resize = config.getProperty("Terminal.resize");
                if (resize.equals("font")) {
                    this.terminal.setResizeStrategy(2);
                    continue;
                }
                if (resize.equals("screen")) {
                    this.terminal.setResizeStrategy(1);
                    continue;
                }
                this.terminal.setResizeStrategy(0);
                continue;
            }
            if (key.equals("Terminal.fontSize") || key.equals("Terminal.fontStyle")) continue;
            if (key.equals("Terminal.font")) {
                String fontStyle;
                int style = 0;
                int fsize = 12;
                if (((Hashtable)config).containsKey("Terminal.fontSize")) {
                    fsize = Integer.parseInt(config.getProperty("Terminal.fontSize"));
                }
                if ((fontStyle = config.getProperty("Terminal.fontStyle")) == null || fontStyle.equals("plain")) {
                    style = 0;
                } else if (fontStyle.equals("bold")) {
                    style = 1;
                } else if (fontStyle.equals("italic")) {
                    style = 2;
                } else if (fontStyle.equals("bold+italic")) {
                    style = 3;
                }
                this.terminal.setFont(new Font(config.getProperty(key), style, fsize));
                continue;
            }
            if (key.equals("Terminal.keyCodes")) {
                Properties keyCodes = new Properties();
                String file = config.getProperty(key);
                URL keyCodeURL = this.getClass().getResource(file);
                if (keyCodeURL == null) {
                    try {
                        keyCodeURL = new URL(config.getProperty(key));
                    }
                    catch (Exception e) {
                        System.err.println("Terminal: " + e);
                    }
                }
                if (keyCodeURL != null) {
                    try {
                        keyCodes.load(keyCodeURL.openStream());
                        this.terminal.setKeyCodes(keyCodes);
                    }
                    catch (IOException e) {
                        System.err.println("Terminal: cannot load keyCodes: " + e);
                    }
                    continue;
                }
                System.err.println("Terminal: could not load " + file);
                continue;
            }
            if (key.equals("Terminal.VMS")) {
                this.terminal.setVMS(Boolean.valueOf(config.getProperty(key)));
                continue;
            }
            if (key.equals("Terminal.IBM")) {
                this.terminal.setIBMCharset(Boolean.valueOf(config.getProperty(key)));
                continue;
            }
            System.err.println("Error: '" + key + "' is not a Terminal property");
        }
    }

    public void copy(Clipboard clipboard) {
        StringSelection selection = new StringSelection(this.terminal.getSelection());
        clipboard.setContents(selection, this);
    }

    public Menu getPluginMenu() {
        return this.menu;
    }

    public Component getPluginVisual() {
        return this.tPanel;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.terminal.clearSelection();
    }

    public void paste(Clipboard clipboard) {
        if (clipboard == null) {
            return;
        }
        Transferable t = clipboard.getContents(this);
        try {
            byte[] buffer = ((String)t.getTransferData(DataFlavor.stringFlavor)).getBytes();
            try {
                this.write(buffer);
            }
            catch (IOException iOException) {
                this.reader = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int read(byte[] b) throws IOException {
        return this.source.read(b);
    }

    public void run() {
        byte[] b = new byte[256];
        int n = 0;
        while (n >= 0) {
            try {
                n = this.read(b);
                if (n <= 0) continue;
                this.terminal.putString(new String(b, 0, n));
            }
            catch (IOException iOException) {
                this.reader = null;
                break;
            }
        }
    }

    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    public void write(byte[] b) throws IOException {
        this.source.write(b);
    }
}

