/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.event.LocalEchoRequest;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.TerminalTypeRequest;
import de.mud.jta.event.WindowSizeRequest;
import de.mud.telnet.TelnetProtocolHandler;
import java.awt.Dimension;
import java.io.IOException;

public class Telnet
extends Plugin
implements FilterPlugin {
    protected FilterPlugin source;
    protected TelnetProtocolHandler handler;
    private static final int debug = 0;

    public Telnet(final PluginBus bus) {
        super(bus);
        this.handler = new TelnetProtocolHandler(){

            public String getTerminalType() {
                return (String)bus.broadcast(new TerminalTypeRequest());
            }

            public Dimension getWindowSize() {
                return (Dimension)bus.broadcast(new WindowSizeRequest());
            }

            public void setLocalEcho(boolean echo) {
                bus.broadcast(new LocalEchoRequest(echo));
            }

            public void write(byte[] b) throws IOException {
                source.write(b);
            }
        };
        bus.registerPluginListener(new OnlineStatusListener(){

            public void offline() {
                Telnet.this.handler.reset();
            }

            public void online() {
                Telnet.this.handler.reset();
            }
        });
    }

    public int read(byte[] b) throws IOException {
        int n = this.source.read(b);
        if (n > 0) {
            n = this.handler.negotiate(b, n);
        }
        return n;
    }

    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    public void write(byte[] b) throws IOException {
        this.source.write(b);
    }
}

