/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.event.ConfigurationListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Script
extends Plugin
implements FilterPlugin {
    private static final int debug = 0;
    protected FilterPlugin source;
    private int matchPos;
    private Vector script;
    private byte[] match;
    private boolean done = true;

    public Script(PluginBus bus) {
        super(bus);
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(Properties config) {
                Vector<String[]> script = new Vector<String[]>();
                if (((Hashtable)config).containsKey("Script.script")) {
                    String s = config.getProperty("Script.script");
                    if (s.charAt(0) == '@') {
                        System.out.println("Script.script: @file not implemented yet");
                    }
                    String[] pair = null;
                    int old = -1;
                    int idx = s.indexOf(124);
                    while (idx >= 0) {
                        if (pair == null) {
                            pair = new String[2];
                            pair[0] = s.substring(old + 1, idx);
                        } else {
                            pair[1] = String.valueOf(s.substring(old + 1, idx)) + "\n";
                            script.addElement(pair);
                            pair = null;
                        }
                        old = idx;
                        idx = s.indexOf(124, old + 1);
                    }
                    if (pair != null) {
                        pair[1] = String.valueOf(s.substring(old + 1)) + "\n";
                        script.addElement(pair);
                    } else {
                        System.err.println("Script: unmatched pairs of script elements");
                    }
                    Script.this.setup(script);
                }
            }
        });
    }

    private byte[] found() {
        byte[] answer = ((String[])this.script.firstElement())[1].getBytes();
        this.script.removeElementAt(0);
        if (!this.script.isEmpty()) {
            this.match = ((String[])this.script.firstElement())[0].getBytes();
            this.reset();
        } else {
            this.done = true;
        }
        return answer;
    }

    private void match(byte[] s, int length) throws IOException {
        int i = 0;
        while (!this.done && i < length) {
            if (s[i] == this.match[this.matchPos] && ++this.matchPos >= this.match.length) {
                this.write(this.found());
            }
            ++i;
        }
    }

    public int read(byte[] b) throws IOException {
        int n = this.source.read(b);
        if (n > 0) {
            this.match(b, n);
        }
        return n;
    }

    private void reset() {
        this.matchPos = 0;
    }

    public void setFilterSource(FilterPlugin plugin) {
        this.source = plugin;
    }

    private void setup(Vector script) {
        this.script = script;
        this.match = ((String[])this.script.firstElement())[0].getBytes();
        this.reset();
        this.done = false;
    }

    public void write(byte[] b) throws IOException {
        this.source.write(b);
    }
}

