/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.event.LocalEchoRequest;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.TerminalTypeRequest;
import de.mud.jta.event.WindowSizeRequest;
import de.mud.ssh.SshIO;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

public class SSH
extends Plugin
implements FilterPlugin {
    protected FilterPlugin source;
    protected SshIO handler;
    private static final int debug = 0;
    private boolean auth = false;
    private byte[] buffer;
    private int pos;

    public SSH(final PluginBus bus) {
        super(bus);
        this.handler = new SshIO(){

            public String getTerminalType() {
                return (String)bus.broadcast(new TerminalTypeRequest());
            }

            public Dimension getWindowSize() {
                return (Dimension)bus.broadcast(new WindowSizeRequest());
            }

            public void setLocalEcho(boolean echo) {
                bus.broadcast(new LocalEchoRequest(echo));
            }

            public void write(byte[] b) throws IOException {
                source.write(b);
            }
        };
        bus.registerPluginListener(new OnlineStatusListener(){

            public void offline() {
            }

            public void online() {
                Frame frame = new Frame("SSH User Authentication");
                Panel panel = new Panel(new GridLayout(3, 1));
                panel.add(new Label("SSH Authorization required"));
                panel.add(new Label("SSH implementation 1998 by Cedric Gourio"));
                panel.add(new Label("Adapted 1999 to the JTA by Matthias L. Jugel"));
                frame.add("North", panel);
                panel = new Panel(new GridLayout(2, 2));
                TextField login = new TextField(10);
                TextField passw = new TextField(10);
                login.addActionListener(new ActionListener(passw){
                    private final /* synthetic */ TextField val$passw;
                    {
                        this.val$passw = val$passw;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        this.val$passw.requestFocus();
                    }
                });
                passw.setEchoChar('*');
                panel.add(new Label("User name"));
                panel.add(login);
                panel.add(new Label("Password"));
                panel.add(passw);
                frame.add("Center", panel);
                panel = new Panel();
                Button cancel = new Button("Cancel");
                Button ok = new Button("Login");
                ActionListener enter = new ActionListener(frame, login, passw, SSH.this){
                    private final /* synthetic */ Frame val$frame;
                    private final /* synthetic */ TextField val$passw;
                    private final /* synthetic */ TextField val$login;
                    private final /* synthetic */ SSH this$0;
                    {
                        this.val$frame = val$frame;
                        this.val$login = val$login;
                        this.val$passw = val$passw;
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        this.this$0.handler.setLogin(this.val$login.getText());
                        this.this$0.handler.setPassword(this.val$passw.getText());
                        this.val$frame.dispose();
                        SSH.access$1(this.this$0, true);
                    }
                };
                ok.addActionListener(enter);
                passw.addActionListener(enter);
                cancel.addActionListener(new ActionListener(frame){
                    private final /* synthetic */ Frame val$frame;
                    {
                        this.val$frame = val$frame;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        this.val$frame.dispose();
                    }
                });
                panel.add(cancel);
                panel.add(ok);
                frame.add("South", panel);
                frame.pack();
                frame.show();
            }
        });
    }

    static /* synthetic */ boolean access$0(SSH $0) {
        return $0.auth;
    }

    static /* synthetic */ void access$1(SSH $0, boolean $1) {
        $0.auth = $1;
    }

    public int read(byte[] b) throws IOException {
        while (!this.auth) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.buffer != null) {
            int amount = this.buffer.length - this.pos <= b.length ? this.buffer.length - this.pos : b.length;
            System.arraycopy(this.buffer, this.pos, b, 0, amount);
            if (this.pos + amount < this.buffer.length) {
                this.pos += amount;
            } else {
                this.buffer = null;
            }
            return amount;
        }
        int n = this.source.read(b);
        if (n > 0) {
            byte[] tmp = new byte[n];
            System.arraycopy(b, 0, tmp, 0, n);
            this.buffer = this.handler.handleSSH(tmp);
            if (this.buffer != null && this.buffer.length > 0) {
                int amount = this.buffer.length <= b.length ? this.buffer.length : b.length;
                System.arraycopy(this.buffer, 0, b, 0, amount);
                this.pos = n = amount;
                if (amount == this.buffer.length) {
                    this.buffer = null;
                    this.pos = 0;
                }
            } else {
                return 0;
            }
        }
        return n;
    }

    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    public void write(byte[] b) throws IOException {
        if (!this.auth) {
            return;
        }
        this.handler.sendData(new String(b));
    }
}

