/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Common;
import de.mud.jta.Plugin;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.SocketRequest;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Main {
    private static Plugin focussedPlugin;
    private static Clipboard clipboard;

    public static void main(String[] args) {
        Properties options = new Properties();
        try {
            options.load(options.getClass().getResourceAsStream("/de/mud/jta/defaults.opt"));
        }
        catch (IOException iOException) {
            System.err.println("jta: cannot load defaults");
        }
        String error = Main.parseOptions(options, args);
        if (error != null) {
            System.err.println(error);
            System.err.println("usage: de.mud.jta.Main [-plugins pluginlist] [-addplugin plugin] [-term id] [host [port]]");
            System.exit(0);
        }
        final String host = options.getProperty("Socket.host");
        final String port = options.getProperty("Socket.port");
        final Frame frame = new Frame("jta: " + host + (port.equals("23") ? "" : " " + port));
        try {
            clipboard = frame.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            System.err.println("jta: system clipboard access denied");
            System.err.println("jta: copy & paste only within the JTA");
            clipboard = new Clipboard("de.mud.jta.Main");
        }
        final Common setup = new Common(options);
        setup.registerPluginListener(new OnlineStatusListener(){

            public void offline() {
                frame.setTitle("jta: offline");
            }

            public void online() {
                frame.setTitle("jta: " + host + (port.equals("23") ? "" : " " + port));
            }
        });
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                Component c = e.getComponent();
                Hashtable components = setup.getComponents();
                Enumeration ce = components.keys();
                while (ce.hasMoreElements()) {
                    String key = (String)ce.nextElement();
                    if (c != components.get(key)) continue;
                    focussedPlugin = (Plugin)setup.getPlugins().get(key);
                    return;
                }
            }

            public void focusLost(FocusEvent e) {
            }
        };
        Hashtable componentList = setup.getComponents();
        Enumeration names = componentList.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Component c = (Component)componentList.get(name);
            c.addFocusListener(focusListener);
            c.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent evt) {
                    evt.getComponent().requestFocus();
                }
            });
            if (options.getProperty("layout." + name) == null) {
                System.err.println("jta: no layout property set for '" + name + "'");
                frame.add("South", c);
                continue;
            }
            frame.add(options.getProperty("layout." + name), c);
        }
        MenuBar mb = new MenuBar();
        Menu file = new Menu("File");
        file.setShortcut(new MenuShortcut(72, true));
        MenuItem tmp = new MenuItem("Connect");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                setup.broadcast(new SocketRequest(host, Integer.parseInt(port)));
            }
        });
        tmp = new MenuItem("Disconnect");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                setup.broadcast(new SocketRequest());
            }
        });
        file.add(new MenuItem("-"));
        tmp = new MenuItem("Exit");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frame.dispose();
                System.exit(0);
            }
        });
        mb.add(file);
        Menu edit = new Menu("Edit");
        edit.setShortcut(new MenuShortcut(72, true));
        tmp = new MenuItem("Copy");
        edit.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)focussedPlugin)).copy(clipboard);
                }
            }
        });
        tmp = new MenuItem("Paste");
        edit.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)focussedPlugin)).paste(clipboard);
                }
            }
        });
        mb.add(edit);
        Hashtable menuList = setup.getMenus();
        names = menuList.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            mb.add((Menu)menuList.get(name));
        }
        Menu help = new Menu("Help");
        tmp = new MenuItem("About");
        help.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Dialog d = new Dialog(frame, "About JTA", true);
                d.add("Center", new Label("Copyright (c) 1996-1999 Matthias L Jugel, Marcus Mei\u00dfner"));
                Button close = new Button("Close");
                close.addActionListener(new ActionListener(d){
                    private final /* synthetic */ Dialog val$d;
                    {
                        this.val$d = val$d;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        this.val$d.dispose();
                    }
                });
                d.add("South", close);
                d.setResizable(false);
                d.pack();
                d.show();
            }
        });
        mb.setHelpMenu(help);
        frame.setMenuBar(mb);
        frame.pack();
        frame.show();
        setup.broadcast(new SocketRequest(host, Integer.parseInt(port)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parseOptions(Properties options, String[] args) {
        boolean host = false;
        boolean port = false;
        int n = 0;
        while (n < args.length) {
            if (args[n].equals("-plugins")) {
                if (args[n + 1].startsWith("-")) return "missing parameter for -plugins";
                ((Hashtable)options).put("plugins", args[++n]);
            } else if (args[n].equals("-addplugin")) {
                if (args[n + 1].startsWith("-")) return "missing parameter for -addplugin";
                ((Hashtable)options).put("plugins", String.valueOf(args[++n]) + "," + ((Hashtable)options).get("plugins"));
            } else if (args[n].equals("-term")) {
                if (args[n + 1].startsWith("-")) return "missing parameter for -term";
                ((Hashtable)options).put("Terminal.id", args[++n]);
            } else if (!host) {
                ((Hashtable)options).put("Socket.host", args[n]);
                host = true;
            } else {
                if (!host || port) return "unknown parameter '" + args[n] + "'";
                ((Hashtable)options).put("Socket.port", args[n]);
                port = true;
            }
            ++n;
        }
        return null;
    }
}

