/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Common;
import de.mud.jta.event.SocketRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Applet
extends java.applet.Applet {
    private Properties options = new Properties();
    private Common pluginLoader;
    private String host;
    private String port;

    public void init() {
        if (this.pluginLoader == null) {
            try {
                this.options.load(this.getClass().getResourceAsStream("/de/mud/jta/defaults.opt"));
            }
            catch (Exception exception) {
                System.err.println("jta: cannot load defaults from classpath");
                System.err.println("-- This may be due to a security restriction in\n-- Netscape. Trying to load alternative ...");
                try {
                    URL url = new URL(String.valueOf(String.valueOf(this.getCodeBase())) + "defaults.opt");
                    System.err.println("-- loading " + url);
                    this.options.load(url.openStream());
                }
                catch (Exception exception2) {
                    System.err.println("jta: alternative defaults file not found");
                }
            }
            String value = this.getParameter("config");
            if (value != null) {
                Properties appletParams = new Properties();
                try {
                    appletParams.load(new URL(String.valueOf(String.valueOf(this.getCodeBase())) + value).openStream());
                    Enumeration ape = ((Hashtable)appletParams).keys();
                    while (ape.hasMoreElements()) {
                        String key = (String)ape.nextElement();
                        ((Hashtable)this.options).put(key, appletParams.getProperty(key));
                    }
                }
                catch (Exception e) {
                    System.err.println("jta: could not load config file: " + e);
                }
            }
            if ((value = this.getParameter("plugins")) != null) {
                System.err.println("jta: 'plugins' is deprecated, use config!");
                ((Hashtable)this.options).put("plugins", value);
            }
            if ((value = this.getParameter("port")) != null) {
                System.err.println("jta: 'Socket.port' is deprecated, use config!");
                ((Hashtable)this.options).put("Socket.port", value);
            }
            if ((value = this.getParameter("layout")) != null) {
                System.err.println("jta: 'layout' is deprecated, use config!");
                ((Hashtable)this.options).put("layout", value);
            }
            ((Hashtable)this.options).put("Terminal.resize", "font");
            this.pluginLoader = new Common(this.options);
            this.host = this.getCodeBase().getHost();
            this.port = this.options.getProperty("Socket.port");
            if (this.port == null) {
                this.port = "23";
            }
            this.setLayout(new BorderLayout());
            Hashtable componentList = this.pluginLoader.getComponents();
            Enumeration names = componentList.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Component c = (Component)componentList.get(name);
                if (this.getParameter("layout." + name) != null) {
                    System.err.println("jta: 'layout.*' is deprecated use config!");
                }
                if ((value = this.getParameter("layout." + name)) != null || (value = this.options.getProperty("layout." + name)) != null) {
                    this.add(value, c);
                    continue;
                }
                System.err.println("jta: no layout property set for '" + name + "'");
                System.err.println("jta: ignoring '" + name + "'");
            }
        }
    }

    public void start() {
        this.getAppletContext().showStatus("Trying " + this.host + " " + this.port + " ...");
        this.pluginLoader.broadcast(new SocketRequest(this.host, Integer.parseInt(this.port)));
    }

    public void stop() {
        this.pluginLoader.broadcast(new SocketRequest());
    }
}

