unit LibsNT;

interface

Uses Windows, Classes, SysUtils, unitNTException;

//20000624: added PWin32Char for D2 compatibility..
type
 PWin32Char = Pointer;

Type
  TACEHeader = Record
    ACEType  : Byte;
    ACEFlags : Byte;
    ACESize  : Word;
  End;

  TAccessAllowedACE = Record
    Header   : TACEHeader;
    Mask     : Integer;
    SIDStart : Integer;
  End;

  TAccessDeniedACE = Record
    Header   : TACEHeader;
    Mask     : Integer;
    SIDStart : Integer;
  End;

 PSomeChar = Pointer;
 PShare_Info_502 = ^TShare_Info_502;
 TShare_Info_502 = record
    shi502_netname:             PSomeChar;
    shi502_type:                DWORD;
    shi502_remark:              PSomeChar;
    shi502_permissions:         DWORD;
    shi502_max_uses:            DWORD;
    shi502_current_uses:        DWORD;
    shi502_path:                PSomeChar;
    shi502_passwd:              PSomeChar;
    shi502_reserved:            DWORD;
    shi502_security_descriptor: PSECURITY_DESCRIPTOR;
  End;

  TUserAccountType = (
    fltrDuplicate,        // Enumerates local user account data on a domain controller.
    fltrNormal,           // Enumerates global user account data on a computer.
    fltrProxy,            // ???
    fltrInterdomainTrust, // Enumerates domain trust account data on a domain controller.
    fltrWorkstationTrust, // Enumerates workstation or member server account data on a domain controller.
    fltrServerTrust       // Enumerates domain controller account data on a domain controller.
  );

  TUserAccountFilter = set of TUserAccountType;

  TUserPrivilege = (USR_PRIV_UNDEFINED, USR_PRIV_GUEST, USR_PRIV_USER, USR_PRIV_ADMIN);

  USER_INFO_20 = record
    usri20_name : PWideChar;
    usri20_full_name : PWideChar;
    usri20_comment : PWideChar;
    usri20_flags : Integer;
    usri20_user_id : Integer
  end;
  PUSER_INFO_20 = ^USER_INFO_20;
  PUSER_INFO_20_Arr = ^USER_INFO_20_Arr;
  USER_INFO_20_Arr = array[0..High(Integer) div SizeOf(USER_INFO_20) - 1] of USER_INFO_20;

  USER_INFO_3 = record
    usri3_name : PWideChar;
    usri3_password : PWideChar;
    usri3_password_age : DWORD;
    usri3_priv : DWORD;
    usri3_home_dir : PWideChar;
    usri3_comment : PWideChar;
    usri3_flags : DWORD;
    usri3_script_path : PWideChar;
    usri3_auth_flags : DWORD;
    usri3_full_name : PWideChar;
    usri3_usr_comment : PWideChar;
    usri3_parms : PWideChar;
    usri3_workstations : PWideChar;
    usri3_last_logon : DWORD;
    usri3_last_logoff : DWORD;
    usri3_acct_expires : DWORD;
    usri3_max_storage : DWORD;
    usri3_units_per_week : DWORD;
    usri3_logon_hours : PChar;
    usri3_bad_pw_count : DWORD;
    usri3_num_logons : DWORD;
    usri3_logon_server : PWideChar;
    usri3_country_code : DWORD;
    usri3_code_page : DWORD;
    usri3_user_id : DWORD;
    usri3_primary_group_id : DWORD;
    usri3_profile : PWideChar;
    usri3_home_dir_drive : PWideChar;
    usri3_password_expired : DWORD
  end;
  PUSER_INFO_3 = ^USER_INFO_3;

  LOCALGROUP_USERS_INFO_0 = record
    lgrui0_name : PWideChar
  end;
  PLOCALGROUP_USERS_INFO_0 = ^LOCALGROUP_USERS_INFO_0;
  PLOCALGROUP_USERS_INFO_0_Arr = ^LOCALGROUP_USERS_INFO_0_Arr;
  LOCALGROUP_USERS_INFO_0_Arr = array[0..High(Integer) div SizeOf(LOCALGROUP_USERS_INFO_0) - 1] of LOCALGROUP_USERS_INFO_0;

  GROUP_USERS_INFO_0 = record
    grpui0_name : PWideChar;
  end;
  PGROUP_USERS_INFO_0 = ^GROUP_USERS_INFO_0;
  PGROUP_USERS_INFO_0_Arr = ^GROUP_USERS_INFO_0_Arr;
  GROUP_USERS_INFO_0_Arr = array[0..High(Integer) div SizeOf(GROUP_USERS_INFO_0) - 1] of GROUP_USERS_INFO_0;

  LOCALGROUP_INFO_1 = record
    lgrpi1_name : PWideChar;
    lgrpi1_comment : PWideChar
  end;
  PLOCALGROUP_INFO_1 = ^LOCALGROUP_INFO_1;
  PLOCALGROUP_INFO_1_Arr = ^LOCALGROUP_INFO_1_Arr;
  LOCALGROUP_INFO_1_Arr = array[0..High(Integer) div SizeOf(LOCALGROUP_INFO_1) - 1] of LOCALGROUP_INFO_1;

  GROUP_INFO_2 = record
    grpi2_name : PWideChar;
    grpi2_comment : PWideChar;
    grpi2_group_id : Integer;
    grpi2_attributes : Integer
  end;
  PGROUP_INFO_2 = ^GROUP_INFO_2;
  PGROUP_INFO_2_Arr = ^GROUP_INFO_2_Arr;
  GROUP_INFO_2_Arr = array[0..High(Integer) div SizeOf(GROUP_INFO_2) - 1] of GROUP_INFO_2;

  LOCALGROUP_MEMBERS_INFO_0 = record
    lgrmi0_sid : PSID
  end;
  PLOCALGROUP_MEMBERS_INFO_0 = ^LOCALGROUP_MEMBERS_INFO_0;
  PLOCALGROUP_MEMBERS_INFO_0_Arr = ^LOCALGROUP_MEMBERS_INFO_0_Arr;
  LOCALGROUP_MEMBERS_INFO_0_Arr = array[0..High(Integer) div SizeOf(LOCALGROUP_MEMBERS_INFO_0) - 1] of LOCALGROUP_MEMBERS_INFO_0;

Const
  Access_Allowed_ACE_Type  = 0;
  Access_Denied_ACE_Type   = 1;

  FILTER_NORMAL_ACCOUNT    = $0002;
  NERR_Success           = 0;       // Success

  UNLEN       = 256;                 // Maximum user name length
  CNLEN       = 15;                  // Computer name length
  DNLEN       = CNLEN;               // Maximum domain name length

//
// Value to be used with APIs which have a "preferred maximum length"
// parameter.  This value indicates that the API should just allocate
// "as much as it takes."
//
  MAX_PREFERRED_LENGTH   = -1;

  function GetAccessRights(AM : Integer) : String;
  function GetPDCName(const DomainName : string): String;
  function StripDomain(str: String): String;
  function SubstNetbiosChar(str: String): String;
  procedure GetLevel3Info(ServerName, UserName: String; var fInfo : USER_INFO_3);
  procedure GetUsersList(ServerName: String; filter: DWORD; list : TStrings);
  procedure GetLocalGroups(ServerName, UserName: String; list : TStrings);
  procedure GetGlobalGroups(ServerName, UserName: String; list : TStrings);
  procedure GetLocalGroupsDetails (ServerName: String; list : TStrings);
  procedure GetGlobalGroupsDetails (ServerName: String; list : TStrings);
  procedure LocalGroupGetMembers(ServerName, GroupName: String; list : TStrings);
  procedure GlobalGroupGetMembers(ServerName, GroupName: String; list : TStrings);
  function CvntDWordToPrivilege(Val: DWord): TUserPrivilege;

Type
  NetAPIStatus = Integer;

function NetApiBufferFree(buffer : Pointer) : NetAPIStatus; stdcall;

function NetGetDCName (serverName, domainName : PWideChar; var buffer : Pointer) : NetAPIStatus; stdcall;

function NetUserGetInfo(ServerName, UserName : PWideChar;
                        level : Integer;
                        var buffer : Pointer) : NetAPIStatus; stdcall;

function NetUserEnum(ServerName : PWideChar;
                     level, filter : Integer;
                     var buffer : Pointer;
                     prefmaxlen : Integer;
                     var entriesRead, totalEntries, resumeHandle : Integer) : NetAPIStatus; stdcall;

function NetShareGetInfo(servername:  PSomeChar;
                         netname:  PSomeChar;
                         level: DWORD;
                         var buf: Pointer
                         ): NetAPIStatus;  stdcall;

function NetUserGetLocalGroups(ServerName, UserName : PWideChar;
                               level, flags : Integer;
                               var buffer : Pointer;
                               prefMaxLen : Integer;
                               var entriesRead, totalEntries : Integer) : NetAPIStatus; stdcall;

function NetUserGetGroups(ServerName, userName : PWideChar;
                          level : Integer;
                          var buffer : Pointer;
                          prefmaxlen : Integer;
                          var entriesRead, totalEntries : Integer) : NetAPIStatus; stdcall;

function NetLocalGroupEnum(ServerName : PWideChar;
                            level : Integer;
                            var buffer : Pointer;
                            prefMaxLen : Integer;
                            var entriesRead, totalEntries, resumeHandle : Integer) : NetAPIStatus; stdcall;

function NetGroupEnum(ServerName : PWideChar;
                      level : Integer;
                      var buffer : Pointer;
                      prefMaxLen : Integer;
                      var entriesRead, totalEntries, resumeHandle : Integer) : NetAPIStatus; stdcall;

function NetLocalGroupGetMembers (ServerName, LocalGroupName : PWideChar;
                                  level : Integer;
                                  var buffer : Pointer;
                                  prefMaxLen : Integer;
                                  var entriesRead, totalEntries, resumeHandle : Integer) : NetAPIStatus; stdcall;

function NetGroupGetUsers(ServerName, GroupName : PWideChar;
                          level : Integer;
                          var buffer : Pointer;
                          prefMaxLen : Integer;
                          var entriesRead, totalEntries, resumeHandle : Integer) : NetAPIStatus; stdcall;

implementation

var
  NIL_HANDLE : Integer absolute 0;

//Functions required from Windows API
function NetShareGetInfo;         external 'NETAPI32.DLL';
function NetUserEnum;             external 'NETAPI32.DLL';
function NetApiBufferFree;        external 'NETAPI32.dLL';
function NetGetDCName;            external 'NETAPI32.DLL';
function NetUserGetInfo;          external 'NETAPI32.DLL';
function NetUserGetLocalGroups;   external 'NETAPI32.DLL';
function NetUserGetGroups;        external 'NETAPI32.DLL';
function NetLocalGroupEnum;       external 'NETAPI32.DLL';
function NetGroupEnum;            external 'NETAPI32.DLL';
function NetLocalGroupGetMembers; external 'NETAPI32.DLL';
function NetGroupGetUsers;        external 'NETAPI32.DLL';
////////////////////////////////////////////////////////////////////////////////
function StripDomain(str: String): String;
////////////////////////////////////////////////////////////////////////////////
var
  iPos: Integer;
begin
  result := str;
  //Strip domain out ie.: \\MyDOMAIN\\USER
  if Pos('\', str) > 0 then
  begin
    for iPos := length(str) downto 1 do
      if str[iPos] = '\' then
        Break;
    if iPos > 1 then //= 1 does not make sense!
      result := Copy(str, iPos+1, length(str)-iPos);
  end;
end;
////////////////////////////////////////////////////////////////////////////////
function SubstNetbiosChar(str: String): String;
////////////////////////////////////////////////////////////////////////////////
var
  i: Integer;
begin
  result := str;
  for i := 1 to length(str) do
    Case result[i] of
      '','','','','','','': result[i] := 'a';
      '': result[i] := 'c';
      '','','','': result[i] := 'e';
      '','','','': result[i] := 'i';
      '': result[i] := 'd';
      '': result[i] := 'n';
      '','','','','','': result[i] := 'o';
      '','','','': result[i] := 'u';
      '': result[i] := 't';
      '','','','','','','': result[i] := 'A';
      '': result[i] := 'C';
      '','','','': result[i] := 'E';
      '','','','': result[i] := 'I';
      '': result[i] := 'D';
      '': result[i] := 'N';
      '','','','','','': result[i] := 'O';
      '','','','': result[i] := 'U';
      '': result[i] := 'Y';
      '': result[i] := 'T';
      '': result[i] := 'S';
      ' ','!','@','#','$','^','&','(',')','-','''','{','}','.','~' : result[i] := '_';
    end;//case
end;
////////////////////////////////////////////////////////////////////////////////
function WStrNew (s : PWideChar) : PWideChar;
//The function returns the copy of the string.                               |
////////////////////////////////////////////////////////////////////////////////
begin
  GetMem (result, (lstrlenW (s) + 1) * sizeof (WideChar));
  lstrcpyW (result, s);
end;
////////////////////////////////////////////////////////////////////////////////
function CvntDWordToPrivilege(Val: DWord): TUserPrivilege;
Const
  USER_PRIV_GUEST = 0;
  USER_PRIV_USER  = 1;
  USER_PRIV_ADMIN = 2;
begin
  case Val of
    USER_PRIV_GUEST: Result := USR_PRIV_GUEST;
    USER_PRIV_USER:  Result := USR_PRIV_USER;
    USER_PRIV_ADMIN: Result := USR_PRIV_ADMIN;
    else Result := USR_PRIV_UNDEFINED;
  end;
end;
////////////////////////////////////////////////////////////////////////////////
function GetAccessRights(AM : Integer) : String;
////////////////////////////////////////////////////////////////////////////////
Begin
  If ((AM And Standard_Rights_Read) <> 0) Then Result := 'R'
  Else Result := '-';
  If ((AM And Standard_Rights_Write) <> 0) Then Result := Result+'W'
  Else Result := Result+'-';
  If ((AM And Standard_Rights_Execute) <> 0) Then Result := Result+'X'
  Else Result := Result+'-';
  If ((AM And _Delete) <> 0) Then Result := Result+'D'
  Else Result := Result+'-';
  If ((AM And Write_DAC) <> 0) Then Result := Result+'P'
  Else Result := Result+'-';
  If ((AM And Write_Owner) <> 0) Then Result := Result+'O'
  Else Result := Result+'-';
End;
////////////////////////////////////////////////////////////////////////////////
function GetPDCName(const DomainName : string): String;
////////////////////////////////////////////////////////////////////////////////
var
  buffer : Pointer;
  rv : Integer;
  WCWin32ChDomainName: array[0..255] of WideChar;
  PWin32ChDomainName: Pointer;
begin
  result := '';
  buffer := nil;

  StringToWideChar(DomainName, @WCWin32ChDomainName, SizeOf(WCWin32ChDomainName));
  if DomainName = '' then
    PWin32ChDomainName := nil
  else
    PWin32ChDomainName := @WCWin32ChDomainName;

  rv := NetGetDCName(Nil, PWin32ChDomainName, buffer);

  if rv = NERR_Success then
    try
      Result := WideCharToString(buffer);
    finally
      if buffer <> nil then
        NetAPIBufferFree (buffer);
    end
  else
    raise ENTException.Create (rv);
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetLevel3Info(ServerName, UserName: String; var fInfo : USER_INFO_3);
////////////////////////////////////////////////////////////////////////////////
var
  buffer : pointer;
  rv : Integer;
  level: Integer;
  WCWin32ChUser, WCWin32ChServerName: array[0..255] of WideChar;
  PWin32ChServerName: Pointer;
begin
  level := 3;
  buffer := nil;
  //todo:  if UserName = '' then raise
  StringToWideChar(ServerName, @WCWin32ChServerName, SizeOf(WCWin32ChServerName));
  if ServerName = '' then
    PWin32ChServerName := nil
  else
    PWin32ChServerName := @WCWin32ChServerName;
  StringToWideChar(UserName, @WCWin32ChUser, SizeOf(WCWin32ChUser));

  rv := NetUserGetInfo(PWin32ChServerName, @WCWin32ChUser, level, buffer);
  if rv <> NErr_Success then
    raise ENTException.Create (rv);

  with PUSER_INFO_3(buffer)^ do
  try
    fInfo.usri3_password_age := usri3_password_age;
    fInfo.usri3_priv := usri3_priv;
    fInfo.usri3_home_dir := WStrNew (usri3_home_dir);
    fInfo.usri3_comment := WStrNew (usri3_comment);
    fInfo.usri3_flags := usri3_flags;
    fInfo.usri3_script_path := WStrNew (usri3_script_path);
    fInfo.usri3_auth_flags := usri3_auth_flags;
    fInfo.usri3_full_name := WStrNew (usri3_full_name);
    fInfo.usri3_usr_comment := WStrNew (usri3_usr_comment);
    fInfo.usri3_parms := WStrNew (usri3_parms);
    fInfo.usri3_workstations := WStrNew (usri3_workstations);
    fInfo.usri3_last_logon := usri3_last_logon;
    fInfo.usri3_last_logoff := usri3_last_logoff;
    fInfo.usri3_acct_expires := usri3_acct_expires;
    fInfo.usri3_max_storage := usri3_max_storage;
    fInfo.usri3_units_per_week := usri3_units_per_week;

    GetMem (fInfo.usri3_logon_hours, 21);
    Move (usri3_logon_hours^, fInfo.usri3_logon_hours^, 21);

    fInfo.usri3_bad_pw_count := usri3_bad_pw_count;
    fInfo.usri3_num_logons := usri3_num_logons;
    fInfo.usri3_logon_server := WStrNew (usri3_logon_server);
    fInfo.usri3_country_code := usri3_country_code;
    fInfo.usri3_code_page := usri3_code_page;
    fInfo.usri3_user_id := usri3_user_id;
    fInfo.usri3_primary_group_id := usri3_primary_group_id;
    fInfo.usri3_profile := WStrNew (usri3_profile);
    fInfo.usri3_home_dir_drive := WStrNew (usri3_home_dir_drive);
    fInfo.usri3_password_expired := usri3_password_expired;

  finally
    if buffer <> nil then
      NetAPIBufferFree (buffer);
  end
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetUsersList(ServerName: String; filter: DWORD; list : TStrings);
////////////////////////////////////////////////////////////////////////////////
var
  WCWin32ChServerName: array[0..255] of WideChar;
  PWin32ChServerName: Pointer;
  rv: NetAPIStatus;
  buffer: PUSER_INFO_20_Arr;
  i, entriesRead, totalEntries: Integer;
  st: string;
begin
  list.Clear;
  buffer := nil;
  StringToWideChar(ServerName, @WCWin32ChServerName, SizeOf(WCWin32ChServerName));
  if ServerName = '' then
    PWin32ChServerName := nil
  else
    PWin32ChServerName := @WCWin32ChServerName;

  rv := NetUserEnum(PWin32ChServerName, 20, FILTER_NORMAL_ACCOUNT, Pointer(buffer), MAX_PREFERRED_LENGTH,
                    entriesRead, totalEntries, NIL_HANDLE);

  if rv = NERR_Success then
    try
      for i := 0 to entriesRead - 1 do
        With buffer^[i] do
        begin
          st := WideCharToString(usri20_name);
          st := st + #0;
          st := st + WideCharToString(usri20_full_name) + #0 + WideCharToString(usri20_comment);
          list.Add (st);
        end

    finally
      if (buffer <> nil) then
        NetAPIBufferFree (buffer);
    end
  else
    raise ENTException.Create (rv)
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetLocalGroups(ServerName, UserName: String; list : TStrings);
////////////////////////////////////////////////////////////////////////////////
var
  buffer: PLOCALGROUP_USERS_INFO_0_Arr;
  rv, i, entriesRead, totalEntries : Integer;
  WCWin32ChUser, WCWin32ChServerName: array[0..255] of WideChar;
  PWin32ChServerName: Pointer;
begin
  list.Clear;
  buffer := nil;
  //todo:  if UserName = '' then raise
  StringToWideChar(ServerName, @WCWin32ChServerName, SizeOf(WCWin32ChServerName));
  if ServerName = '' then
    PWin32ChServerName := nil
  else
    PWin32ChServerName := @WCWin32ChServerName;
  StringToWideChar(UserName, @WCWin32ChUser, SizeOf(WCWin32ChUser));

  rv := NetUserGetLocalGroups (PWin32ChServerName,
                               @WCWin32ChUser,
                               0, 0,
                               Pointer(buffer),
                               MAX_PREFERRED_LENGTH,
                               entriesRead, totalEntries);

  if rv = NERR_Success then
  try
    for i := 0 to entriesRead - 1 do
      list.Add(WideCharToString(buffer^[i].lgrui0_name));

  finally
    if (buffer <> nil) then
      NetAPIBufferFree (buffer);
  end
  else raise ENTException.Create (rv)
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetGlobalGroups(ServerName, UserName: String; list : TStrings);
////////////////////////////////////////////////////////////////////////////////
var
  buffer: PGROUP_USERS_INFO_0_Arr;
  rv, i, entriesRead, totalEntries : Integer;
  WCWin32ChUser, WCWin32ChServerName: array[0..255] of WideChar;
  PWin32ChServerName: Pointer;
begin
  list.Clear;
  buffer := nil;
  //todo:  if UserName = '' then raise
  StringToWideChar(ServerName, @WCWin32ChServerName, SizeOf(WCWin32ChServerName));
  if ServerName = '' then
    PWin32ChServerName := nil
  else
    PWin32ChServerName := @WCWin32ChServerName;
  StringToWideChar(UserName, @WCWin32ChUser, SizeOf(WCWin32ChUser));

  rv := NetUserGetGroups(PWin32ChServerName,
                         @WCWin32ChUser,
                         0,
                         Pointer(buffer),
                         MAX_PREFERRED_LENGTH,
                         entriesRead,
                         totalEntries);

  if rv = NERR_Success then
  try
    for i := 0 to entriesRead - 1 do
      if ((entriesRead <> 1) or (WideCharToString(buffer^[i].grpui0_name) <> 'None')) then
        list.Add (WideCharToString(buffer^[i].grpui0_name));

  finally
    if (buffer <> nil) then
      NetAPIBufferFree (buffer);
  end
  else raise ENTException.Create (rv)
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetLocalGroupsDetails (ServerName: String; list : TStrings);
// | consists of the group name, a NULL character, followed by the comment.     |
////////////////////////////////////////////////////////////////////////////////
var
  rv, i, entriesRead, totalEntries : Integer;
  buffer : PLOCALGROUP_INFO_1_Arr;
  st : string;
  WCWin32ChServerName: array[0..255] of WideChar;
  PWin32ChServerName: Pointer;
begin
  list.Clear;
  buffer := nil;
  StringToWideChar(ServerName, @WCWin32ChServerName, SizeOf(WCWin32ChServerName));
  if ServerName = '' then
    PWin32ChServerName := nil
  else
    PWin32ChServerName := @WCWin32ChServerName;

  rv := NetLocalGroupEnum (PWin32ChServerName,
                           1,
                           Pointer(buffer),
                           MAX_PREFERRED_LENGTH,
                           entriesRead, totalEntries, NIL_HANDLE);

  if rv = NERR_Success then
  try
    for i := 0 to entriesRead - 1 do
    with buffer^[i] do
     begin
       st := WideCharToString(lgrpi1_name);
       st := st + #0 + WideCharToString(lgrpi1_comment);
       list.Add (st);
     end;
  finally
    if (buffer <> nil) then
      NetApiBufferFree (buffer);
  end
  else
    raise ENTException.Create (rv);
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetGlobalGroupsDetails (ServerName: String; list : TStrings);
// | user manager group list.  Each string returned consists of a Nul-separeted |
// | list of group name, group comment, and group ID (RID)                      |
////////////////////////////////////////////////////////////////////////////////
var
  rv, i, entriesRead, totalEntries : Integer;
  buffer : PGROUP_INFO_2_Arr;
  st : string;
  WCWin32ChServerName: array[0..255] of WideChar;
  PWin32ChServerName: Pointer;
begin
  list.Clear;
  buffer := nil;
  StringToWideChar(ServerName, @WCWin32ChServerName, SizeOf(WCWin32ChServerName));
  if ServerName = '' then
    PWin32ChServerName := nil
  else
    PWin32ChServerName := @WCWin32ChServerName;

  rv := NetGroupEnum (PWin32ChServerName,
                      2,
                      Pointer(buffer),
                      MAX_PREFERRED_LENGTH,
                      entriesRead, totalEntries, NIL_HANDLE);

  if rv = NERR_Success then
  try
    for i := 0 to entriesRead - 1 do
      with buffer^[i] do
        if (entriesRead <> 1) or (WideCharToString(grpi2_name) <> 'None') then
        begin
          st := WideCharToString(grpi2_name);
          st := st + #0 + WideCharToString(grpi2_comment);
          st := st + #0 + IntToStr(grpi2_group_id);
          list.Add (st);
        end;
  finally
    if (buffer <> nil) then
      NetApiBufferFree (buffer);
  end
  else
    raise ENTException.Create (rv);
end;
////////////////////////////////////////////////////////////////////////////////
procedure LocalGroupGetMembers(ServerName, GroupName: String; list : TStrings);
////////////////////////////////////////////////////////////////////////////////
var
  rv, i, entriesRead, totalEntries : Integer;
  buffer : PLOCALGROUP_MEMBERS_INFO_0_Arr;
  accountName : array [0..UNLEN] of char;
  domainName : array [0..DNLEN] of char;
  accountNameLen, domainNameLen : DWORD;
  sidNameUse : SID_NAME_USE;
  st : string;
  defaultServer : string;
  WCWin32ChServerName, WCWin32ChGroup: array[0..255] of WideChar;
  PWin32ChServerName: Pointer;
begin
  list.Clear;
  buffer := nil;
  StringToWideChar(ServerName, @WCWin32ChServerName, SizeOf(WCWin32ChServerName));
  if ServerName = '' then
    PWin32ChServerName := nil
  else
    PWin32ChServerName := @WCWin32ChServerName;
  StringToWideChar(GroupName, @WCWin32ChGroup, SizeOf(WCWin32ChGroup));

  if ServerName = '' then
  begin
    SetLength (defaultServer, CNLEN + 1);
    domainNameLen := CNLEN + 1;
    GetComputerName (PChar (defaultServer), domainNameLen);
    SetLength (defaultServer, lstrlen (PChar (defaultServer)))
  end
  else
    defaultServer := ServerName;

  rv := NetLocalGroupGetMembers(PWin32ChServerName,
                                @WCWin32ChGroup,
                                0,
                                Pointer(buffer),
                                MAX_PREFERRED_LENGTH,
                                entriesRead, totalEntries, NIL_HANDLE);

  if rv = NERR_Success then
  try
    for i := 0 to entriesRead - 1 do
    begin
      accountNameLen := sizeof (accountName);
      domainNameLen := sizeof (domainName);

      //available in Windows.pas
      if not LookupAccountSid(PChar (ServerName), buffer^[i].lgrmi0_sid,
                              accountName, accountNameLen,
                              domainName, domainNameLen, sidNameUse) then
      begin
        accountName := 'Unknown';
        raise ENTException.Create (GetLastError)
      end;

      if domainName = defaultServer then
        st := accountName
      else
        st := domainName + '\' + string (accountName);
      list.AddObject (st, TObject (sidNameUse));
    end
  finally
    if (buffer <> nil) then
      NetApiBufferFree (buffer);
  end
  else
    raise ENTException.Create (rv);
end;
////////////////////////////////////////////////////////////////////////////////
procedure GlobalGroupGetMembers(ServerName, GroupName: String; list : TStrings);
////////////////////////////////////////////////////////////////////////////////
var
  rv, i, entriesRead, totalEntries : Integer;
  buffer : PGROUP_USERS_INFO_0_Arr;
  WCWin32ChServerName, WCWin32ChGroup: array[0..255] of WideChar;
  PWin32ChServerName: Pointer;
begin
  list.Clear;
  buffer := nil;
  StringToWideChar(ServerName, @WCWin32ChServerName, SizeOf(WCWin32ChServerName));
  if ServerName = '' then
    PWin32ChServerName := nil
  else
    PWin32ChServerName := @WCWin32ChServerName;
  StringToWideChar(GroupName, @WCWin32ChGroup, SizeOf(WCWin32ChGroup));

  rv := NetGroupGetUsers (PWin32ChServerName,
                          @WCWin32ChGroup,
                          0,
                          Pointer(buffer),
                          MAX_PREFERRED_LENGTH,
                          entriesRead, totalEntries, NIL_HANDLE);

  if rv = NERR_Success then
  try
    for i := 0 to entriesRead - 1 do
      list.AddObject(WideCharToString(buffer^[i].grpui0_name), TObject (SidTypeUser));
  finally
    if (buffer <> nil) then
      NetApiBufferFree (buffer);
  end
  else
    raise ENTException.Create (rv);
end;
////////////////////////////////////////////////////////////////////////////////
end.
