unit formMain;
  //This will warn the user about potential risks before NT2Linux executes.
  //It is commented-out by default. Un-comment to activate.
{.$DEFINE INITIAL_WARNING_PROMPT}

interface
uses
  Windows, Messages, SysUtils, Forms, Classes, ComCtrls, ExtCtrls, StdCtrls,
  FileCtrl, Controls, Graphics, Registry, Libs, LibsNT, LibsUtils;
const
{+-----------------------------------------------------------------------------
 | Program: NT2Linux migration kit: "for the rest of us"..
 | Description: NT to Linux migration kit
 | Purpose: Extract all there is to know from a NT server.
 | Authors: Marc Clment, Jacques Glinas and Jean-Franois Guay
 | Requirements: Win NT v4.0+ SP3+ (also tested with 2000) and Delphi v5.0
 |               Sorry, it does not work with NT v3.51.
 | ----------------------------------------------------------------------------
 | Copyright (c) 2000 Marc Clment, Jacques Glinas and Jean-Franois Guay
 |
 | Please submit changes to the authors or throu the listserv at:
 | nt2linux@solucorp.qc.ca
 |
 | This program is free software; you can redistribute it and/or
 | modify it under the terms of the GNU General Public License
 | as published by the Free Software Foundation;
 |
 | This program is distributed in the hope that it will be useful,
 | but WITHOUT ANY WARRANTY; without even the implied warranty of
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 | provided license.txt for more details.
 |
 | For questions concerning GNU General Public License, write to
 | the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 | Boston, MA 02111-1307, USA.
 |
 | WARNING: TAKE GOOD NOTE THAT YOU SHOULD HAVE A BACKUP OF THE ANALYZED
 |          SERVER AND OF THE RELEVANT CONFIG FILES.
 |          BY NO MEANS WILL WE TAKE ANY KIND OF RESPONSABILITY WHATSOEVER!
 |-----------------------------------------------------------------------------}
   Version=              'v0.01-2 (eta)';
 { Created:              During 1999-2000
 | Modification History:
 |   v0.01-1 -eta-
 |     2000-06-13: - Initial Release
 |   v0.01-2 -eta-
 |     2000-07-13: - minor re-organisation of the code
 |                 - memory leak fix with proper releasing of Share_Info_502
 |                   in proc lvSharesSelectItem
 |                 - Added credits to Jeremy Allison for pwdump.exe
 |                 - Added the "pwdump" src tree
 |                 - Added $DEFINE INITIAL_WARNING_PROMPT include and an
 |                   optional warning dialog box on startup
 |                 - Renamed StripComma to SubstComma
 |
 |
 | Todo:
 |   - Downgrade the code for Delphi 4 (VER120), Delphi 3 (VER100) and Delphi 2 (VER90)
 |   - Some things from global samba page are not done yet
 |   - Section Share/Data/Homes is not completed yet
 |   - Add a log of conversion parameters
 |
 |
 | Possible improvements:
 |   - Should we implement DNS+WINS+DHCP infos extractions and/or manual dialogs?
 |
 | Notes:
 |   - We tried to do our best to make this utility non-obstrusive and
 |     "non-offensive" for the analyzed server.
 |     All operations should be performed in a "read-only" fashion.
 |     These utility should not modify your windows server configuration.
 |     But take a good backup before you play around, we did scrap at least
 |     one server while developing this.. and with windows, you never know.
 |   - Many thanks to the authors (in no particular order) who has
 |     helped with their work to bring-out Windows NT from obscurity.
 |     Thanks guys!
 |       + for: ConsoleApp
 |           Martin Lafferty (martinl@prel.co.uk)
 |           Production Robots Engineering Ltd
 |           Box 2290, Wimborne, Dorset, BH21 2YY, England.
 |       + for: POSIX ACLs for Linux 0.6.0-pre17
 |           Andreas Grnbacher (a.gruenbacher@computer.org)
 |           http://acl.bestbits.at/
 |       + for: jgNTApi v1.0
 |           John Gonzalez 1999
 |       + for: UnitNTException
 |           Colin Wilson (colin@wilsonc.demon.co.uk)
 |       + for: pwdump.exe
 |              note: we re-compiled pwdump to remove the hardcoding of
 |                    "Administrator" so that it works in any language.
 |                    This could constitute a security breach: someone without
 |                    administrator rights could potentially extract the hashes
 |                    from SAM database (not tested).
 |           Jeremy Allison (jra@samba.org)
 |           http://www.samba.org
 |
 |   - Nt2Linux utilities are not optimized by any means!
 |     Since we want to be able to modify and test the code quickly,
 |     everything has been stripped down to the strict minimum.
 |     Please refer to the original authors works for further details.
 |
 |
 +--------------------------------------------------------------------------+}

  WM_APPSTARTUP  = WM_USER + 101;

type
  TfrmMain = class(TForm)
    tabpage_main: TPageControl;
    group_TabSheet: TTabSheet;
    Label5: TLabel;
    Label6: TLabel;
    btnDelGroups: TButton;
    lvGroups: TListView;
    lvmembers: TListView;
    Button20: TButton;
    btnDelGroupMember: TButton;
    user_TabSheet: TTabSheet;
    Label13: TLabel;
    Label14: TLabel;
    Button13: TButton;
    rgUsersCase: TRadioGroup;
    lvUsers: TListView;
    Button19: TButton;
    lvgroupmembership: TListView;
    Button14: TButton;
    share_TabSheet: TTabSheet;
    Label15: TLabel;
    Label16: TLabel;
    Label71: TLabel;
    Button18: TButton;
    Button2: TButton;
    lvShares: TListView;
    lvacls: TListView;
    Button12: TButton;
    Button9: TButton;
    printers_TabSheet: TTabSheet;
    Label17: TLabel;
    Label23: TLabel;
    Button4: TButton;
    Button3: TButton;
    lvprinter: TListView;
    chkbPrintDriverDir: TCheckBox;
    data_TabSheet: TTabSheet;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    Button6: TButton;
    lvdata: TListView;
    lvacl: TListView;
    Button27: TButton;
    Button10: TButton;
    rgData: TRadioGroup;
    options_TabSheet: TTabSheet;
    Label32: TLabel;
    Label33: TLabel;
    lblSmbWinsServer: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Label45: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    Label54: TLabel;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    Label61: TLabel;
    Label62: TLabel;
    Label63: TLabel;
    Label64: TLabel;
    Label65: TLabel;
    Label66: TLabel;
    Label67: TLabel;
    Label68: TLabel;
    Label118: TLabel;
    Label119: TLabel;
    Label120: TLabel;
    Label122: TLabel;
    Label123: TLabel;
    Label126: TLabel;
    Label127: TLabel;
    Label128: TLabel;
    Label129: TLabel;
    Label35: TLabel;
    Label70: TLabel;
    Edit1: TEdit;
    chkSmbWinsServer: TCheckBox;
    edtSmbWinsServer: TEdit;
    edtSMBServerName: TEdit;
    edtSMBNTDomain: TEdit;
    edtSmbServerString: TEdit;
    edtSMBResolve: TEdit;
    Edit11: TEdit;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    Button29: TButton;
    todo_TabSheet: TTabSheet;
    pgAbout: TTabSheet;
    TabSheet2: TTabSheet;
    Label1: TLabel;
    Label12: TLabel;
    Label22: TLabel;
    Label28: TLabel;
    Label30: TLabel;
    Label69: TLabel;
    Label73: TLabel;
    edtGateway: TEdit;
    edtDNS1: TEdit;
    edtWINS1: TEdit;
    rgTCP: TRadioGroup;
    edtNicHostName: TEdit;
    edtServerName2: TEdit;
    lvIP: TListView;
    cbxNicName: TComboBox;
    TabSheet3: TTabSheet;
    memoExport: TMemo;
    Button11: TButton;
    btnSave: TButton;
    Label8: TLabel;
    Label4: TLabel;
    edtHomesOutputPath: TEdit;
    Bevel1: TBevel;
    Label7: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    StatusBar1: TStatusBar;
    Bevel3: TBevel;
    Label11: TLabel;
    edtServerName: TEdit;
    Label24: TLabel;
    edtNTDomain: TEdit;
    Label25: TLabel;
    edtUserName: TEdit;
    edtDomain: TEdit;
    label88: TLabel;
    Label26: TLabel;
    edtHostDomainName: TEdit;
    edtHostName: TEdit;
    Panel1: TPanel;
    Label9: TLabel;
    Image4: TImage;
    lblVersionAbout: TLabel;
    Label29: TLabel;
    Label31: TLabel;
    Label74: TLabel;
    Label75: TLabel;
    Label76: TLabel;
    edtDomain2: TEdit;
    Label77: TLabel;
    lbNicName: TListBox;
    Label78: TLabel;
    Label79: TLabel;
    Image1: TImage;
    Label80: TLabel;
    edtDNS2: TEdit;
    lblIsDomain: TLabel;
    Label81: TLabel;
    Label82: TLabel;
    edtServerNameMigrate: TEdit;
    edtWINS1Migrate: TEdit;
    Label83: TLabel;
    edtWINS2: TEdit;
    Shape1: TShape;
    lblDNS: TLabel;
    lblDHCP: TLabel;
    lblWINS: TLabel;
    btnDNS: TButton;
    btnDHCP: TButton;
    btnWINS: TButton;
    pgGlobals: TTabSheet;
    Label84: TLabel;
    GroupBox1: TGroupBox;
    chkNetwork: TCheckBox;
    pgExplanations: TTabSheet;
    Label85: TLabel;
    Label86: TLabel;
    chkDNS: TCheckBox;
    chkDHCP: TCheckBox;
    chkWINS: TCheckBox;
    chkGroups: TCheckBox;
    chkUsers: TCheckBox;
    chkShares: TCheckBox;
    chkPrinters: TCheckBox;
    chkData: TCheckBox;
    chkHomes: TCheckBox;
    chkSamba: TCheckBox;
    GroupBox2: TGroupBox;
    Label87: TLabel;
    Edit12: TEdit;
    btnRefreshAll: TButton;
    chkForceServer: TCheckBox;
    lblForceServer: TLabel;
    Label89: TLabel;
    edtServerNameHidden: TEdit;
    chkbPWDump: TCheckBox;
    Label10: TLabel;
    GroupBox3: TGroupBox;
    Label21: TLabel;
    lblVersion: TLabel;
    Label34: TLabel;
    lblBuild: TLabel;
    Label72: TLabel;
    lblComputerName: TLabel;
    Label90: TLabel;
    lblCurrentUser: TLabel;
    Label91: TLabel;
    lblCurrentLanguage: TLabel;
    Label92: TLabel;
    lblTimeZone: TLabel;
    Label94: TLabel;
    lblOS: TLabel;
    Label95: TLabel;
    lblSP: TLabel;
    Label96: TLabel;
    lblTimeDiff: TLabel;
    Label93: TLabel;
    lblWinDir: TLabel;
    Label97: TLabel;
    edtOutputPath: TEdit;
    Edit9: TEdit;
    Edit8: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure cbxNicNameChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure lvGroupsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure lvUsersSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure Button20Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure lvdataSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure lvdataDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lvdataDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure lvSharesSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure Button27Click(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure memoExportKeyPress(Sender: TObject; var Key: Char);
    procedure btnDelGroupsClick(Sender: TObject);
    procedure btnDelGroupMemberClick(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnRefreshAllClick(Sender: TObject);
    procedure chkSmbWinsServerClick(Sender: TObject);
    procedure chkSmbWinsServerKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edtServerNameMigrateExit(Sender: TObject);
    procedure edtWINS1MigrateExit(Sender: TObject);
    procedure Button29Click(Sender: TObject);
  private
    glbError: String;
    glbClosing: Boolean;
    function InitSysInfo(): Boolean;
    procedure WMAppStartup(var msg: TMessage); message WM_APPSTARTUP;
  public
    sLstGroups: TStringList;
    sLstUsers: TStringList;
    sLstShares: TStringList;
    sLstData: TStringList;
  end;

var
  frmMain: TfrmMain;
  //Oups! Nics ids are Global for now.
  nics: String;

type
  TGenericItem = class(TObject)
    //Utility class to manage list of lists (ie: shares, groups..)
    private
      FCount: Integer;
      FIntList: TStringList;
      function GetItem(Index: Integer): String;
      function GetCount: Integer;
    public
      constructor Create(var SubList: TStringList);
      destructor Destroy; override;
      property Count: Integer read GetCount;
      property Item[Index: Integer]: String
        read GetItem; default;
      procedure Clear;
      procedure DeleteItem(anItem: String);
  end;

implementation

uses formScriptHints;

{$R *.DFM}

////////////////////////////////////////////////////////////////////////////////
//Helper class!
////////////////////////////////////////////////////////////////////////////////
constructor TGenericItem.Create(var SubList: TStringList);
////////////////////////////////////////////////////////////////////////////////
var
  i: Integer;
begin
  Inherited Create;
  FCount := 0;
  FIntList := TStringList.Create;
  for i := 0 to SubList.Count - 1 do
    FIntList.Add(SubList[i]);
end;
////////////////////////////////////////////////////////////////////////////////
destructor TGenericItem.Destroy;
////////////////////////////////////////////////////////////////////////////////
begin
  FIntList.Free;
  inherited destroy;
end;
////////////////////////////////////////////////////////////////////////////////
function TGenericItem.GetItem(Index: Integer): String;
////////////////////////////////////////////////////////////////////////////////
begin
  if (Index <= (FIntList.Count -1)) then
    result := FIntList[index]
  else
    result := 'ERROR';
end;
////////////////////////////////////////////////////////////////////////////////
procedure TGenericItem.DeleteItem(anItem: String);
////////////////////////////////////////////////////////////////////////////////
var
  iPos: Integer;
begin
  iPos := FIntList.IndexOf(anItem);
  if (iPos > -1) then
    FIntList.Delete(iPos);
end;
////////////////////////////////////////////////////////////////////////////////
function TGenericItem.GetCount: Integer;
////////////////////////////////////////////////////////////////////////////////
begin
  if FIntList <> nil then
    result := FIntList.Count
  else
    result := 0;
end;
////////////////////////////////////////////////////////////////////////////////
procedure TGenericItem.Clear;
////////////////////////////////////////////////////////////////////////////////
begin
  if FIntList <> nil then
    FIntList.Clear;
end;
////////////////////////////////////////////////////////////////////////////////
//Start-up!
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.WMAppStartup(var msg: TMessage);
////////////////////////////////////////////////////////////////////////////////
var
  OSVersionInfo: TOSVersionInfo;
begin
  if glbClosing then
    Application.Terminate
  else
  begin
    Caption := 'NT2Linux ' + Version;
    lblVersionAbout.Caption := lblVersionAbout.Caption + Version;
    glbError := '';
    OSVersionInfo.dwOSVersionInfoSize := SizeOf(OSVersionInfo);
    GetVersionEx(OSVersionInfo);
    //When SysUtils gets initialized it executes: InitPlatformId;
    if ((Win32Platform <> VER_PLATFORM_WIN32_NT) or (OSVersionInfo.dwMajorVersion < 4)) then
      glbError := 'This program requires "Windows NT v4.0+", cannot continue.';

    //Check for Server or WorkStation
    if glbError = '' then
      With TRegistry.create do
        try
          RootKey := HKEY_LOCAL_MACHINE;
          if OpenKey('\System\CurrentControlSet\Control\ProductOptions', false) then
            if ValueExists('ProductType') then
              if (ReadString('ProductType') <> 'ServerNT')then
                //This is a Windows WorkStation (WinNT)
                glbError := 'This program requires "Windows NT Server", cannot continue.';
        finally
          CloseKey;
          Free;
        end;

    if ((not InitSysInfo()) or (glbError <> '')) then
    begin
      Windows.MessageBox(Application.Handle, PChar (glbError), PChar ('Error!'),
        MB_APPLMODAL or MB_ICONSTOP or MB_OK);
      Application.Terminate;
    end else
    begin

      if (OSVersionInfo.dwMajorVersion = 5) then
        lblOS.Caption := 'Windows NT 2000'
      else
        lblOS.Caption := 'Windows NT';
      lblVersion.Caption := IntToStr(OSVersionInfo.dwMajorVersion) + '.' +
        IntToStr(OSVersionInfo.dwMinorVersion);
      lblBuild.Caption := IntToStr(LoWord(OSVersionInfo.dwBuildNumber));
      lblSP.Caption := StrPas(OSVersionInfo.szCSDVersion);
      GetNic();
      cbxNicNameChange(Self);
      GetUsers();
      GetGroups();
      GetShares();
      RegistryReadPrinter();
    end;//if
  end;//if
end;
////////////////////////////////////////////////////////////////////////////////
//Main Form event's
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.FormCreate(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
var
  str: String;
begin
  glbClosing := false;

{$IFDEF INITIAL_WARNING_PROMPT}
  Str := 'WARNING: TAKE GOOD NOTE THAT YOU SHOULD HAVE A BACKUP OF THE' + #13#10;
  Str := Str + 'ANALYZED SERVER AND OF ALL THE RELEVANT CONFIG FILES.' + #13#10;
  Str := Str + 'BY NO MEANS WILL WE TAKE ANY KIND OF RESPONSABILITY WHATSOEVER!' + #13#10;
  Str := Str + 'DO YOU STILL WANT TO PROCEED?';

  if Windows.MessageBox(Application.Handle, PChar(str), PChar('Continue?'),
      MB_APPLMODAL or MB_ICONQUESTION or MB_YESNO) <> IDYES then
    glbClosing := true;
{$ENDIF}

  rgTCP.ItemIndex := 0;

  sLstGroups := TStringList.Create;
  sLstGroups.Duplicates := dupIgnore;
  sLstGroups.Sorted := true;
  sLstUsers := TStringList.Create;
  sLstUsers.Duplicates := dupIgnore;
  sLstUsers.Sorted := true;
  sLstShares := TStringList.Create;
  sLstShares.Duplicates := dupIgnore;
  sLstShares.Sorted := true;
  sLstData := TStringList.Create;

  chkbPWDump.Checked := true;
  chkbPrintDriverDir.Checked := true;

  Update;
  //Start-up!
  PostMessage(Handle, WM_APPSTARTUP, 0, 0);
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.cbxNicNameChange(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
begin
  RegistryReadTCP(cbxNicName.ItemIndex + 1);
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.lvGroupsSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
////////////////////////////////////////////////////////////////////////////////
var
  i, iPos: Integer;
  str: String;
begin
  lvmembers.items.Clear;
  //TODO Check: protection: lvGroups got a Item Selection after FormDestroy Why??
  if not glbClosing then
  begin
    if item.SubItems[1] = 'LOCAL' then
      iPos := sLstGroups.IndexOf('L' + UpperCase(item.Caption))
    else
      iPos := sLstGroups.IndexOf('G' + UpperCase(item.Caption));
    if iPos <> -1 then
      for i := 0 to (TGenericItem(sLstGroups.Objects[iPos]).count - 1) do
      begin
        str := TGenericItem(sLstGroups.Objects[iPos])[i];
        if ((str <> '') and (str <> 'ERROR')) then
          with lvmembers.Items.Add do
            Caption := str;
      end;//for
  end;//if
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.lvUsersSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
////////////////////////////////////////////////////////////////////////////////
var
  i, iPos: Integer;
  str: String;
begin
  lvGroupMembership.items.Clear;
  //TODO Check: protection: lvUsers got a Item Selection after FormDestroy Why??
//TODO: Check if it is so..
  if not glbClosing then
  begin
    iPos := sLstUsers.IndexOf(UpperCase(item.Caption));
    if iPos <> -1 then
      for i := 0 to (TGenericItem(sLstUsers.Objects[iPos]).count - 1) do
      begin
        str := TGenericItem(sLstUsers.Objects[iPos])[i];
        if ((str <> '') and (str <> 'ERROR')) then
          with lvGroupMembership.Items.Add do
            Caption := str;
      end;//for
  end;//if
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.Button20Click(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
begin
  GetGroups();
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.Button19Click(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
begin
  GetUsers();
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.Button2Click(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
begin
  GetShares();
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.Button3Click(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
begin
  RegistryReadPrinter();
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.lvdataDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
////////////////////////////////////////////////////////////////////////////////
begin
  Accept := (Source is TDirectoryListBox);
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.lvdataDragDrop(Sender, Source: TObject; X, Y: Integer);
////////////////////////////////////////////////////////////////////////////////
var
  i : integer;
  Val: String;
  exists: Boolean;
begin
  exists := false;
  if Source is TDirectoryListBox then
  begin
    Val := DirectoryListBox1.GetItemPath(SendMessage(DirectoryListBox1.Handle, LB_GETCURSEL, 0, 0));
    for i := 0 to lvdata.Items.Count -1 do
      if (lvdata.Items[i].caption = Val) then
        exists := true;
    if Not exists then
      lvdata.Items.Add.Caption :=Val;
  end;
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.lvdataSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
////////////////////////////////////////////////////////////////////////////////
Var
  AclList, TmpLst: TStringList;
  res: String;
  i: Integer;
begin
  lvacl.Items.Clear;
  AclList := TStringList.create;
  TmpLst := TStringList.create;
  try
    res := GetAclDetails(Item.Caption, AclList);
    if res <> '' then
      lvacl.Items.Add.Caption := res
    else
    begin
      for i := 0 to AclList.Count - 1 do
        with lvAcl.Items.Add do
        begin
          TmpLst.Clear;
          strTokenToStrings(AclList[i], '|', TmpLst);
          Caption := TmpLst[0];      // Extract share name
          SubItems.Add(TmpLst[1]);
          SubItems.Add(TmpLst[2] + TmpLst[3]);
        end;//with
    end;
  finally
    AclList.free;
    TmpLst.free;
  end;//try
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.lvSharesSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
////////////////////////////////////////////////////////////////////////////////
Var
  I,J,K,L  : Dword; //Integer;
  B,B2,B3  : Bool;
  ACL      : PACL;
  ACE      : Pointer;
  SID      : Pointer;
  AM       : Integer; { access mask }
  Name,Dom : Array[0..100] of Char;
  Share_Info_502: PShare_Info_502;
  PWCName, PWCServer: array[0..255] of WideChar;
  keys: TStringList;
begin
  lvacls.items.clear;

  keys := Tstringlist.Create;
  With TRegistry.create do
    try
      RootKey := HKEY_LOCAL_MACHINE;
      if OpenKey('\System\CurrentControlSet\Services\LanmanServer\Shares\Security', false) then
        if ValueExists(item.caption) then
        begin
          StringToWideChar(item.Caption, @PWCName, SizeOf(PWCName));
          StringToWideChar('', @PWCServer, SizeOf(PWCName));
          Share_Info_502 := nil;

          if (NetShareGetInfo(@PWcServer, @PWCName, 502, Pointer(Share_Info_502)) <> 0) then
            Raise Exception.Create('Problem with ACL Info''s: ('+IntToStr(GetLastError)+').');

          B := GetSecurityDescriptorDACL(Share_Info_502^.shi502_security_descriptor,B2,ACL,B3);
          if (not B) Then
            raise Exception.Create('Problem with GSDD ('+IntToStr(GetLastError)+').');

          if (ACL <> nil) Then
          Begin
            for J := 0 to ACL.ACECount-1 do
            begin
              B := GetACE(ACL^,J,ACE);
              if (not B) then
                raise Exception.Create('Problem with GA ('+IntToStr(GetLastError)+').');
                  if (TACEHeader(ACE^).ACEType = Access_Allowed_ACE_Type) then
                  begin
                    SID := @TAccessAllowedACE(ACE^).SIDStart;
                    AM := TAccessAllowedACE(ACE^).Mask;
                    B2 := True;
                  end else
                  begin
                    SID := @TAccessDeniedACE(ACE^).SIDStart;
                    AM := TAccessDeniedACE(ACE^).Mask;
                    B2 := False;
                  end;
                  I := SizeOf(Name); K := SizeOf(Dom);
                  B := LookupAccountSID('',SID,Name,I,Dom,K,L);
                  if (not B) then
                    raise Exception.Create('Problem with LAS ('+IntToStr(GetLastError)+', '+IntToStr(GetLastError)+').');
                  if B2 then
                    with lvAcls.Items.Add do
                    begin
                      Caption := Name;
                      SubItems.Add (Dom);
                      SubItems.Add ('(A) '+GetAccessRights(AM));
                      // SecurityData.Items.Add(Name+#9+Dom+#9'(A) '+GetAccessRights(AM))
                    end//with
                  else
                    with lvAcls.Items.Add do
                    begin
                      Caption := Name;           // Extract user name
                      SubItems.Add (Dom);       // Extract full name
                      SubItems.Add ('(D) '+GetAccessRights(AM));       // Extract comment
                      // SecurityData.Items.Add(Name+#9+Dom+#9'(A) '+GetAccessRights(AM))
                    end;//with
            end;//for
            //SecurityData.Items.Add(IntToStr(ACL.ACECount)+' ACE(s) total.');
          end else
            lvacls.Items.Add.Caption := 'No security ??';
          //in any case, if we used the Share_Info_502 structure we shall release-it.
          if (NETAPIBUFFERFree(Share_Info_502) <> 0) then
            Raise Exception.Create('Problem with ACL Info''s: ('+IntToStr(GetLastError)+').');
        end else
          with lvacls.Items.Add do
          begin
            Caption := 'Tout le monde';
            SubItems.Add ('');
            SubItems.Add ('(A) RWXDPO');
          end;//with
    finally
      Keys.free;
      CloseKey;
      Free;
    end;//try
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.Button27Click(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
var
  i : integer;
  exist : bool;
  Val: String;
begin
  exist := false;
  Val := DirectoryListBox1.GetItemPath(SendMessage(DirectoryListBox1.Handle, LB_GETCURSEL, 0, 0));
  for i := 0 to lvdata.Items.Count -1 do
    if lvdata.Items[i].caption = Val then
      exist := True;
  if not exist then
    lvdata.Items.Add.Caption := Val;
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.btnSaveClick(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
begin
//todo globalize..
  MemoExport.Lines.SaveToFile(ExtractFilePath(Paramstr(0))+'export.dat');
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.memoExportKeyPress(Sender: TObject; var Key: Char);
////////////////////////////////////////////////////////////////////////////////
begin
  btnSave.Enabled := true;
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.Button11Click(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
begin
  SaveFile(ExtractFilePath(Paramstr(0))+'export.dat');
  MemoExport.Lines.LoadFromFile(ExtractFilePath(Paramstr(0))+'export.dat');
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.btnDelGroupsClick(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
begin
  if lvgroups.SelCount > 0 then
  begin
    lvgroups.Selected.Delete;
    lvmembers.items.clear;
  end;
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.btnDelGroupMemberClick(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
var
  Str: String;
  TmpItem: TListItem;
  iPos: Integer;
begin
  with lvMembers do
    if SelCount > 0 then
    begin
      TmpItem := Items[Selected.Index];
      Str := TmpItem.Caption;
      with lvGroups do
      begin
        TmpItem := Items[Selected.Index];
        if TmpItem.SubItems[1] = 'LOCAL' then
          iPos := sLstGroups.IndexOf('L' + UpperCase(TmpItem.Caption))
        else
          iPos := sLstGroups.IndexOf('G' + UpperCase(TmpItem.Caption));
      end;//with
      if (iPos <> -1) then
      begin
        lvMembers.Selected.Delete;
        TGenericItem(sLstGroups.Objects[iPos]).DeleteItem(Str);
      end;//if
    end;
end;
////////////////////////////////////////////////////////////////////////////////
//Retrieve NT info's
////////////////////////////////////////////////////////////////////////////////
function TfrmMain.InitSysInfo: Boolean;
////////////////////////////////////////////////////////////////////////////////
var
  fInfo: USER_INFO_3;  //detailed UserInfo struct
  chr: Array[0..255] of char;
  tmpTimeZone: TTimeZoneInformation;
begin
  result := false;
  with TRegistry.create do
    try
      RootKey := HKEY_LOCAL_MACHINE;

      glbError := 'Cannot get the Server Name';
      try
        if OpenKey('\System\CurrentControlSet\Control\ComputerName\ActiveComputerName', false) then
        begin
          edtServerName.Text := ReadString('ComputerName');
          lblComputerName.Caption := edtServerName.Text;
          //Current Language
          VerLanguageName(GetSystemDefaultLangID, chr, 255);
          lblCurrentLanguage.Caption := String(chr);
          GetTimeZoneInformation(tmpTimeZone);
          lblTimeZone.Caption := WideCharToString(tmpTimeZone.StandardName);
          lblTimeDiff.Caption := IntToStr(tmpTimeZone.Bias);
          GetWindowsDirectory(chr, 255);
          lblWinDir.Caption := String(chr);
          //contains serverName if on a domain or else ''
          edtServerNameHidden.Text := edtServerName.Text;
          edtServerName2.Text := edtServerName.Text;
          edtSMBServerName.Text := edtServerName.Text;
        end else
          exit;
      finally
        CloseKey;
      end;

      glbError := 'Cannot get user name';
      try
        if OpenKey('\Software\Microsoft\Windows NT\CurrentVersion\Winlogon', false) then
        begin
          edtNTDomain.Text := ReadString('DefaultDomainName');
          edtUserName.Text := ReadString('DefaultUserName');
          lblCurrentUser.Caption := edtUserName.Text;
        end else
          exit;
      finally
        CloseKey;
      end;

      if ((UpperCase(edtNTDomain.Text) = UpperCase(edtServerName.Text)) or
        chkForceServer.Checked) then
      //This computer is not part of a domain..
      begin
        lblIsDomain.Visible := True;
        edtServerNameHidden.Text := '';
        edtNTDomain.Enabled := false;
        edtSMBNTDomain.Text := ''; //todo: get name of workgroup
      end else
      begin
        edtServerNameHidden.Text := GetPDCName(edtNTDomain.Text);
        lblForceServer.Enabled := true;
        chkForceServer.Enabled := true;
        edtSMBNTDomain.Text := edtNTDomain.Text;
      end;

      glbError := 'You must be an administrator to run this program';

      GetLevel3Info(edtServerNameHidden.Text, edtUserName.Text, fInfo);

      //fInfo.usri3_primary_group_id seems to catch "Domain user" (513) by default.
      //Instead of iterating throu groups to find "Administrator" we use the
      //"priv" field ie: "privilege"
      if (CvntDWordToPrivilege(fInfo.usri3_priv)<>USR_PRIV_ADMIN) then
        exit;

      glbError := '';
      if OpenKey('\SYSTEM\CurrentControlSet\Services', false) then
      begin
        lblDHCP.Caption := 'This machine does NOT seem to be running a MS DHCP server';
        if KeyExists('DHCPServer') then
        begin
          if ValueExists('Start') then
            if (ReadInteger('Start') = 2) then
              lblDHCP.Caption := 'This machine is running a MS DHCP server';
        end;//if
        lblWINS.Caption := 'This machine does NOT seem to be running a MS WINS server';
        if KeyExists('WINS') then
        begin
          Openkey('\SYSTEM\CurrentControlSet\Services\WINS', false);
          if ValueExists('Start') then
            if (ReadInteger('Start') = 2) then
              lblWINS.Caption := 'This machine is running a MS WINS server';
        end;
        lblDNS.Caption := 'This machine does NOT seem to be running a MS DNS server';
        if KeyExists('DNS') then
        begin
          Openkey('\SYSTEM\CurrentControlSet\Services\DNS', false);
          if ValueExists('Start') then
            if (ReadInteger('Start') = 2) then
              lblDNS.Caption := 'This machine is running a MS DNS server';
        end;
      end;//if
      CloseKey;

      if OpenKey('\System\CurrentControlSet\Services\Tcpip\Parameters', false) then
      begin
        edtDomain.Text := ReadString('Domain');
        edtDomain2.Text := ReadString('Domain');
        edtHostName.Text := ReadString('HostName');
        if (edtDomain.Text <> '') then
          edtHostDomainName.Text := edtHostName.Text + '.' + ReadString('Domain')
        else
          edtHostDomainName.Text := edtHostName.Text;
      end;
      CloseKey;
      result := true;
    finally
      Free;
    end;//try
end;
procedure TfrmMain.Button14Click(Sender: TObject);
var
  Str: String;
  TmpItem : TListItem;
  iPos: Integer;
begin
  with lvgroupmembership do
    if SelCount > 0 then
    begin
      TmpItem := Items[Selected.Index];
      Str := TmpItem.Caption;
      with lvUsers do
      begin
        TmpItem := Items[Selected.Index];
        iPos := sLstUsers.IndexOf(UpperCase(TmpItem.Caption))
      end;//with
      if (iPos <> -1) then
      begin
        lvgroupmembership.Selected.Delete;
        TGenericItem(sLstUsers.Objects[iPos]).DeleteItem(Str);
      end;//if
    end;
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.Button13Click(Sender: TObject);
begin
  if lvUsers.SelCount > 0 then
  begin
    lvUsers.Selected.Delete;
    lvGroupMembership.items.clear;
  end;
end;
////////////////////////////////////////////////////////////////////////////////
procedure TfrmMain.Button4Click(Sender: TObject);
begin
  if lvprinter.SelCount > 0 then
    lvprinter.Selected.Delete;
end;

procedure TfrmMain.Button18Click(Sender: TObject);
begin
          if lvshares.SelCount > 0 then
          begin
               lvshares.Selected.Delete;
               lvacls.items.clear;
          end;

end;


procedure TfrmMain.Button6Click(Sender: TObject);
begin
          if lvdata.SelCount > 0 then
          lvdata.Selected.Delete;

end;

procedure TfrmMain.Button12Click(Sender: TObject);
var
  i: Integer;
begin
  //delete the hidden shares..
  With lvShares do
  begin
    i := Items.Count-1;
    While (i > -1) do
    begin
      if (pos('$', Items[i].Caption) = Length(Items[i].Caption)) then
        Items.Delete(i);
      dec(i);
    end;
  end;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
var
  i: Integer;
begin
  glbClosing := true;
  try
    for i := 0 to sLstGroups.Count -1 do
      TGenericItem(sLstGroups.Objects[i]).Free;
    sLstGroups.Free;
    for i := 0 to sLstUsers.Count -1 do
      TGenericItem(sLstUsers.Objects[i]).Free;
    sLstUsers.Free;
    for i := 0 to sLstShares.Count -1 do
      TGenericItem(sLstShares.Objects[i]).Free;
    sLstShares.Free;
    //TODO URGENT!!! They must be cleared first!!
    sLstData.Free;
  except
    ;//nothing, we're leaving..
  end;
end;

procedure TfrmMain.btnRefreshAllClick(Sender: TObject);
var
  Str: String;
begin
    Str := 'Oups! You''re gonna loose all customizations.' + #13#10 +
      'Are you sure you want to refresh all configuration informations?';
    if Windows.MessageBox(Application.Handle, PChar(str), PChar('Refresh All?'),
      MB_APPLMODAL or MB_ICONQUESTION or MB_YESNO) = IDYES then
    begin
      glbError := '';
      if ((not InitSysInfo()) or (glbError <> '')) then
      begin
        Windows.MessageBox(Application.Handle, PChar (glbError), PChar ('Error!'),
          MB_APPLMODAL or MB_ICONSTOP or MB_OK);
        Application.Terminate;
      end else
      begin
        GetNic();
        cbxNicNameChange(Self);
        GetShares();
        GetGroups();
        GetUsers();
        RegistryReadPrinter();
      end;//if
    end;//if
end;

procedure TfrmMain.chkSmbWinsServerClick(Sender: TObject);
begin
  if chkSmbWinsServer.Checked then
  begin
    edtSmbWinsServer.Enabled := false;
    lblSmbWinsServer.Enabled := false;
  end else
  begin
    edtSmbWinsServer.Enabled := true;
    lblSmbWinsServer.Enabled := true;
  end;
end;

procedure TfrmMain.chkSmbWinsServerKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if chkSmbWinsServer.Checked then
  begin
    edtSmbWinsServer.Enabled := false;
    lblSmbWinsServer.Enabled := false;
  end else
  begin
    edtSmbWinsServer.Enabled := true;
    lblSmbWinsServer.Enabled := true;
  end;
end;

procedure TfrmMain.edtServerNameMigrateExit(Sender: TObject);
begin
  //if no servername name is given, we put the default one
  if (edtServerNameMigrate.Text = '') then
    edtServerNameMigrate.Text := edtServerName2.Text;
  edtSMBServerName.Text := edtServerNameMigrate.Text
end;

procedure TfrmMain.edtWINS1MigrateExit(Sender: TObject);
begin
  edtSmbWinsServer.text := edtWINS1.text;
end;

procedure TfrmMain.Button29Click(Sender: TObject);
begin
  frmScriptHints.Show();
end;

end.

