unit LibsUtils;

interface

Uses Windows, Classes, Forms, SysUtils, shellapi;

  function StrToken(var S: String; Separator: Char): String;
  procedure StrTokenToStrings(S: String; Separator: Char; List: TStrings);
  function SubstComma(str: String): String;
  function SubstSlashes(str: String): String;

var
  aProcess: THandle;

implementation

////////////////////////////////////////////////////////////////////////////////
function strToken(var S: String; Separator: Char): String;
//   Return the string "prefixed" by the separator
//   Modified from xproc
////////////////////////////////////////////////////////////////////////////////
var
  i: Word;
begin
  i:=Pos(Separator,S);
  if i<>0 then
  begin
    Result:=System.Copy(S,1,i-1);
    System.Delete(S,1,i);
  end else
  begin
    Result:=S;
    S:='';
  end;
end;
////////////////////////////////////////////////////////////////////////////////
procedure strTokenToStrings(S: String; Separator: Char; List: TStrings);
//   Return the strings separated by separator as a string list
//   Even when they are empty!!
////////////////////////////////////////////////////////////////////////////////
var
  Token: String;
begin
  List.Clear;
  Token:=strToken(S,Separator);
  while true do
  begin
    List.Add(Token);
    if S='' then
      break;
    Token:=strToken(S,Separator);
  end;
end;
////////////////////////////////////////////////////////////////////////////////
function SubstComma(str: String): String;
////////////////////////////////////////////////////////////////////////////////
var
  i: Integer;
begin
  result := str;
  for i := 1 to length(str) do
    if (result[i] = ',') then
      result[i] := ' ';
end;
////////////////////////////////////////////////////////////////////////////////
function SubstSlashes(str: String): String;
////////////////////////////////////////////////////////////////////////////////
var
  i: Integer;
begin
  result := str;
  for i := 1 to length(str) do
    if (result[i] = '\') then
      result[i] := '/';
end;
////////////////////////////////////////////////////////////////////////////////
end.
