unit Libs;

interface

uses Windows, Forms, Classes, SysUtils, Registry, LibsNT, ConsoleApp, LibsUtils;

  procedure FindMembersList(Criteria, Name, KindOf : string; var aList: TStringList);
  function GetAclDetails(share: string; var aList: TStringList): string;
  procedure GetGroups;
  procedure GetNic;
  procedure GetShares;
  procedure GetUsers;
  procedure RegistryReadPrinter;
  procedure RegistryReadTCP(NicNo : integer);
  procedure SaveFile(fName: string);

implementation

Uses FormMain;

////////////////////////////////////////////////////////////////////////////////
procedure FindMembersList(Criteria, Name, Kindof : string; var aList: TStringList);
////////////////////////////////////////////////////////////////////////////////
var
  i : integer;
  TmpList: TStringList;
begin
  if criteria = 'users' then
  begin
    if Kindof = 'LOCAL' then
    //Get local members list
    begin
      try
        //todo: we had to pass '' for servername in domain to get local shares
        //edtServerNameHidden.Text was working at some point see why?
        LocalGroupGetMembers('', name, aList);
      except
        Windows.MessageBox(Application.Handle, PChar ('Cannot get local group members for: '+ name), PChar ('Error!'),
          MB_APPLMODAL or MB_ICONSTOP or MB_OK);
        exit;
      end;//try
    end else
    //Get Global members list
    begin
      try
        GlobalGroupGetMembers(frmMain.edtServerNameHidden.Text, name, aList);
      except
        Windows.MessageBox(Application.Handle, PChar ('Cannot get global group members for: '+ name), PChar ('Error!'),
          MB_APPLMODAL or MB_ICONSTOP or MB_OK);
        exit;
      end;//try
    end;//if
  end else
  //Get Local and Global Groups list assoviated with a user
  begin
    try
      GetLocalGroups(frmMain.edtServerNameHidden.Text, name, aList);
    except
      Windows.MessageBox(Application.Handle, PChar ('Cannot get Local groups for: '+ name), PChar ('Error!'),
        MB_APPLMODAL or MB_ICONSTOP or MB_OK);
      exit;
    end;//try
    TmpList := TStringList.create;
    try
      try
        GetGlobalGroups(frmMain.edtServerNameHidden.Text, name, TmpList);
      except
        Windows.MessageBox(Application.Handle, PChar ('Cannot get global groups for: '+ name), PChar ('Error!'),
          MB_APPLMODAL or MB_ICONSTOP or MB_OK);
        exit;
      end;//try
      //we consolidate all items from TmpList into aList
      if TmpList.Count > 0 then
        for i := 0 to TmpList.Count - 1 do
          aList.Add(TmpList[i]);
    finally
      TmpList.free;
    end;//try
  end;//if
end;
////////////////////////////////////////////////////////////////////////////////
function GetAclDetails(share: string; var aList: TStringList): string;
////////////////////////////////////////////////////////////////////////////////
var
  SD        : array[0..200] of Integer; { security descriptor }
  I,J,K,L   : Dword; //Integer;
  B,B2,B3   : Bool;
  ACL       : PACL;
  ACE       : Pointer;
  SID       : Pointer;
  AM        : Integer; { access mask }
  iPos      : Integer;
  Name,Dom  : array[0..100] of Char;
  Str1, Str2: String;
  sLstNames, sLstRights, sLstDoms, sLstAD: TStringList;
begin
  result := '';
  sLstNames := TStringList.Create;
  sLstRights := TStringList.Create;
  sLstDoms := TStringList.Create;
  sLstAD := TStringList.Create;
  try
    B := GetFileSecurity(PChar(Share),DACL_Security_Information,@SD,SizeOf(SD),I);
    if (not B) then
      raise Exception.Create('Problem with GFS ('+IntToStr(GetLastError)+').');
    B := GetSecurityDescriptorDACL(@SD,B2,ACL,B3);
    if (not B) Then
      raise Exception.Create('Problem with GSDD ('+IntToStr(GetLastError)+').');

    if (ACL <> nil) then
    begin
      for J := 0 to ACL.ACECount-1 do
      begin
        B := GetACE(ACL^,J,ACE);
        if (not B) then
          raise Exception.Create('Problem with GA ('+IntToStr(GetLastError)+').');
        If (TACEHeader(ACE^).ACEType = Access_Allowed_ACE_Type) then
        begin
          SID := @TAccessAllowedACE(ACE^).SIDStart;
          AM := TAccessAllowedACE(ACE^).Mask;
          B2 := True;
        end else
        begin
          SID := @TAccessDeniedACE(ACE^).SIDStart;
          AM := TAccessDeniedACE(ACE^).Mask;
          B2 := False;
        end;//if
        I := SizeOf(Name); K := SizeOf(Dom);
        B := LookupAccountSID('',SID,Name,I,Dom,K,L);
        If (not B) then
          raise Exception.Create('Problem with LAS ('+IntToStr(GetLastError)+', '+IntToStr(GetLastError)+').');
        //check if already listed..
        iPos := sLstNames.IndexOf(Name);
        Str1 := GetAccessRights(AM);
        if (iPos > -1) then
        begin
          Str2 := sLstRights[iPos];
          //resolve so we get the "weakest" rights
          if ((Str2[1] = '-') and (Str1[1] <> '-')) then
            Str2[1] := Str1[1];
          if ((Str2[2] = '-') and (Str1[2] <> '-')) then
            Str2[2] := Str1[2];
          if ((Str2[3] = '-') and (Str1[3] <> '-')) then
            Str2[3] := Str1[3];
          sLstRights[iPos] := Str2;
          continue;
        end else
        begin
          if B2 then
            sLstAD.Add('(A) ')
          else
            sLstAD.Add('(D) ');
          sLstNames.Add(Name);
          sLstRights.Add(Str1);
          sLstDoms.Add(Dom);
        end;
      end;//for
      if (sLstNames.Count > 0) then
        for j := 0 to sLstNames.Count - 1 do
          aList.Add(sLstNames[j] +'|'+ sLstDoms[j] +'|'+ sLstAD[j] +'|'+ sLstRights[j]);
    end else
      result := 'No security (FAT partition?)';
  finally
    sLstNames.free;
    sLstRights.free;
    sLstDoms.free;
    sLstAD.free;
  end;//try
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetGroups;
////////////////////////////////////////////////////////////////////////////////
var
  i, k : integer;
  p : PChar;
  localgroups, globalgroups: TStringList;
  MembersList : TStringList;
begin
  localgroups := TStringList.Create;
  localgroups.Duplicates := dupIgnore;
  localgroups.Sorted := true;
  globalgroups := TStringList.Create;
  globalgroups.Duplicates := dupIgnore;
  globalgroups.Sorted := true;

  //Temporary list for sublist..
  MembersList := TStringList.create;
  MembersList.Duplicates := dupIgnore;
  MembersList.Sorted := false;

  with frmMain do
  begin
    //Clear the global group list
    for i := 0 to sLstGroups.Count -1 do
      TGenericItem(sLstGroups.Objects[i]).Free;
    sLstGroups.Clear;
    lvGroups.Items.Clear;

    try
      try
        // Gets ID+#0+Description
        GetLocalGroupsDetails(edtServerNameHidden.Text, localGroups);
      except
        Windows.MessageBox(Application.Handle, PChar ('Cannot get local groups'), PChar ('Error!'),
          MB_APPLMODAL or MB_ICONSTOP or MB_OK);
        exit;
      end;//try
      try
        // Gets ID+#0+Description+#0+RID
        GetGlobalGroupsDetails(edtServerNameHidden.Text, globalGroups);
      except
        Windows.MessageBox(Application.Handle, PChar ('Cannot get global groups'), PChar ('Error!'),
          MB_APPLMODAL or MB_ICONSTOP or MB_OK);
        exit;
      end;//try
      for i := 0 to localGroups.count - 1 do
        with lvGroups.Items.Add do
        begin
          p := @localGroups[i][1];
          //wee add "L" at the beginning to differenciate between
          //Global and LocalGroups
          FindMembersList('users', p, 'LOCAL', MembersList);
          //strip the domains..
          for k := 0 to MembersList.Count - 1 do
            MembersList[k] := StripDomain(MembersList[k]);
          MembersList.Sorted := true;
          sLstGroups.AddObject('L'+UpperCase(p), TGenericItem.create(MembersList));
          Caption := p;            // Extract group name
          Inc(p, lstrlen(p) + 1);
          SubItems.Add(p);         // Extract group description
          SubItems.Add('LOCAL');
          //No Group ID available in the structure..
          SubItems.Add('');
          MembersList.Sorted := false;
        end;
      MembersList.Clear;
      for i := 0 to globalGroups.count - 1 do
        with lvGroups.Items.Add do
        begin
          p := @globalGroups[i][1];
          //wee add "G" at the beginning to differenciate between
          //Global and LocalGroups
          FindMembersList('users', p, 'GLOBAL', MembersList);
          for k := 0 to MembersList.Count - 1 do
            MembersList[k] := StripDomain(MembersList[k]);
          MembersList.Sorted := true;
          sLstGroups.AddObject('G'+UpperCase(p), TGenericItem.create(MembersList));
          Caption := p;            // Extract group name
          Inc(p, lstrlen(p) + 1);
          SubItems.Add(p);         // Extract group description
          SubItems.Add('GLOBAL');
          //we want to get the group ID
          Inc(p, lstrlen(p) + 1);
          SubItems.Add(p);
          MembersList.Sorted := false;
        end;
     finally
      localgroups.free;
      globalgroups.free;
      MembersList.Free;
    end;//try
  end;//with
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetNic;
////////////////////////////////////////////////////////////////////////////////
var
  i : integer;
  keys: TStringList;
begin

  keys := TStringList.Create;
  with TRegistry.create do
    try
      RootKey := HKEY_LOCAL_MACHINE;
      if OpenKey('\SOFTWARE\Microsoft\Windows NT\CurrentVersion\NetworkCards', false) then
      begin
        GetKeyNames(keys);
        CloseKey;
        frmMain.cbxNicName.Items.Clear;
        frmMain.lbNicName.Items.Clear;
        for i := 0 to keys.count -1 do
          if OpenKey('\SOFTWARE\Microsoft\Windows NT\CurrentVersion\NetworkCards' + '\' + keys[i], false) then
            if Not ValueExists('Hidden') then
            begin
              frmMain.cbxNicName.Items.Add(ReadString('Title'));
              frmMain.lbNicName.Items.Add(ReadString('Title'));
              nics := nics + keys[i];
            end;
      end;//if
      frmMain.cbxNicName.ItemIndex := 0;
      frmMain.lbNicName.ItemIndex := 0;
      frmMain.lbNicName.Selected[0] := true;
    finally
      CloseKey;
      keys.free;
      free;
    end;
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetShares;
////////////////////////////////////////////////////////////////////////////////
var
  n, size: integer;
  buff : array[0..255] of char; //PChar;
  tmpbuff, shtype, shpath, shremark, shperm, shmaxuse : string;
  i: Integer;
  keys: TStringList;
  MembersList : TStringList;
begin
  keys := TStringList.Create;

  //Temporary list for sublist..
  MembersList := TStringList.create;
  MembersList.Duplicates := dupIgnore;
  MembersList.Sorted := true;

  with frmMain do
  begin
    //Clear the global group list
    for i := 0 to sLstShares.Count -1 do
      TGenericItem(sLstShares.Objects[i]).Free;
    sLstShares.Clear;

    lvshares.Items.Clear;
    with TRegistry.create do
      try
        RootKey := HKEY_LOCAL_MACHINE;
        if OpenKey('\System\CurrentControlSet\Services\LanmanServer\Shares', false) then
          GetValueNames(keys);

        for i := 0 to keys.count - 1 do
          with lvshares.Items.Add do
          begin
            shtype := '';
            shpath := '';
            shremark := '';
            shperm := '';
            shmaxuse := '';
            size := GetDataSize(keys[i]);
            ReadBinaryData(keys[i], buff, size);
            n := 0;
            while (n <= size - 4) do
            begin
              if buff[n] <> '=' then
              begin
                tmpbuff := tmpbuff + buff[n];
                if buff[n] = #0 then
                  tmpbuff := '';
              end else
              begin
                if (tmpbuff = 'MaxUses') then
                  while (buff[n+1] <> #0) do
                  begin
                    shmaxuse := shmaxuse + buff[n+1];
                    Inc(n);
                  end;//while
                if tmpbuff = 'Path' then
                  while (buff[n+1] <> #0) do
                  begin
                    shpath := shpath + buff[n+1];
                    Inc(n);
                  end;//while
                if tmpbuff = 'Permissions' then
                  while (buff[n+1] <> #0) do
                  begin
                    shperm := shperm + buff[n+1];
                    Inc(n);
                  end;//while
                if tmpbuff = 'Remark' then
                  while (buff[n+1] <> #0) do
                  begin
                    shremark := shremark + buff[n+1];
                    Inc(n);
                  end;//while
                if tmpbuff = 'Type' then
                begin
                  while (buff[n+1] <> #0) do
                  begin
                    shtype := shtype + buff[n+1];
                    Inc(n);
                  end;//while
                  if shtype = '0' then
                    shtype := 'Folder'
                  else
                    shtype := 'Print';
                end;//if
                tmpbuff := '';
              end;//if
              Inc(n);
            end;//while
            Caption := keys[i];
            SubItems.Add (Shtype);
            SubItems.Add (Shpath);
            SubItems.Add (Shremark);
          end;//with
    //        for k := 0 to MembersList.Count - 1 do
    //          MembersList[k] := StripDomain(MembersList[k]);
    //        MembersList.Sorted := true;
    //        sLstGroups.AddObject('L'+UpperCase(p), TGenericItem.create(MembersList));
      finally
        keys.free;
        CloseKey;
        Free;
        MembersList.Free;
      end; //try
  end;//with
end;
////////////////////////////////////////////////////////////////////////////////
procedure GetUsers();
////////////////////////////////////////////////////////////////////////////////
var
  i : integer;
  p : PChar;
  Users: TStringList;
  MembersList: TStringList;
begin
  Users := TStringList.Create;
  Users.Duplicates := DupIgnore;
  Users.Sorted := True;

  //Temporary list for sublist..
  MembersList := TStringList.create;
  MembersList.Duplicates := dupIgnore;
  MembersList.Sorted := true;
  with frmMain do
  begin
    //Clear the global users list
    for i := 0 to sLstUsers.Count -1 do
      TGenericItem(sLstUsers.Objects[i]).Free;
    sLstUsers.Clear;
    lvUsers.Items.Clear;
    try
      try
        GetUsersList(edtServerNameHidden.Text, FILTER_NORMAL_ACCOUNT, users);
      except
        Windows.MessageBox(Application.Handle, PChar ('Cannot get Users'), PChar ('Error!'),
          MB_APPLMODAL or MB_ICONSTOP or MB_OK);
        exit;
      end;//try
      for i := 0 to Users.count - 1 do
        try
          with lvusers.Items.Add do
          begin
            p := @users[i][1];
            FindMembersList('groups', p, '', MembersList);
  //todo see if uppercase required..
            sLstUsers.AddObject(UpperCase(p), TGenericItem.create(MembersList));
            Caption := p;      // Extract user name
            Inc(p, lstrlen(p) + 1);
            SubItems.Add(p);   // Extract full name
            Inc(p, lstrlen(p) + 1);
            SubItems.Add(p);   // Extract comment
          end;
        except
          continue;
        end;//try
     finally
       Users.free;
     end;//try
   end;//with
end;
////////////////////////////////////////////////////////////////////////////////
procedure RegistryReadPrinter;
////////////////////////////////////////////////////////////////////////////////
var
  i, n : integer;
  p : PChar;
  printername, sharename, printerdriver, printerport, printertype, printermodel : string;
  keys: TStringList;
begin
  frmMain.lvprinter.Items.Clear;
  keys := Tstringlist.Create;
  with TRegistry.create do
    try
      RootKey := HKEY_LOCAL_MACHINE;
      if OpenKey('\System\CurrentControlSet\Control\Print\Printers', false) then
        GetKeyNames(keys);

      CloseKey;

      for i := 0 to keys.count - 1 do
        with frmMain.lvprinter.Items.Add do
        begin
          if OpenKey('\System\CurrentControlSet\Control\Print\Printers' + '\' + keys[i], false) then
          begin
            printername := keys[i];
            sharename := ReadString('Share Name');
            printertype := ReadString('Datatype');
            printerdriver := ReadString('Printer Driver');
            printerport := ReadString('Port');
            p := @printername[1];
            for n := 0 to strlen (p) do
              if printername[n] = ',' then
                printername[n] := '\';
            CloseKey;
          end;//if

          if OpenKey('\System\CurrentControlSet\Control\Print\Printers' + '\' + keys[i] + '\PrinterDriverData', false) then
            printermodel := ReadString('Printer Model Name');

          CloseKey;
          //todo: if sharename <> '' then (aller chercher les comments du printer)
          Caption := printername;
          SubItems.Add (printermodel);
          SubItems.Add (printerport);
          SubItems.Add (printertype);
          SubItems.Add (printerdriver);
          SubItems.Add (sharename);
        end;//with
    finally
      Keys.free;
      CloseKey;
      Free;
    end; //try
end;
////////////////////////////////////////////////////////////////////////////////
procedure RegistryReadTCP(NicNo : integer);
////////////////////////////////////////////////////////////////////////////////
var
 i, k: Integer;
 Buff1, Buff2, Buff3 : array[0..255] of Char;
 Buffdes1, Buffdes2: array[0..255] of Char;

 bDHCP: Boolean;
 iSize: Integer;
 Str, ServiceName: String;
 keys: TStringList;
 Str1, Str2: String;
 offset1, offset2: Integer;
begin
  keys := TStringList.Create;
  bDHCP := false;//just to keep compiler happy..

  with TRegistry.Create do
    try
      RootKey := HKEY_LOCAL_MACHINE;
      if OpenKey('\SOFTWARE\Microsoft\Windows NT\CurrentVersion\NetworkCards\' + nics[NicNo], false) then
        ServiceName := ReadString('ServiceName');
      Closekey;

      if OpenKey('\System\CurrentControlSet\Services\' + servicename + '\Parameters\Tcpip', false) then
      begin
        bDHCP := (readinteger('EnableDHCP') = 1);
        iSize := GetDataSize('SubnetMask');
        ReadBinaryData('SubnetMask', buff2, iSize);
        iSize := GetDataSize('IPAddress');
        ReadBinaryData('IPAddress', buff1, iSize);
        if bDHCP then
        begin
          Str := readstring('DhcpIpAdress');
          StrMove(buff1, @Str[1], length(Str)); //buff := StrPCopy(Str);
          Str := readstring('DhcpSubnetMask');
          StrMove(buff2, @Str[1], length(Str));
        end;
        frmMain.lvIP.Items.Clear;
        //We get the IPs and SubMasks, 5 max per adaptor.
        offset1 := 0;
        offset2 := 0;
        for i := 1 to 5 do
        begin
          StrECopy(buffdes1, @buff1[Offset1]);
          Str1 := buffdes1;
          Offset1 := Offset1 + Length(Str1) + 1;
          StrECopy(buffdes2, @buff2[OffSet2]);
          Str2 := buffdes2;
          Offset2 := Offset2 + Length(Str2) + 1;
          if (Str1 = '') then
            break;
          with frmMain.lvIP.Items.Add do
          begin
            Caption := Str1;
            SubItems.Add(Str1);
          end;//with
        end;

        if bDHCP then
        begin
          iSize := GetDataSize('DHCPDefaultGateway');
          ReadBinaryData('DHCPDefaultGateway', buff1, iSize);
        end else
        begin
          iSize := GetDataSize('DefaultGateway');
          ReadBinaryData('DefaultGateway', buff1, iSize);
        end;
        frmMain.edtGateway.text := '';
        for i := 0 to iSize - 2 do
          if (buff1[i] = #0) then
          begin
            if (buff1[i + 1] <> #0) then
              frmMain.edtGateway.text := frmMain.edtGateway.text + ' - ';
          end else
            frmMain.edtGateway.text := frmMain.edtGateway.text + buff1[i];
      end;//if

      CloseKey;

      if OpenKey('\System\CurrentControlSet\Services\Tcpip\Parameters', false) then
      begin
        if bDHCP then
          frmMain.edtNicHostName.Text := frmMain.edtGateway.text + ReadString('DhcpDomain')
        else
          frmMain.edtNicHostName.Text := frmMain.edtHostName.Text;

        Str := ReadString('NameServer');
        for i := 0 to (length(Str) - 1) do
          Buff3[i] := Str[i + 1];

        frmMain.edtDNS1.text := '';
        frmMain.edtDNS2.text := '';
        Str1 := '';
        Str2 := '';
        k := 0;
        for i := 0 to (length(Str) - 1) do
          if Buff3[i] = ' ' then
            k := 1
          else
            if (k = 0) then
              Str1 := Str1 + Buff3[i]
            else
              Str2 := Str2 + Buff3[i];
        frmMain.edtDNS1.text := Str1;
        frmMain.edtDNS2.text := Str2;

        if bDHCP then
          frmMain.edtDNS1.text := ReadString('DhcpNameServer') + frmMain.edtDNS1.text;
      end;
      CloseKey;

      frmMain.edtWINS1.text := '';
      frmMain.edtWINS2.text := '';
      if OpenKey('\System\CurrentControlSet\Services\Netbt\Adapters\' + servicename, false) then
      begin
        frmMain.edtWINS1.text := ReadString('NameServer');
        frmMain.edtWINS2.text := ReadString('NameServerBackup');
        //Update the samba section
        frmMain.edtWINS1Migrate.text := frmMain.edtWINS1.text;
        frmMain.edtSmbWinsServer.text := frmMain.edtWINS1.text;
      end;
      CloseKey;
    finally
      Free;
      keys.free;
    end; //try
end;
////////////////////////////////////////////////////////////////////////////////
procedure SaveFile(fName: string);
////////////////////////////////////////////////////////////////////////////////
var
  Fi: TextFile;
  str: TStringList;
  str1: String;
  i, t, k, tt: Integer;
  TmpPath: string;
  sLst: TStringList;
  sLstPassword: TStringList;
  sLstTmp: TStringList;
  iPos: Integer;
  uName: String;
  TmpStr: String;
begin
  str := TStringList.Create;

  with frmMain do
  begin
    AssignFile(Fi, fName);
    Rewrite(Fi);
    //Global section
    write(Fi, '[global]' + #10);
    write(fi, 'root=' + edtOutputPath.text + #10);
    write(fi, 'homes=' + edtHomesOutputPath.text + #10);
    if chkNetwork.Checked then
    begin
      write(Fi, '[network]' + #10);
    //TCP/IP setting
      if ((rgTCP.ItemIndex = 0) or (rgTCP.ItemIndex = 1)) then
      begin
        write(fi, 'domain=' + edtDomain2.text + #10);
        write(fi, 'hostname=' + edtHostName.text + #10);
        write(fi, 'gateway=' + edtGateway.text + #10);
        write(fi, 'dns1=' + edtDNS1.text + #10);
        write(fi, 'dns2=' + edtDNS2.text + #10);
      end;

      //Netbios setting
      if ((rgTCP.ItemIndex = 0) or (rgTCP.ItemIndex = 2)) then
      begin
        if (UpperCase(edtServerName.text) <> UpperCase(edtNTDomain.text)) then
          write(fi, 'ntdomain='+ edtNTDomain.text + #10)
        else
          write(fi, 'ntdomain=' + #10);
        write(fi, 'ntservername=' + edtServerName.text + #10);
      end;
    end;//if chkNetwork

    if chkSamba.Checked then
    begin
      //Global Samba section
      write(Fi, '[global-samba]' + #10);

      if chkSmbWinsServer.Checked then
      begin
        write(fi, 'wins support = yes' + #10);
        write(fi, 'wins server = none' + #10);
      end else
      begin
        write(fi, 'wins support = no' + #10);
        //if wins support = no then samba can refer to a wins server
        if edtWINS1Migrate.text = '' then
          write(fi, 'wins server = none' + #10)
        else
          write(fi, 'wins server = ' + edtWINS1Migrate.text + #10);
      end;//if
      write(fi, 'name resolve order = ' + edtSMBResolve.text + #10);
      write(fi, 'server string = ' + edtSmbServerString.text + #10);
    end;//if chkSamba

    try
      if chkGroups.Checked then
        with Lvgroups do
        begin
          Write(Fi, '[groups]' + #10);
          for i := 0 to Items.Count - 1 do
          begin
            str.Clear;
            // Add Each Item's Caption
            str.Add(SubstNetbiosChar(StripDomain(Items[i].Caption)));
            // Add Each Item's SubItem
            for t := 0 to Columns.Count - 2 do      // For each column...
              if Items[i].SubItems.Count > t then // if SubItem exists,
                str.Add(Items[i].SubItems[t])       // add it
              else
                break;                         // otherwise, go to next item (if any)
            // Save to File
            Write(Fi, '=>' + str.CommaText + #10);
            if items[i].SubItems[1] = 'LOCAL' then
              iPos := sLstGroups.IndexOf('L' + UpperCase(items[i].Caption))
            else
              iPos := sLstGroups.IndexOf('G' + UpperCase(items[i].Caption));
            for k := 0 to (TGenericItem(sLstGroups.Objects[iPos]).count - 1) do
            begin
              str1 := TGenericItem(sLstGroups.Objects[iPos])[k];
              if ((str1 <> '') and (str1 <> 'ERROR')) then
                write(fi, '->' + SubstNetbiosChar(str1) + #10);
            end;//for
          end;//for
        end;//with

      if chkUsers.Checked then
        with Lvusers do
        begin
          sLst := TStringList.Create;
          sLstPassword := TStringList.Create;
          try
            if chkbPWDump.Checked then
            begin
              ExecConsoleApp(ExtractFilePath(ParamStr(0))+'pwdump.exe','', sLst, nil);
              for iPos := 0 to sLst.count -1 do
                if sLst[iPos] = '' then
                  sLst.delete(iPos)
                else
                begin
                  sLstPassword.add(sLst[iPos]);
                  TmpStr := sLst[iPos];
                  sLst[iPos] := UpperCase(strToken(TmpStr, ':'));
                end;
            end;

            Write(Fi, '[users]' + #10);
            for i := 0 to Items.Count - 1 do
            begin
              str.Clear;
              // Add Each Item's Caption
              uName := StripDomain(Items[i].Caption);
              Case rgUsersCase.ItemIndex of
                0: uName := uppercase(uName);
                1: uName := lowercase(uName);
              end;
              str.Add(SubstNetbiosChar(uName));
              // Add Each Item's SubItem
              for t := 0 to Columns.Count - 2 do      // For each column...
                if Items[i].SubItems.Count > t then // if SubItem exists,
                  str.Add(SubstComma(Items[i].SubItems[t]))       // add it
                else
                  break;                         // otherwise, go to next item (if any)
              if (chkbPWDump.Checked) then
              begin
                iPos := sLst.IndexOf(UpperCase(uName));
                if (iPos > -1) then
                begin
                  sLstTmp := TStringList.Create;
                  try
                    strTokenToStrings(sLstPassword[iPos], ':', sLstTmp);
                    Write(Fi, '=>' + str.CommaText + ',' + sLstTmp[2] + ',' + sLstTmp[3] + #10)
                  finally
                    sLstTmp.free;
                  end;//try
                end else
                  Write(Fi, '=>' + str.CommaText + ',' + #10);
              end else
              begin
                Write(Fi, '=>' + str.CommaText + ',' + #10);
              end;//if
            end;//for
          finally
            sLst.free;
            sLstPassword.free;
          end;
        end;//with

      if chkShares.Checked then
        with Lvshares do
        begin
          Write(Fi, '[shares]' + #10);
          for i := 0 to Items.Count - 1 do
          begin
            str.Clear;
            // Add Each Item's Caption
            str.Add(SubstNetbiosChar(Items[i].Caption));
            // Add Each Item's SubItem
            for t := 0 to Columns.Count - 2 do      // For each column...
              if Items[i].SubItems.Count > t then // if SubItem exists,
                str.Add(Items[i].SubItems[t])       // add it
              else
                break;                         // otherwise, go to next item (if any)
            Write(Fi, '=>' + str.CommaText + #10);
            try
              lvSharesSelectItem(frmMain, items[i],true);
            except
              Continue; //todo log
            end;
            with Lvacls do
            begin
              for k := 0 to Items.Count - 1 do
              begin
                str.Clear;
                // Add Each Item's Caption
                str.Add(SubstNetbiosChar(Items[k].Caption));
                // Add Each Item's SubItem
                for tt := 0 to Columns.Count - 2 do      // For each column...
                  if Items[k].SubItems.Count > tt then // if SubItem exists,
                    str.Add(SubstComma(Items[k].SubItems[tt]))       // add it
                  else
                    break;                         // otherwise, go to next item (if any)
                write(fi, '->' + str.CommaText + #10);
              end;//for
            end;//with
          end;//for
        end;//with

      if chkPrinters.Checked then
        with Lvprinter do
        begin
          Write(Fi, '[printers]' + #10);
          for i := 0 to Items.Count - 1 do
          begin
            str.Clear;
            // Add Each Item's Caption
            str.Add(SubstNetbiosChar(Items[i].Caption));
            // Add Each Item's SubItem
            for t := 0 to Columns.Count - 2 do      // For each column...
              if Items[i].SubItems.Count > t then // if SubItem exists,
                str.Add(SubstComma(Items[i].SubItems[t]))       // add it
              else
                break;                         // otherwise, go to next item (if any)
            Write(Fi, '=>' + str.CommaText + #10);
          end;//for
        end;//with

      if chkData.Checked then
        with Lvdata do
        begin
          Write(Fi, '[data]' + #10);
          for i := 0 to Items.Count - 1 do
          begin
            str.Clear;
            //todo: URGENT validate that the input box accept only unix type slashes...
            // Add Each Item's Caption
            TmpPath := Items[i].Caption;
    //        OutputPath := edtOutputPath.text;
    //        if OutputPath[length(OutputPath)] = '/' then
    //          TmpPath := OutputPath + lowercase(TmpPath[1]) + '/' + SubstSlashes(Copy(TmpPath, 4, Length(TmpPath)-3))
    //        else
    //          TmpPath := OutputPath + '/' + lowercase(TmpPath[1]) + '/' + SubstSlashes(Copy(TmpPath, 4, Length(TmpPath)-3));
            //we lowercase all path names..
            str.Add(lowercase(TmpPath));
            // Add Each Item's SubItem
            for t := 0 to Columns.Count - 2 do      // For each column...
              if Items[i].SubItems.Count > t then // if SubItem exists,
                str.Add(Items[i].SubItems[t])       // add it
              else
                break;                         // otherwise, go to next item (if any)
            Write(Fi, '=>' + str.CommaText + #10);
            lvdataSelectItem(frmMain, items[i],true);
            with Lvacl do
            begin
              for k := 0 to Items.Count - 1 do
              begin
                str.Clear;
                // Add Each Item's Caption
                str.Add(Items[k].Caption);
                // Add Each Item's SubItem
                for tt := 0 to Columns.Count - 2 do      // For each column...
                  if Items[k].SubItems.Count > tt then // if SubItem exists,
                    str.Add(SubstComma(Items[k].SubItems[tt]))       // add it
                  else
                    break;                         // otherwise, go to next item (if any)
                write(fi, '->' + str.CommaText + #10);
              end;//for
            end;//with
          end;//for
        end;//with
    finally
      CloseFile(Fi);
      str.Free;
    end;//try
  end;//with frmMain
end;
////////////////////////////////////////////////////////////////////////////////
end.
