/*
 *  transfer_bf.c
 * 
 *  Copyright 1997,8,9 2002 by Allan Latham <alatham@flexsys-group.com>  
 *
 *  Redistribution of this file is permitted under the GNU Public License.
 *
 *  Derived in part from the works of other authors who made those works
 *  available for use under GNU Public Licence.
 * 
 */

#include <linux/ppdd.h>

int transfer_bf(struct ppdd_keys *keys, int cmd, 
                       const unsigned char *in8, unsigned char *out8,
                       int size, const unsigned long posf)
{

    unsigned long  pos, posk, posw, posv;
    unsigned long whitew, whitev;
    unsigned char *pBlock;

    pos = posf;

    while (size > 0) {
        if (pos > 1) {
            posk = pos % 17;
            posw = pos % 61;
            posv = pos % 59;
            whitew = keys->whitev[posw];
            whitev = keys->whitev[posv];
            if (cmd == PPDDDECRYPT) {
                Blowfish_Decrypt_cbc(keys->key[posk],
                    in8+248, in8+256, out8+256, 256);
                Blowfish_Decrypt_cbc(keys->key[posk],
                    out8+504, in8, out8, 256);
                ppdd_unscramble(128, (unsigned long *)out8,
						(unsigned long *)out8, 
						whitew, whitev, pos);
            } else {
                ppdd_scramble(128, (const unsigned long *)in8,
						(unsigned long *)out8,
						whitew, whitev, pos);
                Blowfish_Encrypt_cbc(keys->key[posk],
                    out8+504, out8, out8, 512);
            }
	} else {
            pBlock = keys->block0;
            if (pos) {
                pBlock = keys->block1;
            } 
            memcpy(out8, pBlock, 512);
        }
        size--;
        in8 += 512;
        out8 += 512;
        pos++;
    }
    return 0;
}
