/*
 * readoldpass.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>

#include "ppddmount.h"

void readoldpass(const char* ppfile, 
                        int *len1, unsigned char *passphrase1,
		  	int *len2, unsigned char *passphrase2)
{
	char	*progname = "readoldpass";
	FILE	*pfile;

	pfile = fopen (ppfile, "r");
	
	if (pfile == NULL) {
		PPDDERROR(551)
		*len1 = 0;
		*len2 = 0;
		return;
	}

	memset(passphrase1+8,0,120);
	memset(passphrase2+8,0,120);
	
	if (fgets(passphrase1+8,120,pfile)) {
		*len1 = strlen(passphrase1+8) - 1;
	} else {
		*len1 = 0;
	}

	if (fgets(passphrase2+8,120,pfile)) {
		*len2 = strlen(passphrase2+8) - 1;
	} else {
		*len2 = 0;
	}

	fclose(pfile);
}
