/*
 * ppdderror.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <errno.h>
#include "ppddmount.h"
#include "ppdderror.h"

void ppdderror(int ppdderrno, const char *progname, const char *mess)
{
	int 	i,j,k;
	char 	*errmess, *tdate;
	time_t 	t;

	k = -1;
	for(i=0;k == -1;i++) {
 		if (errmsg[i][0] == '~') {
			k = i;
		} else {
 			j = ((errmsg[i][0] - '0') * 100)
 		  	+ ((errmsg[i][1] - '0') * 10)
 		  	+ (errmsg[i][2] - '0');
			if (j == ppdderrno) k = i;
		}
	}

	errmess = &errmsg[k][3];
	t = time(NULL);
	tdate = ctime(&t);

	fprintf(stderr, "Date    : %sProgram : %s\nError   : %d - %s\n",
			tdate, progname, ppdderrno, errmess);
	if (errno) perror("Detail  ");
	if (mess) fprintf(stderr, "%s\n", mess);
	fprintf(stderr, "\n");
}

