/*
 * ppddenter.c
 *
 * Copyright 2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "ppddmount.h"

static char *progname;

static int write_ppddtab(char *pDevice, char *pFile)
{
	int len1;
	int len2;
	char pass1[128];
	char pass2[128];
	FILE *f;

	getoldpass(&len1, pass1, &len2, pass2);

	if (!(len1 && len2)) return 1;

	umask(0777);
	f = fopen("/etc/ppddtab","w");
	if (!f) return 1;

	pass1[len1+8] = 0;
	pass2[len2+8] = 0;
	fprintf (f, "n %s %s \"%s\" \"%s\"\n", pDevice, pFile, pass1+8, pass2+8);
	fclose(f);
	return 0;
}

static int usage(void)
{
	fprintf(stderr, "usage:  %s loop_device file|device\n\n" , progname);
	exit(1);
}

int main(int argc, char **argv)
{
	progname = "ppddenter";
	ppdd_intro(progname);

	if (argc != 3) {
	    usage();
        }
        return(write_ppddtab(argv[argc-2], argv[argc-1]));
	exit (1); 
}

