/*
 * make_key_16.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>

#include "ppddmount.h"

void make_key_16(unsigned char *key, unsigned char *iv,
					int *len1, unsigned char *passphrase1,
					int *len2, unsigned char *passphrase2)
{
	Blowfish_Key 		bkey;
	int			len,i,j,k;

/* copy the seed into the first part of the first pass phrase */

	memcpy(passphrase1, iv, 8);

	len = *len1 + 8;

/* limit first pass phrase to 112 chars */

	if (len > 112) 
		len = 112;

/* if it is more than 56 chars (max for blowfish) fold it */

	if (len > 56) {
		for(i = 56; i < len; i++) {
			passphrase1[i - 56] ^= passphrase1[i];
		}
		len = 56;
	}

/* make a key from the first pass phrase */

	Blowfish_ExpandUserKey(passphrase1, len, bkey);

/* encrypt the original seed as an iv for the cbc encrypt of pass phrase 2 */

	Blowfish_Encrypt(iv, passphrase2, bkey);

	len = *len2 + 8;

/* if pass phrase 2 is too short pad it with the original seed */

	if (len < 16) {
		memcpy(&passphrase2[len], iv, 8);
		len = 16;
	}

/* ensure that there is trailing padding too */

	memcpy(&passphrase2[len], iv, 8);

/* cbc encrypt pass phrase 2 */

	for(j = 8; j < len; j += 8)
	{
	    i = j - 8;
	    for(k = 0; k < 8; k++)
	    {
		passphrase2[j + k] ^= passphrase2[i + k];
	    }
	    Blowfish_Encrypt(&passphrase2[j], &passphrase2[j], bkey);
	}

/* use the last two encrypted cipherblocks as the final result key */

	memcpy(key, &passphrase2[len - 16], 16);

/* clear memory */

	memset(passphrase1, 0, sizeof(passphrase1));
	memset(passphrase2, 0, sizeof(passphrase2));
	memset(bkey, 0, sizeof(bkey));
	*len1 = 0;
	*len2 = 0;
	len = 0;
	i = 0;
	j = 0;
	k = 0;
}
