/*
 *  make_crc.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>

#include "ppddmount.h"

int make_crc (struct crypt_control_block *cblock, int check)
{
	int		ok = 1;
        unsigned long 	crc;

	crc = crc32((unsigned char*)cblock, CBXLENGTH);

	if (check == PPDD_CRC_CHECK) {
		ok = memcmp(cblock->crc, &crc, 4);
	} else {
		memcpy(cblock->crc, &crc, 4);
	}
	crc = 0;
	return(ok);
}
