/*
 * getnewpass.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <unistd.h>

#include "ppddmount.h"

int getnewpass(int master, int *len1, unsigned char *passphrase1,
				  int *len2, unsigned char *passphrase2)
{
	int 	len;
	char	*pass;

	if (master) {
		pass = getpass("New first master pass phrase: ");
	} else {
		pass = getpass("New first working pass phrase: ");
	}
	len = strlen(pass);
	if (len == 0) 
		return -1;
	if (len < 4) {
	        fprintf(stderr, "Error: Pass phrases too short.\n");
		memset(pass, 0, strlen(pass));
		return 0;
	}
	if (len < 24) {
	        fprintf(stderr, "Warning: Pass phrase should be at least 24 characters long.\n");
	}
	if (len > 120) {
	        fprintf(stderr, "Warning: Pass phrase truncated.\n");
		len = 120;
	}
	memcpy(passphrase1+8, pass, len);
	memset(pass, 0, strlen(pass));
	pass = getpass("Reenter pass phrase: ");
	*len1 = strlen(pass);
	if (len1 == 0) 
		return -1;
	if (*len1 > 120) {
		*len1 = 120;
	}
	if (len != *len1) {
	        fprintf(stderr, "Error: Pass phrases are not the same.\n");
		memset(pass, 0, strlen(pass));
		return 0;
	}
	if (memcmp(passphrase1+8, pass, len)) {
	        fprintf(stderr, "Error: Pass phrases are not the same.\n");
		memset(pass, 0, strlen(pass));
		return 0;
	}
	if (master) {
		pass = getpass("New second master pass phrase: ");
	} else {
		pass = getpass("New second working pass phrase: ");
	}
	len = strlen(pass);
	if (len == 0) 
		return -1;
	if (len < 4) {
	        fprintf(stderr, "Error: Pass phrases too short.\n");
		memset(pass, 0, strlen(pass));
		return 0;
	}
	if (len < 24) {
	        fprintf(stderr, "Warning: Pass phrase should be at least 24 characters long.\n");
	}
	if (len > 120) {
	        fprintf(stderr, "Warning: Pass phrase truncated.\n");
		len = 120;
	}
	memcpy(passphrase2+8, pass, len);
	memset(pass, 0, strlen(pass));
	pass = getpass("Reenter pass phrase: ");
	*len2 = strlen(pass);
	if (len2 == 0) 
		return -1;
	if (*len2 > 120) {
		*len2 = 120;
	}
	if (len != *len2) {
	        fprintf(stderr, "Error: Pass phrases are not the same.\n");
		memset(pass, 0, strlen(pass));
		return 0;
	}
	if (memcmp(passphrase2+8, pass, len)) {
	        fprintf(stderr, "Error: Pass phrases are not the same.\n");
		memset(pass, 0, strlen(pass));
		return 0;
	}
	return 1;
}
