/*
 * getfilesize.c 
 *
 * Copyright 1998,9, 2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <linux/fs.h>          /* for BLKGETSIZE */

#include "ppddmount.h"

unsigned long getfilesize(int fd)
{
	unsigned long	tlength, size, blksz;
        struct stat     stats;

        if (fstat(fd, &stats) < 0) {
            perror("stat");
        }
        if (S_ISBLK(stats.st_mode)) {
            ioctl(fd, BLKGETSIZE, &size);
            tlength = size;
            ioctl(fd, BLKSSZGET, &blksz);
            if (blksz) tlength *= (blksz >> 9);
        } else {
	    tlength = stats.st_size;
	    if (tlength & 0x1ff) {
		return 0;
	    }
	    tlength >>= 9;
        }
	return tlength;  // in 512 byte sectors
}
