/*
 * find_ppdd_entry.c
 *
 * Copyright 1998,9,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#include "ppddmount.h"

int find_ppdd_entry(int f, const char *device, const char *file, 
		char *pass1, char *pass2, int *check)
{
	char 	line[257];
	char 	*linep;
	char 	dev[32];
	char 	fil[PP_NAME_SIZE];
        char 	*nl;
        char 	*sp;
	int 	len;
	int 	ok;
	FILE 	*fd;


        fd = fdopen (f, "r");
        if (!fd) {
            return 0;
        }

	dev[0] = 0;
	fil[0] = 0;
        ok = 0;

	for(;!ok;) {
		nl = fgets(line,256,fd);	
		if (nl == NULL) {
			fclose(fd);
			return 0;
		}
		line[255] = 0;
		len = strlen(line);
		line[len-1] = ' ';
		line[len] = 0;
		linep = line;

// if line begins with " it matches anything !!!!

		if (line[0] == '"') {
		    if (!(sp = strsep(&linep,"\""))) {
			pass1[0] = 0;
			pass2[0] = 0;
		    } else {
			if (!(sp = strsep(&linep,"\""))) {
			    pass1[0] = 0;
			    pass2[0] = 0;
			} else {
			    strncpy(pass1,sp,120);
			    pass1[119] = 0;
			    if (!(sp = strsep(&linep,"\""))) {
				pass2[0] = 0;
			    } else {
				if (!(sp = strsep(&linep,"\""))) {
				    pass2[0] = 0;
				} else {
				    strncpy(pass2,sp,120);
				    pass2[119] = 0;
				}
			    }
			}	
		    }

		}

		if (check) {
                    *check = 0;
		    if (line[0] == 'Y' || line[0] == 'y') {
			*check = 1;
			linep++;
		    }
		}
		if (!(sp = strsep(&linep,"/"))) {
			fclose(fd);
			return 1;
		}

		if (!(sp = strsep(&linep," "))) {
			fclose(fd);
			return 1;
		}
		strncpy(dev+1,sp,32);
		dev[0] = '/';
		dev[31] = 0;
		if (!(sp = strsep(&linep,"/"))) {
			fclose(fd);
			return 1;
		}
		if (!(sp = strsep(&linep," "))) {
			fclose(fd);
			return 1;
		}
		strncpy(fil+1,sp,63);
		fil[0] = '/';
		fil[63] = 0;

// if both device and file are missing it mathces the first line

                if (((!device) || !strcmp(dev,device))
                 && ((!file) || !strcmp(fil,file))) {
                    ok = 1;
                }
                if (ok) {
		    if (!(sp = strsep(&linep,"\""))) {
			pass1[0] = 0;
			pass2[0] = 0;
		    } else {
			if (!(sp = strsep(&linep,"\""))) {
				pass1[0] = 0;
				pass2[0] = 0;
			} else {
				strncpy(pass1,sp,120);
				pass1[119] = 0;
				if (!(sp = strsep(&linep,"\""))) {
					pass2[0] = 0;
				} else {
					if (!(sp = strsep(&linep,"\""))) {
						pass2[0] = 0;
					} else {
						strncpy(pass2,sp,120);
						pass2[119] = 0;
					}
				}
			}	
		    }
		}
	}

	memset(line, 0, sizeof(line));
	fclose(fd);
	return(1);
}
