/*
 * check_access.c  
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <sys/stat.h>

#include "ppddmount.h"


int check_access(const char *file, int fd, int fail) 
{
	char	*progname = "check_access";
	struct stat stats;
	int mode;
	int ok = 1;
	char *mess;
	char message[80];

	if (fail) {
		mess = "Error";
	} else {
		mess = "Warning";
	}

	if (fstat(fd,&stats)) {
		PPDDERROR(150)
		ok = 0;
	}

	if ((mode = stats.st_mode & 07777)) {
		sprintf(message,
	"%s: permissions on %s are %04o should be 0000\n",mess,file,mode);
		PPDDEMESS(151,message)
		ok = 0;
	}

	if (stats.st_uid) {
		sprintf(message,
	"%s: %s should be owned by root\n",mess,file);
		PPDDEMESS(152,message)
		ok = 0;
	}

	if (stats.st_gid) {
		sprintf(message,
	"%s: %s should be group root\n",file,file);
		PPDDEMESS(153,message)
		ok = 0;
	}
	return (ok);
}
