/*
 *  Blowfish_Encrypt_cbc.c
 * 
 *  Copyright 1997,8,9 2002 by Allan Latham <alatham@flexsys-group.com>  
 *
 *  Redistribution of this file is permitted under the GNU Public License.
 *
 *  Derived in part from the works of other authors who made those works
 *  available for use under GNU Public Licence.
 * 
 */

#include <linux/bf.h>

void Blowfish_Encrypt_cbc(Blowfish_Key key, const unsigned char* iv,
                const unsigned char* inbuf, unsigned char* outbuf, int length)
{
    int i;
    unsigned long niv[2];
    unsigned long* pi;

    memcpy(niv, iv, 8);
    pi = (unsigned long*)inbuf;

    for (i = 0; i < length; i += 8) {
        niv[0] ^= *pi;
        pi++;
        niv[1] ^= *pi;
        pi++;
        Blowfish_Encrypt(niv,niv,key);
        memcpy(outbuf+i, niv, 8);
    }
}
