/*
 * ppdduprev.c - changes an existing ppdd filesystem form
 *               one revision to another.
 *
 * Copyright 1999 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */
#include <sys/mount.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <getopt.h>
#include <errno.h>
#include <sys/ioctl.h>

#include "ppddmount.h"

static char *progname;

struct old_ukeys {
	unsigned char	encrypt_bkey[PPDDNKEYS][PPDDKEYSIZE];
	unsigned long	whitev[61];
};

struct old_control_block {
	unsigned char 	  iv[8];
	unsigned char 	  mkey[PPDDMKSIZE];
	unsigned char 	  x1[1];
	unsigned char     keys[sizeof(struct old_ukeys)];
	unsigned char 	  x2[12];
	unsigned char	  time_created[sizeof(time_t)];
	unsigned char 	  x3[1024
				 - 8 
				 - PPDDMKSIZE
				 - 1 
				 - sizeof(struct old_ukeys)
				 - 12
				 - sizeof(time_t)
				 - sizeof(unsigned short)
				 - 5
				 - 4];
	unsigned char	file_version[sizeof(unsigned short)];
	unsigned char 	x4[5];
	unsigned char 	crc[4];
};

static int make_old_crc (struct old_control_block *cblock, int check)
{
	int		ok = 1;
        unsigned long 	crc;

	crc = crc32(cblock->mkey, 1012);

	if (check == PPDD_CRC_CHECK) {
		ok = memcmp(cblock->crc, &crc, 4);
	} else {
		memcpy(cblock->crc, &crc, 4);
	}
	crc = 0;
	return(ok);
}

static int checkoldpass(int ffd, struct old_control_block* cblock,
							unsigned char* ukey)
{
	int	ok, len1, len2;
	unsigned char	passphrase1[136];
	unsigned char	passphrase2[136];
	unsigned char	iv[8];
	Blowfish_Key 	bkey;
	unsigned char	temp[PPDDMKSIZE];
	unsigned char	key[PPDDKEYSIZE];

	if (read_control_block(ffd, cblock)) {
		PPDDERROR(130)
		return(0);
	}

	memcpy (iv, cblock, 8);

	getoldpass(&len1, passphrase1, &len2, passphrase2);

	make_key(key, iv, &len1, passphrase1, &len2, passphrase2);
	Blowfish_ExpandUserKey(key, PPDDKEYSIZE, bkey);
	Blowfish_Decrypt_ecb(bkey, cblock->mkey, cblock->mkey, 1016);

	ok = 1;
	if (make_old_crc(cblock,PPDD_CRC_CHECK)) {
	    memcpy(temp, cblock->mkey, PPDDMKSIZE);
	    Blowfish_ExpandUserKey(&cblock->mkey[4], PPDDKEYSIZE, bkey);
	    if (read_control_block(ffd, cblock)) {
		PPDDERROR(133)
		ok = 0;
	    } else {
		Blowfish_Decrypt_ecb(bkey, cblock->mkey, cblock->mkey, 1016);
		if (make_old_crc(cblock,PPDD_CRC_CHECK)) {
			fprintf(stderr,
		"Wrong pass phrase or uninitialised crypto file system.\n");
			ok = 0;
		} else {
			memcpy(ukey, &temp[4], PPDDKEYSIZE);
		}
	    }
	} else {
		memcpy(ukey, key, PPDDKEYSIZE);
	}
	memset(temp, 0, PPDDMKSIZE);
	memset(key, 0, PPDDKEYSIZE);
	memset(bkey, 0, sizeof(bkey));
	memset(passphrase1, 0, sizeof(passphrase1));
	memset(passphrase2, 0, sizeof(passphrase2));
        len1 = len2 = 0;
	return (ok);
}

static int uprev_07_09(const char *file)
{

struct crypt_control_block 	cblock;
struct old_control_block 	oblock;
Blowfish_Key			bkey;
unsigned char			ukey[PPDDKEYSIZE];
int				fd, ok;

	if ((fd = open (file, O_RDWR)) < 0) {
		PPDDERROR(131)
		return 1;
	}

	check_access (file, fd, 0);

  	ok = checkoldpass(fd, &oblock, ukey);

	if (ok) {
		random_fill_fast(&cblock, sizeof(cblock));
	        memcpy(cblock.iv, oblock.iv, sizeof(cblock.iv));
	        memcpy(cblock.mkey, oblock.mkey, sizeof(cblock.mkey));
	        memcpy(&cblock.time_created, &oblock.time_created, 
							sizeof(time_t));
	        memcpy(&cblock.file_version, &oblock.file_version,
							sizeof(unsigned short));
		memcpy(cblock.keys+PPDDKEYSIZE, oblock.keys,
			((PPDDNKEYS*PPDDKEYSIZE)+(61*sizeof(unsigned long))));
	        make_crc(&cblock,PPDD_CRC_MAKE);
		cblock.flags &= 0xfc;
	        Blowfish_ExpandUserKey(cblock.keys, PPDDKEYSIZE, bkey);
	        Blowfish_Encrypt_ecb(bkey, &cblock.flags, &cblock.flags,
								CB5LENGTH);
	        Blowfish_ExpandUserKey(ukey, PPDDKEYSIZE, bkey);
	        Blowfish_Encrypt_ecb(bkey, cblock.mkey, cblock.mkey, CBMLENGTH);
	        if (write_control_block(fd, &cblock)) {
		    PPDDERROR(132)
		    ok = 0;
	        }
	}

	exit (1 - ok);
}

static int the_same(const char *orev, const char *nrev)
{
	printf("Revisions %s and %s are the same - nothing done\n\n",
								orev, nrev);
	exit (0);
}

static int compatible(const char *orev, const char *nrev)
{
	printf("Revisions %s and %s are compatible - nothing done\n\n",
								orev, nrev);
	exit (0);
}

static int usage(void)
{
	fprintf(stderr, "usage:\n\
%s old_revision new_revision file|device \n\n\
example:\n\
%s 0.7 1.0 /dev/hda1\n\n\
supports:\n\
 0.7 -> 0.8 already compatible\n\
 0.9 -> 1.0 already compatible\n\
 0.7 -> 1.0\n\
 0.8 -> 1.0\n\n", progname, progname);

	exit(1);
}

int main(int argc, char **argv)
{
	progname = "ppdduprev";

	if(ppdd_intro(progname)) usage();

	if (argc != 4) usage();

	if (!(strcmp(argv[1],argv[2]))) the_same (argv[1], argv[2]);

	if (!(strcmp("0.7",argv[1]))
	 && !(strcmp("0.8",argv[2]))) compatible (argv[1], argv[2]);

	if (!(strcmp("0.9",argv[1]))
	 && !(strcmp("1.0",argv[2]))) compatible (argv[1], argv[2]);

	if (!(strcmp("0.7",argv[1]))
	 && !(strcmp("1.0",argv[2]))) uprev_07_09 (argv[3]);

	if (!(strcmp("0.8",argv[1]))
	 && !(strcmp("1.0",argv[2]))) uprev_07_09 (argv[3]);

	usage();

	exit (1);
}

